/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.exceptions.OperationNotSupportedException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IODataSampleRxIndicatorPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 12;
    private final XBee64BitAddress sourceAddress64;
    private final XBee16BitAddress sourceAddress16;
    private IOSample ioSample;
    private final int receiveOptions;
    private byte[] rfData;
    private Logger logger;

    public static IODataSampleRxIndicatorPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("IO Data Sample RX Indicator packet payload cannot be null.");
        }
        if (payload.length < 12) {
            throw new IllegalArgumentException("Incomplete IO Data Sample RX Indicator packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.IO_DATA_SAMPLE_RX_INDICATOR.getValue()) {
            throw new IllegalArgumentException("Payload is not a IO Data Sample RX Indicator packet.");
        }
        int index = 1;
        XBee64BitAddress sourceAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, index, index + 8));
        XBee16BitAddress sourceAddress16 = new XBee16BitAddress(payload[index += 8] & 0xFF, payload[index + 1] & 0xFF);
        int receiveOptions = payload[index += 2] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new IODataSampleRxIndicatorPacket(sourceAddress64, sourceAddress16, receiveOptions, data);
    }

    public IODataSampleRxIndicatorPacket(XBee64BitAddress sourceAddress64, XBee16BitAddress sourceAddress16, int receiveOptions, byte[] rfData) {
        super(APIFrameType.IO_DATA_SAMPLE_RX_INDICATOR);
        if (sourceAddress64 == null) {
            throw new NullPointerException("64-bit source address cannot be null.");
        }
        if (sourceAddress16 == null) {
            throw new NullPointerException("16-bit source address cannot be null.");
        }
        if (receiveOptions < 0 || receiveOptions > 255) {
            throw new IllegalArgumentException("Receive options value must be between 0 and 255.");
        }
        this.sourceAddress64 = sourceAddress64;
        this.sourceAddress16 = sourceAddress16;
        this.receiveOptions = receiveOptions;
        this.rfData = rfData;
        this.ioSample = rfData != null && rfData.length >= 5 ? new IOSample(rfData) : null;
        this.logger = LoggerFactory.getLogger(IODataSampleRxIndicatorPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.sourceAddress64.getValue());
            os.write(this.sourceAddress16.getValue());
            os.write(this.receiveOptions);
            if (this.rfData != null) {
                os.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return ByteUtils.isBitEnabled(this.getReceiveOptions(), 1);
    }

    public XBee64BitAddress get64bitSourceAddress() {
        return this.sourceAddress64;
    }

    public XBee16BitAddress get16bitSourceAddress() {
        return this.sourceAddress16;
    }

    public int getReceiveOptions() {
        return this.receiveOptions;
    }

    public IOSample getIOSample() {
        return this.ioSample;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
        this.ioSample = rfData != null && rfData.length >= 5 ? new IOSample(this.rfData) : null;
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit source address", HexUtils.prettyHexString(this.sourceAddress64.toString()));
        parameters.put("16-bit source address", HexUtils.prettyHexString(this.sourceAddress16.toString()));
        parameters.put("Receive options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.receiveOptions, 1)));
        if (this.ioSample != null) {
            int i;
            parameters.put("Number of samples", HexUtils.prettyHexString(HexUtils.integerToHexString(1, 1)));
            parameters.put("Digital channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getDigitalMask(), 2)));
            parameters.put("Analog channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getAnalogMask(), 1)));
            for (i = 0; i < 16; ++i) {
                if (!this.ioSample.hasDigitalValue(IOLine.getDIO(i))) continue;
                parameters.put(IOLine.getDIO(i).getName() + " digital value", this.ioSample.getDigitalValue(IOLine.getDIO(i)).getName());
            }
            for (i = 0; i < 6; ++i) {
                if (!this.ioSample.hasAnalogValue(IOLine.getDIO(i))) continue;
                parameters.put(IOLine.getDIO(i).getName() + " analog value", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getAnalogValue(IOLine.getDIO(i)), 2)));
            }
            if (this.ioSample.hasPowerSupplyValue()) {
                try {
                    parameters.put("Power supply value", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getPowerSupplyValue(), 2)));
                }
                catch (OperationNotSupportedException operationNotSupportedException) {}
            }
        } else if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

