/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.ModemStatusEvent;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.util.LinkedHashMap;

public class ModemStatusPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 2;
    private ModemStatusEvent modemStatusEvent;

    public static ModemStatusPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Modem Status packet payload cannot be null.");
        }
        if (payload.length < 2) {
            throw new IllegalArgumentException("Incomplete Modem Status packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.MODEM_STATUS.getValue()) {
            throw new IllegalArgumentException("Payload is not a Modem Status packet.");
        }
        int status = payload[1] & 0xFF;
        ModemStatusEvent modemStatusEvent = ModemStatusEvent.get(status);
        return new ModemStatusPacket(modemStatusEvent);
    }

    public ModemStatusPacket(ModemStatusEvent modemStatusEvent) {
        super(APIFrameType.MODEM_STATUS);
        if (modemStatusEvent == null) {
            throw new NullPointerException("Modem Status event cannot be null.");
        }
        this.modemStatusEvent = modemStatusEvent;
    }

    @Override
    public byte[] getAPIPacketSpecificData() {
        byte[] data = new byte[]{(byte)(this.modemStatusEvent.getId() & 0xFF)};
        return data;
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    public ModemStatusEvent getStatus() {
        return this.modemStatusEvent;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.modemStatusEvent.getId(), 1)) + " (" + this.modemStatusEvent.getDescription() + ")");
        return parameters;
    }
}

