/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 12;
    private final XBee64BitAddress sourceAddress64;
    private final XBee16BitAddress sourceAddress16;
    private final int receiveOptions;
    private byte[] rfData;
    private Logger logger;

    public static ReceivePacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Receive packet payload cannot be null.");
        }
        if (payload.length < 12) {
            throw new IllegalArgumentException("Incomplete Receive packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.RECEIVE_PACKET.getValue()) {
            throw new IllegalArgumentException("Payload is not a Receive packet.");
        }
        int index = 1;
        XBee64BitAddress sourceAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, index, index + 8));
        XBee16BitAddress sourceAddress16 = new XBee16BitAddress(payload[index += 8] & 0xFF, payload[index + 1] & 0xFF);
        int receiveOptions = payload[index += 2] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new ReceivePacket(sourceAddress64, sourceAddress16, receiveOptions, data);
    }

    public ReceivePacket(XBee64BitAddress sourceAddress64, XBee16BitAddress sourceAddress16, int receiveOptions, byte[] rfData) {
        super(APIFrameType.RECEIVE_PACKET);
        if (sourceAddress64 == null) {
            throw new NullPointerException("64-bit source address cannot be null.");
        }
        if (sourceAddress16 == null) {
            throw new NullPointerException("16-bit source address cannot be null.");
        }
        if (receiveOptions < 0 || receiveOptions > 255) {
            throw new IllegalArgumentException("Receive options value must be between 0 and 255.");
        }
        this.sourceAddress64 = sourceAddress64;
        this.sourceAddress16 = sourceAddress16;
        this.receiveOptions = receiveOptions;
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(ReceivePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.sourceAddress64.getValue());
            data.write(this.sourceAddress16.getValue());
            data.write(this.receiveOptions);
            if (this.rfData != null) {
                data.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return ByteUtils.isBitEnabled(this.getReceiveOptions(), 1);
    }

    public XBee64BitAddress get64bitSourceAddress() {
        return this.sourceAddress64;
    }

    public XBee16BitAddress get16bitSourceAddress() {
        return this.sourceAddress16;
    }

    public int getReceiveOptions() {
        return this.receiveOptions;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit source address", HexUtils.prettyHexString(this.sourceAddress64.toString()));
        parameters.put("16-bit source address", HexUtils.prettyHexString(this.sourceAddress16.toString()));
        parameters.put("Receive options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.receiveOptions, 1)));
        if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

