/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteATCommandPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 15;
    private final XBee64BitAddress destAddress64;
    private final XBee16BitAddress destAddress16;
    private final int transmitOptions;
    private final String command;
    private byte[] parameter;
    private Logger logger;

    public static RemoteATCommandPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Remote AT Command packet payload cannot be null.");
        }
        if (payload.length < 15) {
            throw new IllegalArgumentException("Incomplete Remote AT Command packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.REMOTE_AT_COMMAND_REQUEST.getValue()) {
            throw new IllegalArgumentException("Payload is not a Remote AT Command packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBee64BitAddress destAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, ++index, index + 8));
        XBee16BitAddress destAddress16 = new XBee16BitAddress(payload[index += 8] & 0xFF, payload[index + 1] & 0xFF);
        int transmitOptions = payload[index += 2] & 0xFF;
        String command = new String(new byte[]{payload[++index], payload[index + 1]});
        byte[] parameterData = null;
        if ((index += 2) < payload.length) {
            parameterData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RemoteATCommandPacket(frameID, destAddress64, destAddress16, transmitOptions, command, parameterData);
    }

    public RemoteATCommandPacket(int frameID, XBee64BitAddress destAddress64, XBee16BitAddress destAddress16, int transmitOptions, String command, String parameter) {
        super(APIFrameType.REMOTE_AT_COMMAND_REQUEST);
        if (destAddress64 == null) {
            throw new NullPointerException("64-bit destination address cannot be null.");
        }
        if (destAddress16 == null) {
            throw new NullPointerException("16-bit destination address cannot be null.");
        }
        if (command == null) {
            throw new NullPointerException("AT command cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (transmitOptions < 0 || transmitOptions > 255) {
            throw new IllegalArgumentException("Options value must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.destAddress64 = destAddress64;
        this.destAddress16 = destAddress16;
        this.transmitOptions = transmitOptions;
        this.command = command;
        if (parameter != null) {
            this.parameter = parameter.getBytes();
        }
        this.logger = LoggerFactory.getLogger(RemoteATCommandPacket.class);
    }

    public RemoteATCommandPacket(int frameID, XBee64BitAddress destAddress64, XBee16BitAddress destAddress16, int transmitOptions, String command, byte[] parameter) {
        super(APIFrameType.REMOTE_AT_COMMAND_REQUEST);
        if (destAddress64 == null) {
            throw new NullPointerException("64-bit destination address cannot be null.");
        }
        if (destAddress16 == null) {
            throw new NullPointerException("16-bit destination address cannot be null.");
        }
        if (command == null) {
            throw new NullPointerException("AT command cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (transmitOptions < 0 || transmitOptions > 255) {
            throw new IllegalArgumentException("Options value must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.destAddress64 = destAddress64;
        this.destAddress16 = destAddress16;
        this.transmitOptions = transmitOptions;
        this.command = command;
        this.parameter = parameter;
        this.logger = LoggerFactory.getLogger(RemoteATCommandPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.destAddress64.getValue());
            data.write(this.destAddress16.getValue());
            data.write(this.transmitOptions);
            data.write(ByteUtils.stringToByteArray(this.command));
            if (this.parameter != null) {
                data.write(this.parameter);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return this.get64bitDestinationAddress().equals(XBee64BitAddress.BROADCAST_ADDRESS) || this.get16bitDestinationAddress().equals(XBee16BitAddress.BROADCAST_ADDRESS);
    }

    public XBee64BitAddress get64bitDestinationAddress() {
        return this.destAddress64;
    }

    public XBee16BitAddress get16bitDestinationAddress() {
        return this.destAddress16;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public String getCommand() {
        return this.command;
    }

    public void setParameter(String parameter) {
        this.parameter = (byte[])(parameter == null ? null : parameter.getBytes());
    }

    public void setParameter(byte[] parameter) {
        this.parameter = parameter;
    }

    public byte[] getParameter() {
        return this.parameter;
    }

    public String getParameterAsString() {
        if (this.parameter == null) {
            return null;
        }
        return new String(this.parameter);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit dest. address", HexUtils.prettyHexString(this.destAddress64.toString()));
        parameters.put("16-bit dest. address", HexUtils.prettyHexString(this.destAddress16.toString()));
        parameters.put("Command options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        if (this.parameter != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)) + " (" + new String(this.parameter) + ")");
            } else {
                parameters.put("Parameter", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.parameter)));
            }
        }
        return parameters;
    }
}

