/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.common;

import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteATCommandResponsePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 15;
    private final XBee64BitAddress sourceAddress64;
    private final XBee16BitAddress sourceAddress16;
    private final ATCommandStatus status;
    private final String command;
    private byte[] commandValue;
    private Logger logger;

    public static RemoteATCommandResponsePacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("Remote AT Command Response packet payload cannot be null.");
        }
        if (payload.length < 15) {
            throw new IllegalArgumentException("Incomplete Remote AT Command Response packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.REMOTE_AT_COMMAND_RESPONSE.getValue()) {
            throw new IllegalArgumentException("Payload is not a Remote AT Command Response packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBee64BitAddress sourceAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, ++index, index + 8));
        XBee16BitAddress sourceAddress16 = new XBee16BitAddress(payload[index += 8] & 0xFF, payload[index + 1] & 0xFF);
        String command = new String(new byte[]{payload[index += 2], payload[index + 1]});
        int status = payload[index += 2] & 0xFF;
        byte[] commandData = null;
        if (++index < payload.length) {
            commandData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RemoteATCommandResponsePacket(frameID, sourceAddress64, sourceAddress16, command, ATCommandStatus.get(status), commandData);
    }

    public RemoteATCommandResponsePacket(int frameID, XBee64BitAddress sourceAddress64, XBee16BitAddress sourceAddress16, String command, ATCommandStatus status, byte[] commandValue) {
        super(APIFrameType.REMOTE_AT_COMMAND_RESPONSE);
        if (sourceAddress64 == null) {
            throw new NullPointerException("64-bit source address cannot be null.");
        }
        if (sourceAddress16 == null) {
            throw new NullPointerException("16-bit source address cannot be null.");
        }
        if (command == null) {
            throw new NullPointerException("AT command cannot be null.");
        }
        if (status == null) {
            throw new NullPointerException("AT command status cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.sourceAddress64 = sourceAddress64;
        this.sourceAddress16 = sourceAddress16;
        this.command = command;
        this.status = status;
        this.commandValue = commandValue;
        this.logger = LoggerFactory.getLogger(RemoteATCommandResponsePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.sourceAddress64.getValue());
            data.write(this.sourceAddress16.getValue());
            data.write(ByteUtils.stringToByteArray(this.command));
            data.write(this.status.getId());
            if (this.commandValue != null) {
                data.write(this.commandValue);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    public XBee64BitAddress get64bitSourceAddress() {
        return this.sourceAddress64;
    }

    public XBee16BitAddress get16bitSourceAddress() {
        return this.sourceAddress16;
    }

    public ATCommandStatus getStatus() {
        return this.status;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommandValue(String commandValue) {
        this.commandValue = (byte[])(commandValue == null ? null : commandValue.getBytes());
    }

    public void setCommandValue(byte[] commandValue) {
        this.commandValue = commandValue;
    }

    public byte[] getCommandValue() {
        return this.commandValue;
    }

    public String getCommandValueAsString() {
        if (this.commandValue == null) {
            return null;
        }
        return new String(this.commandValue);
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit source address", HexUtils.prettyHexString(this.sourceAddress64.toString()));
        parameters.put("16-bit source address", HexUtils.prettyHexString(this.sourceAddress16.toString()));
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.status.getId(), 1)) + " (" + this.status.getDescription() + ")");
        if (this.commandValue != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)) + " (" + new String(this.commandValue) + ")");
            } else {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)));
            }
        }
        return parameters;
    }
}

