/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.devicecloud;

import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceRequestPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 5;
    private static final String ERROR_PAYLOAD_NULL = "Device Request packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Device Request packet.";
    private static final String ERROR_NOT_VALID = "Payload is not a Device Request packet.";
    private static final String ERROR_REQUEST_ID_ILLEGAL = "Device request ID must be between 0 and 255.";
    private static final String ERROR_TARGET_ILLEGAL = "Target lenght cannot exceed 255 bytes.";
    private int requestID;
    private final int transport = 0;
    private final int flags = 0;
    private String target;
    private byte[] requestData;
    private Logger logger;

    public static DeviceRequestPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 5) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.DEVICE_REQUEST.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID);
        }
        int index = 1;
        int requestID = payload[index] & 0xFF;
        ++index;
        ++index;
        int targetLength = payload[++index] & 0xFF;
        ++index;
        String target = null;
        if (targetLength > 0) {
            target = new String(Arrays.copyOfRange(payload, index, index + targetLength));
            index += targetLength;
        }
        byte[] data = null;
        if (index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new DeviceRequestPacket(requestID, target, data);
    }

    public DeviceRequestPacket(int requestID, String target, byte[] requestData) {
        super(APIFrameType.DEVICE_REQUEST);
        if (requestID < 0 || requestID > 255) {
            throw new IllegalArgumentException(ERROR_REQUEST_ID_ILLEGAL);
        }
        if (target != null && target.length() > 255) {
            throw new IllegalArgumentException(ERROR_TARGET_ILLEGAL);
        }
        this.requestID = requestID;
        this.target = target;
        this.requestData = requestData;
        this.logger = LoggerFactory.getLogger(DeviceRequestPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.requestID);
            os.write(0);
            os.write(0);
            if (this.target != null) {
                os.write(this.target.length());
                os.write(this.target.getBytes());
            } else {
                os.write(0);
            }
            if (this.requestData != null) {
                os.write(this.requestData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setRequestID(int requestID) {
        if (requestID < 0 || requestID > 255) {
            throw new IllegalArgumentException(ERROR_REQUEST_ID_ILLEGAL);
        }
        this.requestID = requestID;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public int getTransport() {
        return 0;
    }

    public int getFlags() {
        return 0;
    }

    public void setRequestTarget(String target) {
        if (target != null && target.length() > 255) {
            throw new IllegalArgumentException(ERROR_TARGET_ILLEGAL);
        }
        this.target = target;
    }

    public String getRequestTarget() {
        return this.target;
    }

    public void setRequestData(byte[] requestData) {
        this.requestData = requestData;
    }

    public byte[] getRequestData() {
        return this.requestData;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Device Request ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.requestID, 1)) + " (" + this.requestID + ")");
        parameters.put("Transport", HexUtils.prettyHexString(HexUtils.integerToHexString(0, 1)));
        parameters.put("Flags", HexUtils.prettyHexString(HexUtils.integerToHexString(0, 1)));
        if (this.target != null) {
            parameters.put("Target length", HexUtils.prettyHexString(HexUtils.integerToHexString(this.target.length(), 1)) + " (" + this.target.length() + ")");
            parameters.put("Target", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.target.getBytes())) + " (" + this.target + ")");
        } else {
            parameters.put("Target length", HexUtils.prettyHexString(HexUtils.integerToHexString(0, 1)) + " (0)");
        }
        if (this.requestData != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.requestData)));
        }
        return parameters;
    }
}

