/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.devicecloud;

import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceResponsePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 4;
    private static final String ERROR_PAYLOAD_NULL = "Device Response packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Device Response packet.";
    private static final String ERROR_NOT_VALID = "Payload is not a Device Response packet.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_REQUEST_ID_ILLEGAL = "Device request ID must be between 0 and 255.";
    private int requestID;
    private byte[] responseData;
    private Logger logger;

    public static DeviceResponsePacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 4) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.DEVICE_RESPONSE.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        int requestID = payload[++index] & 0xFF;
        ++index;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new DeviceResponsePacket(frameID, requestID, data);
    }

    public DeviceResponsePacket(int frameID, int requestID, byte[] responseData) {
        super(APIFrameType.DEVICE_RESPONSE);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (requestID < 0 || requestID > 255) {
            throw new IllegalArgumentException(ERROR_REQUEST_ID_ILLEGAL);
        }
        this.frameID = frameID;
        this.requestID = requestID;
        this.responseData = responseData;
        this.logger = LoggerFactory.getLogger(DeviceResponsePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.requestID);
            os.write(0);
            if (this.responseData != null) {
                os.write(this.responseData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setRequestID(int requestID) {
        if (requestID < 0 || requestID > 255) {
            throw new IllegalArgumentException(ERROR_REQUEST_ID_ILLEGAL);
        }
        this.requestID = requestID;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setResponseData(byte[] responseData) {
        this.responseData = responseData;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Device Request ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.requestID, 1)) + " (" + this.requestID + ")");
        parameters.put("Reserved", "00");
        if (this.responseData != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.responseData)));
        }
        return parameters;
    }
}

