/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.devicecloud;

import com.digi.xbee.api.models.DeviceCloudStatus;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.util.LinkedHashMap;

public class SendDataResponsePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 3;
    private static final String ERROR_PAYLOAD_NULL = "Send Data Response packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete Send Data Response packet.";
    private static final String ERROR_NOT_VALID = "Payload is not a Send Data Response packet.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_STATUS_NULL = "Status cannot be null.";
    private DeviceCloudStatus status;

    public static SendDataResponsePacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 3) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.SEND_DATA_RESPONSE.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        DeviceCloudStatus status = DeviceCloudStatus.get(payload[++index] & 0xFF);
        return new SendDataResponsePacket(frameID, status);
    }

    public SendDataResponsePacket(int frameID, DeviceCloudStatus status) {
        super(APIFrameType.SEND_DATA_RESPONSE);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (status == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        this.frameID = frameID;
        this.status = status;
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.status.getID());
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setStatus(DeviceCloudStatus status) {
        if (status == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        this.status = status;
    }

    public DeviceCloudStatus getStatus() {
        return this.status;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.status.getID(), 1)) + " (" + this.status.getName() + ")");
        return parameters;
    }
}

