/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.ip;

import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TXTLSProfilePacket
extends XBeeAPIPacket {
    public static final int OPTIONS_CLOSE_SOCKET = 2;
    public static final int OPTIONS_LEAVE_SOCKET_OPEN = 0;
    private static final int MIN_API_PAYLOAD_LENGTH = 12;
    private static final String ERROR_PAYLOAD_NULL = "TX request with TLS profile packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete TX request with TLS profile packet.";
    private static final String ERROR_NOT_TXTLS = "Payload is not a TX request with TLS profile packet.";
    private static final String ERROR_DEST_ADDR_NULL = "Destination address cannot be null.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_PORT_ILLEGAL = "Port must be between 0 and 65535.";
    private static final String ERROR_PROFILE_ILLEGAL = "Profile must be between 0 and 255.";
    private static final String ERROR_OPTIONS_INVALID = "Transmit options can only be 2 or 0.";
    private Inet4Address destAddress;
    private int destPort;
    private int sourcePort;
    private int transmitOptions;
    private int profile;
    private byte[] data;
    private Logger logger;

    public static TXTLSProfilePacket createPacket(byte[] payload) {
        Inet4Address destAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 12) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.TX_REQUEST_TLS_PROFILE.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_TXTLS);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        ++index;
        try {
            destAddress = (Inet4Address)Inet4Address.getByAddress(Arrays.copyOfRange(payload, index, index + 4));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int destPort = (payload[index += 4] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int sourcePort = (payload[index += 2] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int profile = payload[index += 2] & 0xFF;
        int transmitOptions = payload[++index] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new TXTLSProfilePacket(frameID, destAddress, destPort, sourcePort, profile, transmitOptions, data);
    }

    public TXTLSProfilePacket(int frameID, Inet4Address destAddress, int destPort, int sourcePort, int profile, int transmitOptions, byte[] data) {
        super(APIFrameType.TX_REQUEST_TLS_PROFILE);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException(ERROR_PORT_ILLEGAL);
        }
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException(ERROR_PORT_ILLEGAL);
        }
        if (transmitOptions != 2 && transmitOptions != 0) {
            throw new IllegalArgumentException(ERROR_OPTIONS_INVALID);
        }
        if (profile < 0 || profile > 255) {
            throw new IllegalArgumentException(ERROR_PROFILE_ILLEGAL);
        }
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        this.frameID = frameID;
        this.destAddress = destAddress;
        this.destPort = destPort;
        this.sourcePort = sourcePort;
        this.profile = profile;
        this.transmitOptions = transmitOptions;
        this.data = data;
        this.logger = LoggerFactory.getLogger(TXTLSProfilePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.destAddress.getAddress());
            os.write(this.destPort >> 8);
            os.write(this.destPort);
            os.write(this.sourcePort >> 8);
            os.write(this.sourcePort);
            os.write(this.profile);
            os.write(this.transmitOptions);
            if (this.data != null) {
                os.write(this.data);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return this.destAddress.getHostAddress().equals("255.255.255.255");
    }

    public Inet4Address getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(Inet4Address destAddress) {
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        this.destAddress = destAddress;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException(ERROR_PORT_ILLEGAL);
        }
        this.destPort = destPort;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException(ERROR_PORT_ILLEGAL);
        }
        this.sourcePort = sourcePort;
    }

    public int getProfile() {
        return this.profile;
    }

    public void setProfile(int profile) {
        if (profile < 0 || profile > 255) {
            throw new IllegalArgumentException(ERROR_PROFILE_ILLEGAL);
        }
        this.profile = profile;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public void setTransmitOptions(int transmitOptions) {
        if (transmitOptions != 2 && transmitOptions != 0) {
            throw new IllegalArgumentException(ERROR_OPTIONS_INVALID);
        }
        this.transmitOptions = transmitOptions;
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void setData(byte[] data) {
        this.data = (byte[])(data == null ? null : Arrays.copyOf(data, data.length));
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Destination address", HexUtils.prettyHexString(this.destAddress.getAddress()) + " (" + this.destAddress.getHostAddress() + ")");
        parameters.put("Destination port", HexUtils.prettyHexString(HexUtils.integerToHexString(this.destPort, 2)) + " (" + this.destPort + ")");
        parameters.put("Source port", HexUtils.prettyHexString(HexUtils.integerToHexString(this.sourcePort, 2)) + " (" + this.sourcePort + ")");
        parameters.put("Profile", HexUtils.prettyHexString(HexUtils.integerToHexString(this.profile, 1)) + " (" + this.profile + ")");
        parameters.put("Transmit options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        if (this.data != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data)));
        }
        return parameters;
    }
}

