/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.raw;

import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.packet.raw.RX64Packet;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RX64IOPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 11;
    private final XBee64BitAddress sourceAddress64;
    private IOSample ioSample;
    private ArrayList<IOSample> ioSamples;
    private final int rssi;
    private final int receiveOptions;
    private byte[] rfData;
    private Logger logger;

    public static RX64IOPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("RX64 Address IO packet payload cannot be null.");
        }
        if (payload.length < 11) {
            throw new IllegalArgumentException("Incomplete RX64 Address IO packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.RX_IO_64.getValue()) {
            throw new IllegalArgumentException("Payload is not a RX64 Address IO packet.");
        }
        int index = 1;
        XBee64BitAddress sourceAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, index, index + 8));
        int rssi = payload[index += 8] & 0xFF;
        int receiveOptions = payload[++index] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RX64IOPacket(sourceAddress64, rssi, receiveOptions, data);
    }

    public RX64IOPacket(XBee64BitAddress sourceAddress64, int rssi, int receiveOptions, byte[] rfData) {
        super(APIFrameType.RX_IO_64);
        if (sourceAddress64 == null) {
            throw new NullPointerException("64-bit source address cannot be null.");
        }
        if (rssi < 0 || rssi > 255) {
            throw new IllegalArgumentException("RSSI value must be between 0 and 255.");
        }
        if (receiveOptions < 0 || receiveOptions > 255) {
            throw new IllegalArgumentException("Receive options value must be between 0 and 255.");
        }
        this.sourceAddress64 = sourceAddress64;
        this.rssi = rssi;
        this.receiveOptions = receiveOptions;
        this.rfData = rfData;
        if (rfData != null && rfData.length >= 5) {
            try {
                this.ioSamples = IOSample.parseIOSamples(rfData);
                if (this.ioSamples.size() > 0) {
                    this.ioSample = this.ioSamples.get(0);
                }
            }
            catch (Exception exception) {}
        } else {
            this.ioSample = null;
        }
        this.logger = LoggerFactory.getLogger(RX64Packet.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.sourceAddress64.getValue());
            os.write(this.rssi);
            os.write(this.receiveOptions);
            if (this.rfData != null) {
                os.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return ByteUtils.isBitEnabled(this.getReceiveOptions(), 1) || ByteUtils.isBitEnabled(this.getReceiveOptions(), 2);
    }

    public XBee64BitAddress get64bitSourceAddress() {
        return this.sourceAddress64;
    }

    public int getRSSI() {
        return this.rssi;
    }

    public int getReceiveOptions() {
        return this.receiveOptions;
    }

    public IOSample getIOSample() {
        return this.ioSample;
    }

    public ArrayList<IOSample> getIOSamples() {
        return this.ioSamples;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
        this.ioSample = rfData != null && rfData.length >= 5 ? new IOSample(this.rfData) : null;
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit source address", HexUtils.prettyHexString(this.sourceAddress64.toString()));
        parameters.put("RSSI", HexUtils.prettyHexString(HexUtils.integerToHexString(this.rssi, 1)));
        parameters.put("Options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.receiveOptions, 1)));
        if (this.ioSamples != null && !this.ioSamples.isEmpty()) {
            parameters.put("Number of samples", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSamples.size(), 1)) + " (" + this.ioSamples.size() + ")");
            parameters.put("Digital channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSamples.get(0).getDigitalMask(), 2)));
            parameters.put("Analog channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSamples.get(0).getAnalogMask(), 2)));
            for (int index = 0; index < this.ioSamples.size(); ++index) {
                int i;
                IOSample sample = this.ioSamples.get(index);
                StringBuilder builder = new StringBuilder();
                for (i = 0; i < 16; ++i) {
                    if (!sample.hasDigitalValue(IOLine.getDIO(i))) continue;
                    builder.append("- " + IOLine.getDIO(i).getName() + " digital value: " + sample.getDigitalValue(IOLine.getDIO(i)).getName() + "\n");
                }
                for (i = 0; i < 6; ++i) {
                    if (!sample.hasAnalogValue(IOLine.getDIO(i))) continue;
                    builder.append("- " + IOLine.getDIO(i).getName() + " analog value: " + HexUtils.prettyHexString(HexUtils.integerToHexString(sample.getAnalogValue(IOLine.getDIO(i)), 2)) + " (" + sample.getAnalogValue(IOLine.getDIO(i)) + ")\n");
                }
                parameters.put("Sample " + (index + 1), builder.toString());
            }
        } else if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

