/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.raw;

import com.digi.xbee.api.models.XBee64BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RX64Packet
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 11;
    private final XBee64BitAddress sourceAddress64;
    private final int rssi;
    private final int receiveOptions;
    private byte[] rfData;
    private Logger logger;

    public static RX64Packet createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("RX64 packet payload cannot be null.");
        }
        if (payload.length < 11) {
            throw new IllegalArgumentException("Incomplete RX64 packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.RX_64.getValue()) {
            throw new IllegalArgumentException("Payload is not a RX64 packet.");
        }
        int index = 1;
        XBee64BitAddress sourceAddress64 = new XBee64BitAddress(Arrays.copyOfRange(payload, index, index + 8));
        int signalStrength = payload[index += 8] & 0xFF;
        int receiveOptions = payload[++index] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RX64Packet(sourceAddress64, signalStrength, receiveOptions, data);
    }

    public RX64Packet(XBee64BitAddress sourceAddress64, int rssi, int receiveOptions, byte[] rfData) {
        super(APIFrameType.RX_64);
        if (sourceAddress64 == null) {
            throw new NullPointerException("64-bit source address cannot be null.");
        }
        if (rssi < 0 || rssi > 255) {
            throw new IllegalArgumentException("RSSI value must be between 0 and 255.");
        }
        if (receiveOptions < 0 || receiveOptions > 255) {
            throw new IllegalArgumentException("Receive options value must be between 0 and 255.");
        }
        this.sourceAddress64 = sourceAddress64;
        this.rssi = rssi;
        this.receiveOptions = receiveOptions;
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(RX64Packet.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.sourceAddress64.getValue());
            os.write(this.rssi);
            os.write(this.receiveOptions);
            if (this.rfData != null) {
                os.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return ByteUtils.isBitEnabled(this.getReceiveOptions(), 1) || ByteUtils.isBitEnabled(this.getReceiveOptions(), 2);
    }

    public XBee64BitAddress get64bitSourceAddress() {
        return this.sourceAddress64;
    }

    public int getRSSI() {
        return this.rssi;
    }

    public int getReceiveOptions() {
        return this.receiveOptions;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("64-bit source address", HexUtils.prettyHexString(this.sourceAddress64.toString()));
        parameters.put("RSSI", HexUtils.prettyHexString(HexUtils.integerToHexString(this.rssi, 1)));
        parameters.put("Options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.receiveOptions, 1)));
        if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

