/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.raw;

import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TX16Packet
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 5;
    private final int transmitOptions;
    private final XBee16BitAddress destAddress16;
    private byte[] rfData;
    private Logger logger;

    public static TX16Packet createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("TX16 Request packet payload cannot be null.");
        }
        if (payload.length < 5) {
            throw new IllegalArgumentException("Incomplete TX16 Request packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.TX_16.getValue()) {
            throw new IllegalArgumentException("Payload is not a TX16 Request packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBee16BitAddress destAddress16 = new XBee16BitAddress(payload[++index] & 0xFF, payload[index + 1] & 0xFF);
        int transmitOptions = payload[index += 2] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new TX16Packet(frameID, destAddress16, transmitOptions, data);
    }

    public TX16Packet(int frameID, XBee16BitAddress destAddress16, int transmitOptions, byte[] rfData) {
        super(APIFrameType.TX_16);
        if (destAddress16 == null) {
            throw new NullPointerException("16-bit destination address cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        if (transmitOptions < 0 || transmitOptions > 255) {
            throw new IllegalArgumentException("Transmit options must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.destAddress16 = destAddress16;
        this.transmitOptions = transmitOptions;
        this.rfData = rfData;
        this.logger = LoggerFactory.getLogger(TX16Packet.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.destAddress16.getValue());
            os.write(this.transmitOptions);
            if (this.rfData != null) {
                os.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return this.get16bitDestinationAddress().equals(XBee16BitAddress.BROADCAST_ADDRESS);
    }

    public XBee16BitAddress get16bitDestinationAddress() {
        return this.destAddress16;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("16-bit dest. address", HexUtils.prettyHexString(this.destAddress16.toString()));
        parameters.put("Options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

