/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.raw;

import com.digi.xbee.api.models.XBeeTransmitStatus;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.util.LinkedHashMap;

public class TXStatusPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 3;
    private final XBeeTransmitStatus transmitStatus;

    public static TXStatusPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("TX Status packet payload cannot be null.");
        }
        if (payload.length < 3) {
            throw new IllegalArgumentException("Incomplete TX Status packet.");
        }
        if ((payload[0] & 0xFF) != APIFrameType.TX_STATUS.getValue()) {
            throw new IllegalArgumentException("Payload is not a TX Status packet.");
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        int status = payload[++index] & 0xFF;
        return new TXStatusPacket(frameID, XBeeTransmitStatus.get(status));
    }

    public TXStatusPacket(int frameID, XBeeTransmitStatus transmitStatus) {
        super(APIFrameType.TX_STATUS);
        if (transmitStatus == null) {
            throw new NullPointerException("Transmit status cannot be null.");
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException("Frame ID must be between 0 and 255.");
        }
        this.frameID = frameID;
        this.transmitStatus = transmitStatus;
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        return new byte[]{(byte)this.transmitStatus.getId()};
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    public XBeeTransmitStatus getTransmitStatus() {
        return this.transmitStatus;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitStatus.getId(), 1)) + " (" + this.transmitStatus.getDescription() + ")");
        return parameters;
    }
}

