/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.relay;

import com.digi.xbee.api.models.XBeeLocalInterface;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDataRelayOutputPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 2;
    private static final String ERROR_PAYLOAD_NULL = "User Data Relay Output packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete User Data Relay Output packet.";
    private static final String ERROR_NOT_USER_DATA_RELAY = "Payload is not a User Data Relay Output packet.";
    private static final String ERROR_INTERFACE_NULL = "Source interface cannot be null.";
    private XBeeLocalInterface localInterface;
    private byte[] data;
    private Logger logger;

    public static UserDataRelayOutputPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 2) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.USER_DATA_RELAY_OUTPUT.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_USER_DATA_RELAY);
        }
        int index = 1;
        XBeeLocalInterface srcInterface = XBeeLocalInterface.get(payload[index] & 0xFF);
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new UserDataRelayOutputPacket(srcInterface, data);
    }

    public UserDataRelayOutputPacket(XBeeLocalInterface localInterface, byte[] data) {
        super(APIFrameType.USER_DATA_RELAY_OUTPUT);
        if (localInterface == null) {
            throw new NullPointerException(ERROR_INTERFACE_NULL);
        }
        this.localInterface = localInterface;
        this.data = data;
        this.logger = LoggerFactory.getLogger(UserDataRelayOutputPacket.class);
    }

    @Override
    public byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.localInterface.getID());
            if (this.data != null) {
                os.write(this.data);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setSourceInterface(XBeeLocalInterface localInterface) {
        if (localInterface == null) {
            throw new NullPointerException(ERROR_INTERFACE_NULL);
        }
        this.localInterface = localInterface;
    }

    public XBeeLocalInterface getSourceInterface() {
        return this.localInterface;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Source interface", String.format("%s (%s)", HexUtils.prettyHexString(HexUtils.integerToHexString(this.localInterface.getID(), 1)), this.localInterface.getDescription()));
        if (this.data != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data)));
        }
        return parameters;
    }
}

