/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.relay;

import com.digi.xbee.api.models.XBeeLocalInterface;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDataRelayPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 3;
    private static final String ERROR_PAYLOAD_NULL = "User Data Relay packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete User Data Relay packet.";
    private static final String ERROR_NOT_USER_DATA_RELAY = "Payload is not a User Data Relay packet.";
    private static final String ERROR_INTERFACE_NULL = "Destination interface cannot be null.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private XBeeLocalInterface localInterface;
    private byte[] data;
    private Logger logger;

    public static UserDataRelayPacket createPacket(byte[] payload) {
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 3) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.USER_DATA_RELAY.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_USER_DATA_RELAY);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        XBeeLocalInterface destInterface = XBeeLocalInterface.get(payload[++index] & 0xFF);
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new UserDataRelayPacket(frameID, destInterface, data);
    }

    public UserDataRelayPacket(int frameID, XBeeLocalInterface localInterface, byte[] data) {
        super(APIFrameType.USER_DATA_RELAY);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (localInterface == null) {
            throw new NullPointerException(ERROR_INTERFACE_NULL);
        }
        this.frameID = frameID;
        this.localInterface = localInterface;
        this.data = data;
        this.logger = LoggerFactory.getLogger(UserDataRelayPacket.class);
    }

    @Override
    public byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.localInterface.getID());
            if (this.data != null) {
                os.write(this.data);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setDestinationInterface(XBeeLocalInterface localInterface) {
        if (localInterface == null) {
            throw new NullPointerException(ERROR_INTERFACE_NULL);
        }
        this.localInterface = localInterface;
    }

    public XBeeLocalInterface getDestinationInterface() {
        return this.localInterface;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Destination interface", String.format("%s (%s)", HexUtils.prettyHexString(HexUtils.integerToHexString(this.localInterface.getID(), 1)), this.localInterface.getDescription()));
        if (this.data != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data)));
        }
        return parameters;
    }
}

