/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.thread;

import com.digi.xbee.api.models.IPProtocol;
import com.digi.xbee.api.models.RestFulStatusEnum;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoAPRxResponsePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 41;
    private static final String ERROR_PAYLOAD_NULL = "CoAP Rx Response packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete CoAP Rx Response packet.";
    private static final String ERROR_NOT_COAP_RX_RESP = "Payload is not a CoAP Rx Response packet.";
    private static final String ERROR_DEST_ADDR_NULL = "Destination address cannot be null.";
    private static final String ERROR_SOURCE_ADDR_NULL = "Source address cannot be null.";
    private static final String ERROR_PROTOCOL_NULL = "Protocol cannot be null.";
    private static final String ERROR_STATUS_NULL = "RESTFul status cannot be null.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_DEST_PORT_ILLEGAL = "Destination port must be between 0 and 65535.";
    private static final String ERROR_SOURCE_PORT_ILLEGAL = "Source port must be between 0 and 65535.";
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    private Inet6Address destAddress;
    private Inet6Address sourceAddress;
    private int destPort;
    private int sourcePort;
    private IPProtocol protocol;
    private RestFulStatusEnum restFulStatus;
    private byte[] data;
    private Logger logger;

    public static CoAPRxResponsePacket createPacket(byte[] payload) {
        Inet6Address sourceAddress;
        Inet6Address destAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 41) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.COAP_RX_RESPONSE.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_COAP_RX_RESP);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        ++index;
        try {
            destAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        index += 16;
        try {
            sourceAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int destPort = (payload[index += 16] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int sourcePort = (payload[index += 2] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        IPProtocol protocol = IPProtocol.get(payload[index += 2] & 0xFF);
        RestFulStatusEnum restFulStatus = RestFulStatusEnum.get((payload[++index] & 0xFF) << 8 | payload[index + 1] & 0xFF);
        byte[] rfData = null;
        if ((index += 2) < payload.length) {
            rfData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new CoAPRxResponsePacket(frameID, destAddress, sourceAddress, destPort, sourcePort, protocol, restFulStatus, rfData);
    }

    public CoAPRxResponsePacket(int frameID, Inet6Address destAddress, Inet6Address sourceAddress, int destPort, int sourcePort, IPProtocol protocol, RestFulStatusEnum restFulStatus, byte[] rfData) {
        super(APIFrameType.COAP_RX_RESPONSE);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDR_NULL);
        }
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException(ERROR_DEST_PORT_ILLEGAL);
        }
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException(ERROR_SOURCE_PORT_ILLEGAL);
        }
        if (protocol == null) {
            throw new NullPointerException(ERROR_PROTOCOL_NULL);
        }
        if (restFulStatus == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        this.frameID = frameID;
        this.destAddress = destAddress;
        this.sourceAddress = sourceAddress;
        this.destPort = destPort;
        this.sourcePort = sourcePort;
        this.protocol = protocol;
        this.restFulStatus = restFulStatus;
        this.data = rfData;
        this.logger = LoggerFactory.getLogger(CoAPRxResponsePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.destAddress.getAddress());
            os.write(this.sourceAddress.getAddress());
            os.write(ByteUtils.shortToByteArray((short)this.destPort));
            os.write(ByteUtils.shortToByteArray((short)this.sourcePort));
            os.write(this.protocol.getID());
            os.write(ByteUtils.shortToByteArray((short)this.restFulStatus.getID()));
            if (this.data != null) {
                os.write(this.data);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public Inet6Address getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(Inet6Address destAddress) {
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        this.destAddress = destAddress;
    }

    public Inet6Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Inet6Address sourceAddress) {
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDR_NULL);
        }
        this.sourceAddress = sourceAddress;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException(ERROR_DEST_PORT_ILLEGAL);
        }
        this.destPort = destPort;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException(ERROR_SOURCE_PORT_ILLEGAL);
        }
        this.sourcePort = sourcePort;
    }

    public IPProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(IPProtocol protocol) {
        if (protocol == null) {
            throw new NullPointerException(ERROR_PROTOCOL_NULL);
        }
        this.protocol = protocol;
    }

    public void setStatus(RestFulStatusEnum restFulStatus) {
        if (restFulStatus == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        this.restFulStatus = restFulStatus;
    }

    public RestFulStatusEnum getStatus() {
        return this.restFulStatus;
    }

    public void setData(byte[] rfData) {
        this.data = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Destination address", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.destAddress.getAddress())) + " (" + this.destAddress.getHostAddress() + ")");
        parameters.put("Source address", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.sourceAddress.getAddress())) + " (" + this.sourceAddress.getHostAddress() + ")");
        parameters.put("Destination port", HexUtils.prettyHexString(HexUtils.integerToHexString(this.destPort, 2)) + " (" + this.destPort + ")");
        parameters.put("Source port", HexUtils.prettyHexString(HexUtils.integerToHexString(this.sourcePort, 2)) + " (" + this.sourcePort + ")");
        parameters.put("Protocol", HexUtils.prettyHexString(HexUtils.integerToHexString(this.protocol.getID(), 1)) + " (" + this.protocol.getName() + ")");
        parameters.put("RESTful Response Code", HexUtils.prettyHexString(HexUtils.integerToHexString(this.restFulStatus.getID(), 2)) + " (" + this.restFulStatus.getDescription() + ")");
        if (this.data != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data)));
        }
        return parameters;
    }
}

