/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.thread;

import com.digi.xbee.api.models.HTTPMethodEnum;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoAPTxRequestPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 26;
    private static final String ERROR_PAYLOAD_NULL = "CoAP Tx Request packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete CoAP Tx Request packet.";
    private static final String ERROR_NOT_COAP_TX_REQ = "Payload is not a CoAP Tx Request packet.";
    private static final String ERROR_DEST_ADDR_NULL = "Destination address cannot be null.";
    private static final String ERROR_METHOD_NULL = "HTTP Method cannot be null.";
    private static final String ERROR_URI_NULL = "URI cannot be null.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String ERROR_OPTIONS_INVALID = "Transmit options can only be 0 or 2.";
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    private int transmitOptions;
    private HTTPMethodEnum method;
    private Inet6Address destAddress;
    private String uri;
    private byte[] payload;
    private Logger logger;

    public static CoAPTxRequestPacket createPacket(byte[] payload) {
        Inet6Address destAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 26) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.COAP_TX_REQUEST.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_COAP_TX_REQ);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        int transmitOptions = payload[++index] & 0xFF;
        HTTPMethodEnum method = HTTPMethodEnum.get(payload[++index] & 0xFF);
        ++index;
        try {
            destAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int uriLength = payload[index += 16] & 0xFF;
        String uri = null;
        if (++index < index + uriLength) {
            uri = new String(Arrays.copyOfRange(payload, index, index + uriLength));
        }
        byte[] data = null;
        if ((index += uriLength) < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new CoAPTxRequestPacket(frameID, transmitOptions, method, destAddress, uri, data);
    }

    public CoAPTxRequestPacket(int frameID, int transmitOptions, HTTPMethodEnum method, Inet6Address destAddress, String uri, byte[] payload) {
        super(APIFrameType.COAP_TX_REQUEST);
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        if (uri != null && !uri.contains("XB/AT") && transmitOptions != 0 || uri != null && uri.contains("XB/AT") && transmitOptions != 0 && transmitOptions != 2) {
            throw new IllegalArgumentException(ERROR_OPTIONS_INVALID);
        }
        if (method == null) {
            throw new NullPointerException(ERROR_METHOD_NULL);
        }
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        if (uri == null) {
            throw new NullPointerException(ERROR_URI_NULL);
        }
        this.frameID = frameID;
        this.transmitOptions = transmitOptions;
        this.method = method;
        this.destAddress = destAddress;
        this.uri = uri;
        this.payload = payload;
        this.logger = LoggerFactory.getLogger(CoAPTxRequestPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.transmitOptions & 0xFF);
            os.write(this.method.getValue() & 0xFF);
            os.write(this.destAddress.getAddress());
            os.write(this.uri.length() & 0xFF);
            os.write(this.uri.getBytes());
            if (this.payload != null) {
                os.write(this.payload);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public void setTransmitOptions(int transmitOptions) {
        if (this.uri != null && !this.uri.contains("XB/AT") && transmitOptions != 0 || this.uri != null && this.uri.contains("XB/AT") && transmitOptions != 0 && transmitOptions != 2) {
            throw new IllegalArgumentException(ERROR_OPTIONS_INVALID);
        }
        this.transmitOptions = transmitOptions;
    }

    public int getTransmitOptions() {
        return this.transmitOptions;
    }

    public void setMethod(HTTPMethodEnum method) {
        if (method == null) {
            throw new NullPointerException(ERROR_METHOD_NULL);
        }
        this.method = method;
    }

    public HTTPMethodEnum getMethod() {
        return this.method;
    }

    public void setDestAddress(Inet6Address destAddress) {
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        this.destAddress = destAddress;
    }

    public Inet6Address getDestAddress() {
        return this.destAddress;
    }

    public void setURI(String uri) {
        if (uri == null) {
            throw new NullPointerException(ERROR_URI_NULL);
        }
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void setPayload(byte[] payload) {
        this.payload = (byte[])(payload == null ? null : Arrays.copyOf(payload, payload.length));
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            return null;
        }
        return Arrays.copyOf(this.payload, this.payload.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Frame ID", HexUtils.prettyHexString(HexUtils.integerToHexString(this.frameID, 1)) + " (" + this.frameID + ")");
        parameters.put("Options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.transmitOptions, 1)));
        parameters.put("Method", HexUtils.prettyHexString(HexUtils.integerToHexString(this.method.getValue(), 1)) + " (" + this.method.getName() + ")");
        parameters.put("Destination address", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.destAddress.getAddress())) + " (" + this.destAddress.getHostAddress() + ")");
        parameters.put("URI length", HexUtils.prettyHexString(HexUtils.integerToHexString(this.uri.length(), 1)) + " (" + this.uri.length() + ")");
        parameters.put("URI", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.uri.getBytes())) + " (" + this.uri + ")");
        if (this.payload != null) {
            parameters.put("Payload", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.payload)));
        }
        return parameters;
    }
}

