/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.thread;

import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv6IODataSampleRxIndicator
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 17;
    private static final String ERROR_PAYLOAD_NULL = "IPv6 IO Data Sample RX Indicator packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete IPv6 IO Data Sample RX Indicator packet.";
    private static final String ERROR_NOT_IORXIPV6 = "Payload is not an IPv6 IO Data Sample RX Indicator packet.";
    private static final String ERROR_SOURCE_ADDR_NULL = "Source address cannot be null.";
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    private final Inet6Address sourceAddress;
    private IOSample ioSample;
    private byte[] rfData;
    private Logger logger;

    public static IPv6IODataSampleRxIndicator createPacket(byte[] payload) {
        Inet6Address sourceAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 17) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.IPV6_IO_DATA_SAMPLE_RX_INDICATOR.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_IORXIPV6);
        }
        int index = 1;
        try {
            sourceAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        byte[] data = null;
        if ((index += 16) < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new IPv6IODataSampleRxIndicator(sourceAddress, data);
    }

    public IPv6IODataSampleRxIndicator(Inet6Address sourceAddress, byte[] rfData) {
        super(APIFrameType.IPV6_IO_DATA_SAMPLE_RX_INDICATOR);
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDR_NULL);
        }
        this.sourceAddress = sourceAddress;
        this.rfData = rfData;
        this.ioSample = rfData != null && rfData.length >= 5 ? new IOSample(rfData) : null;
        this.logger = LoggerFactory.getLogger(IPv6IODataSampleRxIndicator.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.sourceAddress.getAddress());
            if (this.rfData != null) {
                os.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public Inet6Address getSourceAddress() {
        return this.sourceAddress;
    }

    public IOSample getIOSample() {
        return this.ioSample;
    }

    public void setRFData(byte[] rfData) {
        this.rfData = (byte[])(rfData == null ? null : Arrays.copyOf(rfData, rfData.length));
        this.ioSample = rfData != null && rfData.length >= 5 ? new IOSample(this.rfData) : null;
    }

    public byte[] getRFData() {
        if (this.rfData == null) {
            return null;
        }
        return Arrays.copyOf(this.rfData, this.rfData.length);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("IPv6 source address", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.sourceAddress.getAddress())) + " (" + this.sourceAddress.getHostAddress() + ")");
        if (this.ioSample != null) {
            int i;
            parameters.put("Number of samples", HexUtils.prettyHexString(HexUtils.integerToHexString(1, 1)));
            parameters.put("Digital channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getDigitalMask(), 2)));
            parameters.put("Analog channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getAnalogMask(), 1)));
            for (i = 0; i < 16; ++i) {
                if (!this.ioSample.hasDigitalValue(IOLine.getDIO(i))) continue;
                parameters.put(IOLine.getDIO(i).getName() + " digital value", this.ioSample.getDigitalValue(IOLine.getDIO(i)).getName());
            }
            for (i = 0; i < 6; ++i) {
                if (!this.ioSample.hasAnalogValue(IOLine.getDIO(i))) continue;
                parameters.put(IOLine.getDIO(i).getName() + " analog value", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getAnalogValue(IOLine.getDIO(i)), 2)) + " (" + this.ioSample.getAnalogValue(IOLine.getDIO(i)) + ")");
            }
            if (this.ioSample.hasPowerSupplyValue()) {
                try {
                    parameters.put("Power supply value", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getPowerSupplyValue(), 2)));
                }
                catch (XBeeException xBeeException) {}
            }
        } else if (this.rfData != null) {
            parameters.put("RF data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.rfData)));
        }
        return parameters;
    }
}

