/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.thread;

import com.digi.xbee.api.models.ATCommandStatus;
import com.digi.xbee.api.models.ATStringCommands;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv6RemoteATCommandResponsePacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 21;
    private static final String ERROR_PAYLOAD_NULL = "IPv6 Remote AT command response packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete IPv6 Remote AT command response packet.";
    private static final String ERROR_NOT_REMOTE_IPV6_RESP = "Payload is not an IPv6 Remote AT command response packet.";
    private static final String ERROR_SOURCE_ADDR_NULL = "Source address cannot be null.";
    private static final String ERROR_AT_CMD_NULL = "AT command cannot be null.";
    private static final String ERROR_STATUS_NULL = "AT command status cannot be null.";
    private static final String ERROR_FRAME_ID_ILLEGAL = "Frame ID must be between 0 and 255.";
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    private final Inet6Address sourceAddress;
    private final String command;
    private final ATCommandStatus status;
    private byte[] commandValue;
    private Logger logger;

    public static IPv6RemoteATCommandResponsePacket createPacket(byte[] payload) {
        Inet6Address sourceAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 21) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.IPV6_REMOTE_AT_COMMAND_RESPONSE.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_REMOTE_IPV6_RESP);
        }
        int index = 1;
        int frameID = payload[index] & 0xFF;
        ++index;
        try {
            sourceAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        String command = new String(new byte[]{payload[index += 16], payload[index + 1]});
        int status = payload[index += 2] & 0xFF;
        byte[] commandData = null;
        if (++index < payload.length) {
            commandData = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new IPv6RemoteATCommandResponsePacket(frameID, sourceAddress, command, ATCommandStatus.get(status), commandData);
    }

    public IPv6RemoteATCommandResponsePacket(int frameID, Inet6Address sourceAddress, String command, ATCommandStatus status, String commandValue) {
        super(APIFrameType.IPV6_REMOTE_AT_COMMAND_RESPONSE);
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDR_NULL);
        }
        if (command == null) {
            throw new NullPointerException(ERROR_AT_CMD_NULL);
        }
        if (status == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        this.frameID = frameID;
        this.sourceAddress = sourceAddress;
        this.command = command;
        this.status = status;
        if (commandValue != null) {
            this.commandValue = commandValue.getBytes();
        }
        this.logger = LoggerFactory.getLogger(IPv6RemoteATCommandResponsePacket.class);
    }

    public IPv6RemoteATCommandResponsePacket(int frameID, Inet6Address sourceAddress, String command, ATCommandStatus status, byte[] commandValue) {
        super(APIFrameType.IPV6_REMOTE_AT_COMMAND_RESPONSE);
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDR_NULL);
        }
        if (command == null) {
            throw new NullPointerException(ERROR_AT_CMD_NULL);
        }
        if (status == null) {
            throw new NullPointerException(ERROR_STATUS_NULL);
        }
        if (frameID < 0 || frameID > 255) {
            throw new IllegalArgumentException(ERROR_FRAME_ID_ILLEGAL);
        }
        this.frameID = frameID;
        this.sourceAddress = sourceAddress;
        this.command = command;
        this.status = status;
        this.commandValue = commandValue;
        this.logger = LoggerFactory.getLogger(IPv6RemoteATCommandResponsePacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.sourceAddress.getAddress());
            data.write(ByteUtils.stringToByteArray(this.command));
            data.write(this.status.getId() & 0xFF);
            if (this.commandValue != null) {
                data.write(this.commandValue);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return data.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return true;
    }

    @Override
    public boolean isBroadcast() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public Inet6Address getSourceAddress() {
        return this.sourceAddress;
    }

    public ATCommandStatus getStatus() {
        return this.status;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommandValue(String commandValue) {
        this.commandValue = (byte[])(commandValue == null ? null : commandValue.getBytes());
    }

    public void setCommandValue(byte[] commandValue) {
        this.commandValue = commandValue;
    }

    public byte[] getCommandValue() {
        return this.commandValue;
    }

    public String getCommandValueAsString() {
        if (this.commandValue == null) {
            return null;
        }
        return new String(this.commandValue);
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Source address", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.sourceAddress.getAddress())) + " (" + this.sourceAddress.getHostAddress() + ")");
        parameters.put("AT Command", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.command.getBytes())) + " (" + this.command + ")");
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(this.status.getId(), 1)) + " (" + this.status.getDescription() + ")");
        if (this.commandValue != null) {
            if (ATStringCommands.get(this.command) != null) {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)) + " (" + new String(this.commandValue) + ")");
            } else {
                parameters.put("Response", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.commandValue)));
            }
        }
        return parameters;
    }
}

