/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.thread;

import com.digi.xbee.api.models.IPProtocol;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.ByteUtils;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RXIPv6Packet
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 39;
    private static final String ERROR_PAYLOAD_NULL = "RX IPv6 packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete RX IPv6 packet.";
    private static final String ERROR_NOT_RXIPV6 = "Payload is not a RX IPv6 packet.";
    private static final String ERROR_DEST_ADDR_NULL = "Destination address cannot be null.";
    private static final String ERROR_SOURCE_ADDR_NULL = "Source address cannot be null.";
    private static final String ERROR_PROTOCOL_NULL = "Protocol cannot be null.";
    private static final String ERROR_DEST_PORT_ILLEGAL = "Destination port must be between 0 and 65535.";
    private static final String ERROR_SOURCE_PORT_ILLEGAL = "Source port must be between 0 and 65535.";
    private static final String OPERATION_EXCEPTION = "Operation not supported in this module.";
    private Inet6Address destAddress;
    private Inet6Address sourceAddress;
    private int destPort;
    private int sourcePort;
    private IPProtocol protocol;
    private byte[] data;
    private Logger logger;

    public static RXIPv6Packet createPacket(byte[] payload) {
        Inet6Address sourceAddress;
        Inet6Address destAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 39) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.RX_IPV6.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_RXIPV6);
        }
        int index = 1;
        try {
            destAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        index += 16;
        try {
            sourceAddress = (Inet6Address)Inet6Address.getByAddress(Arrays.copyOfRange(payload, index, index + 16));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int destPort = (payload[index += 16] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        int sourcePort = (payload[index += 2] & 0xFF) << 8 | payload[index + 1] & 0xFF;
        IPProtocol protocol = IPProtocol.get(payload[index += 2] & 0xFF);
        ++index;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new RXIPv6Packet(destAddress, sourceAddress, destPort, sourcePort, protocol, data);
    }

    public RXIPv6Packet(Inet6Address destAddress, Inet6Address sourceAddress, int destPort, int sourcePort, IPProtocol protocol, byte[] data) {
        super(APIFrameType.RX_IPV6);
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException(ERROR_DEST_PORT_ILLEGAL);
        }
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException(ERROR_SOURCE_PORT_ILLEGAL);
        }
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDR_NULL);
        }
        if (protocol == null) {
            throw new NullPointerException(ERROR_PROTOCOL_NULL);
        }
        this.destAddress = destAddress;
        this.sourceAddress = sourceAddress;
        this.destPort = destPort;
        this.sourcePort = sourcePort;
        this.protocol = protocol;
        this.data = data;
        this.logger = LoggerFactory.getLogger(RXIPv6Packet.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(this.destAddress.getAddress());
            os.write(this.sourceAddress.getAddress());
            os.write(ByteUtils.shortToByteArray((short)this.destPort));
            os.write(ByteUtils.shortToByteArray((short)this.sourcePort));
            os.write(this.protocol.getID() & 0xFF);
            os.write(0);
            if (this.data != null) {
                os.write(this.data);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        throw new UnsupportedOperationException(OPERATION_EXCEPTION);
    }

    public Inet6Address getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(Inet6Address destAddress) {
        if (destAddress == null) {
            throw new NullPointerException(ERROR_DEST_ADDR_NULL);
        }
        this.destAddress = destAddress;
    }

    public Inet6Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Inet6Address sourceAddress) {
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDR_NULL);
        }
        this.sourceAddress = sourceAddress;
    }

    public int getDestPort() {
        return this.destPort;
    }

    public void setDestPort(int destPort) {
        if (destPort < 0 || destPort > 65535) {
            throw new IllegalArgumentException(ERROR_DEST_PORT_ILLEGAL);
        }
        this.destPort = destPort;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        if (sourcePort < 0 || sourcePort > 65535) {
            throw new IllegalArgumentException(ERROR_SOURCE_PORT_ILLEGAL);
        }
        this.sourcePort = sourcePort;
    }

    public IPProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(IPProtocol protocol) {
        if (protocol == null) {
            throw new NullPointerException(ERROR_PROTOCOL_NULL);
        }
        this.protocol = protocol;
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void setData(byte[] data) {
        this.data = (byte[])(data == null ? null : Arrays.copyOf(data, data.length));
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Destination address", HexUtils.prettyHexString(this.destAddress.getAddress()) + " (" + this.destAddress.getHostAddress() + ")");
        parameters.put("Source address", HexUtils.prettyHexString(this.sourceAddress.getAddress()) + " (" + this.sourceAddress.getHostAddress() + ")");
        parameters.put("Destination port", HexUtils.prettyHexString(HexUtils.integerToHexString(this.destPort, 2)) + " (" + this.destPort + ")");
        parameters.put("Source port", HexUtils.prettyHexString(HexUtils.integerToHexString(this.sourcePort, 2)) + " (" + this.sourcePort + ")");
        parameters.put("Protocol", HexUtils.prettyHexString(HexUtils.integerToHexString(this.protocol.getID(), 1)) + " (" + this.protocol.getName() + ")");
        parameters.put("Status", HexUtils.prettyHexString(HexUtils.integerToHexString(0, 1)) + " (Reserved)");
        if (this.data != null) {
            parameters.put("Data", HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.data)));
        }
        return parameters;
    }
}

