/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.packet.wifi;

import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOSample;
import com.digi.xbee.api.packet.APIFrameType;
import com.digi.xbee.api.packet.XBeeAPIPacket;
import com.digi.xbee.api.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IODataSampleRxIndicatorWifiPacket
extends XBeeAPIPacket {
    private static final int MIN_API_PAYLOAD_LENGTH = 11;
    private static final String ERROR_PAYLOAD_NULL = "IO Data Sample Rx Indicator (Wi-Fi) packet payload cannot be null.";
    private static final String ERROR_INCOMPLETE_PACKET = "Incomplete IO Data Sample Rx Indicator (Wi-Fi) packet.";
    private static final String ERROR_NOT_VALID = "Payload is not a IO Data Sample Rx Indicator (Wi-Fi) packet.";
    private static final String ERROR_SOURCE_ADDRESS_NULL = "Source address cannot be null.";
    private static final String ERROR_RSSI_ILLEGAL = "RSSI must be between 0 and 255.";
    private static final String ERROR_OPTIONS_ILLEGAL = "Receive options must be between 0 and 255.";
    private Inet4Address sourceAddress;
    private final IOSample ioSample;
    private int rssi;
    private int receiveOptions;
    private byte[] rfData;
    private Logger logger;

    public static IODataSampleRxIndicatorWifiPacket createPacket(byte[] payload) {
        Inet4Address sourceAddress;
        if (payload == null) {
            throw new NullPointerException(ERROR_PAYLOAD_NULL);
        }
        if (payload.length < 11) {
            throw new IllegalArgumentException(ERROR_INCOMPLETE_PACKET);
        }
        if ((payload[0] & 0xFF) != APIFrameType.IO_DATA_SAMPLE_RX_INDICATOR_WIFI.getValue()) {
            throw new IllegalArgumentException(ERROR_NOT_VALID);
        }
        int index = 1;
        try {
            sourceAddress = (Inet4Address)Inet4Address.getByAddress(Arrays.copyOfRange(payload, index + 4, index + 8));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        int rssi = payload[index += 8] & 0xFF;
        int receiveOptions = payload[++index] & 0xFF;
        byte[] data = null;
        if (++index < payload.length) {
            data = Arrays.copyOfRange(payload, index, payload.length);
        }
        return new IODataSampleRxIndicatorWifiPacket(sourceAddress, rssi, receiveOptions, data);
    }

    public IODataSampleRxIndicatorWifiPacket(Inet4Address sourceAddress, int rssi, int receiveOptions, byte[] rfData) {
        super(APIFrameType.IO_DATA_SAMPLE_RX_INDICATOR_WIFI);
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDRESS_NULL);
        }
        if (rssi < 0 || rssi > 255) {
            throw new IllegalArgumentException(ERROR_RSSI_ILLEGAL);
        }
        if (receiveOptions < 0 || receiveOptions > 255) {
            throw new IllegalArgumentException(ERROR_OPTIONS_ILLEGAL);
        }
        this.sourceAddress = sourceAddress;
        this.rssi = rssi;
        this.receiveOptions = receiveOptions;
        this.rfData = rfData;
        this.ioSample = rfData != null ? new IOSample(rfData) : null;
        this.logger = LoggerFactory.getLogger(IODataSampleRxIndicatorWifiPacket.class);
    }

    @Override
    protected byte[] getAPIPacketSpecificData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(new byte[]{0, 0, 0, 0});
            os.write(this.sourceAddress.getAddress());
            os.write(this.rssi);
            os.write(this.receiveOptions);
            if (this.rfData != null) {
                os.write(this.rfData);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return os.toByteArray();
    }

    @Override
    public boolean needsAPIFrameID() {
        return false;
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    public void setSourceAddress(Inet4Address sourceAddress) {
        if (sourceAddress == null) {
            throw new NullPointerException(ERROR_SOURCE_ADDRESS_NULL);
        }
        this.sourceAddress = sourceAddress;
    }

    public Inet4Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setRSSI(int rssi) {
        if (rssi < 0 || rssi > 255) {
            throw new IllegalArgumentException(ERROR_RSSI_ILLEGAL);
        }
        this.rssi = rssi;
    }

    public int getRSSI() {
        return this.rssi;
    }

    public void setReceiveOptions(int receiveOptions) {
        if (receiveOptions < 0 || receiveOptions > 255) {
            throw new IllegalArgumentException(ERROR_OPTIONS_ILLEGAL);
        }
        this.receiveOptions = receiveOptions;
    }

    public int getReceiveOptions() {
        return this.receiveOptions;
    }

    public IOSample getIOSample() {
        return this.ioSample;
    }

    public byte[] getRFData() {
        return this.rfData;
    }

    @Override
    public LinkedHashMap<String, String> getAPIPacketParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("Source address", "00 00 00 00 " + HexUtils.prettyHexString(HexUtils.byteArrayToHexString(this.sourceAddress.getAddress())) + " (" + this.sourceAddress.getHostAddress() + ")");
        parameters.put("RSSI", HexUtils.prettyHexString(HexUtils.integerToHexString(this.rssi, 1)));
        parameters.put("Receive options", HexUtils.prettyHexString(HexUtils.integerToHexString(this.receiveOptions, 1)));
        if (this.ioSample != null) {
            int i;
            parameters.put("Number of samples", HexUtils.prettyHexString(HexUtils.integerToHexString(1, 1)));
            parameters.put("Digital channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getDigitalMask(), 2)));
            parameters.put("Analog channel mask", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getAnalogMask(), 2)));
            for (i = 0; i < 16; ++i) {
                if (!this.ioSample.hasDigitalValue(IOLine.getDIO(i))) continue;
                parameters.put(IOLine.getDIO(i).getName() + " digital value", this.ioSample.getDigitalValue(IOLine.getDIO(i)).getName());
            }
            for (i = 0; i < 6; ++i) {
                if (!this.ioSample.hasAnalogValue(IOLine.getDIO(i))) continue;
                parameters.put(IOLine.getDIO(i).getName() + " analog value", HexUtils.prettyHexString(HexUtils.integerToHexString(this.ioSample.getAnalogValue(IOLine.getDIO(i)), 2)));
            }
        }
        return parameters;
    }
}

