/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.utils.srp;

import com.digi.xbee.api.utils.srp.SrpConstants;
import com.digi.xbee.api.utils.srp.SrpUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SrpUser {
    private String username;
    private String password;
    private boolean authenticated = false;
    private BigInteger N;
    private BigInteger g;
    private BigInteger a;
    private byte[] byte_A;
    private BigInteger k;
    private byte[] H_AMK;
    private byte[] byte_K;

    public SrpUser(String username, String password) {
        this(username, password, null, null);
    }

    private SrpUser(String username, String password, byte[] byte_N, byte[] byte_g) {
        this.username = username;
        this.password = password;
        this.N = byte_N != null ? SrpUtils.bigIntegerFromBytes(byte_N) : SrpConstants.N;
        this.g = byte_g != null ? SrpUtils.bigIntegerFromBytes(byte_g) : SrpConstants.g;
    }

    public byte[] startAuthentication() throws NoSuchAlgorithmException, IOException {
        this.authenticated = false;
        this.byte_K = null;
        byte[] byte_a = new byte[32];
        new SecureRandom().nextBytes(byte_a);
        this.a = SrpUtils.bigIntegerFromBytes(byte_a);
        this.byte_A = SrpUtils.bigIntegerToBytes(this.g.modPow(this.a, this.N));
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(SrpUtils.bigIntegerToBytes(this.N));
        os.write(SrpUtils.bigIntegerToBytes(this.g));
        byte[] byte_k = digest.digest(os.toByteArray());
        this.k = SrpUtils.bigIntegerFromBytes(byte_k);
        return this.byte_A;
    }

    public byte[] processChallenge(byte[] byte_s, byte[] byte_B) throws NoSuchAlgorithmException, IOException {
        byte[] byte_p;
        BigInteger B = SrpUtils.bigIntegerFromBytes(byte_B);
        if (B.mod(this.N).equals(BigInteger.ZERO)) {
            return null;
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.byte_A);
        os.write(SrpUtils.bigIntegerToBytes(B));
        byte[] byte_u = digest.digest(os.toByteArray());
        BigInteger u = SrpUtils.bigIntegerFromBytes(byte_u);
        if (u.equals(BigInteger.ZERO)) {
            return null;
        }
        byte[] byte_I = this.username.getBytes();
        byte[] byte_x = SrpUtils.generateX(byte_s, byte_I, byte_p = this.password.getBytes());
        BigInteger x = SrpUtils.bigIntegerFromBytes(byte_x);
        BigInteger v = this.g.modPow(x, this.N).abs();
        BigInteger S = B.subtract(this.k.multiply(v)).modPow(this.a.add(u.multiply(x)), this.N);
        if (S.compareTo(BigInteger.ZERO) < 0) {
            S = this.N.add(S);
        }
        this.byte_K = digest.digest(SrpUtils.bigIntegerToBytes(S));
        byte[] byte_M = SrpUtils.generateM(SrpUtils.bigIntegerToBytes(this.N), SrpUtils.bigIntegerToBytes(this.g), byte_I, byte_s, this.byte_A, SrpUtils.bigIntegerToBytes(B), this.byte_K);
        os = new ByteArrayOutputStream();
        os.write(this.byte_A);
        os.write(byte_M);
        os.write(this.byte_K);
        this.H_AMK = digest.digest(os.toByteArray());
        return byte_M;
    }

    public void verifySession(byte[] host_H_AMK) {
        if (host_H_AMK.length != this.H_AMK.length) {
            return;
        }
        for (int i = 0; i < this.H_AMK.length; ++i) {
            if (this.H_AMK[i] == host_H_AMK[i]) continue;
            return;
        }
        this.authenticated = true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public byte[] getSessionKey() {
        return this.byte_K;
    }
}

