/*
 * Decompiled with CFR 0.152.
 */
package com.digi.xbee.api.utils.srp;

import com.digi.xbee.api.utils.srp.SrpConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class SrpUtils {
    public static byte[] generateSalt() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] salt = new byte[4];
        secureRandom.nextBytes(salt);
        return salt;
    }

    public static byte[] generateVerifier(byte[] salt, String password) throws IOException, NoSuchAlgorithmException {
        BigInteger x = SrpUtils.bigIntegerFromBytes(SrpUtils.generateX(salt, "apiservice".getBytes(), password.getBytes()));
        byte[] verifier = new byte[128];
        byte[] v = SrpUtils.bigIntegerToBytes(SrpConstants.g.modPow(x, SrpConstants.N));
        System.arraycopy(v, 0, verifier, verifier.length - v.length, v.length);
        return verifier;
    }

    static byte[] generateX(byte[] byte_s, byte[] byte_I, byte[] byte_p) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(byte_I);
        os.write(SrpConstants.SEPARATOR);
        os.write(byte_p);
        byte[] userPwHash = digest.digest(os.toByteArray());
        os = new ByteArrayOutputStream();
        os.write(byte_s);
        os.write(userPwHash);
        byte[] byte_x = digest.digest(os.toByteArray());
        return byte_x;
    }

    static byte[] generateM(byte[] byte_N, byte[] byte_g, byte[] byte_I, byte[] byte_s, byte[] byte_A, byte[] byte_B, byte[] byte_K) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] byte_Nxorh = SrpUtils.hashXor(byte_N, byte_g);
        byte[] byte_Ih = digest.digest(byte_I);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(byte_Nxorh);
        os.write(byte_Ih);
        os.write(byte_s);
        os.write(byte_A);
        os.write(byte_B);
        os.write(byte_K);
        byte[] byte_M = digest.digest(os.toByteArray());
        return byte_M;
    }

    private static byte[] hashXor(byte[] byte_1, byte[] byte_2) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte_1 = digest.digest(byte_1);
        byte_2 = digest.digest(byte_2);
        byte[] ret = new byte[byte_1.length];
        for (int i = 0; i < byte_1.length; ++i) {
            ret[i] = (byte)(byte_1[i] ^ byte_2[i]);
        }
        return ret;
    }

    static BigInteger bigIntegerFromBytes(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    static byte[] bigIntegerToBytes(BigInteger bigInteger) {
        byte[] bytes = bigInteger.toByteArray();
        if (bytes[0] == 0) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }
}

