/*
 * Decompiled with CFR 0.152.
 */
package jmri.script.jsr223graalpython;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import jmri.script.jsr223graalpython.GraalJSScriptEngine;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraalJSBindings
extends AbstractMap<String, Object>
implements Bindings,
AutoCloseable {
    private static final String SCRIPT_CONTEXT_GLOBAL_BINDINGS_IMPORT_FUNCTION_NAME = "importScriptEngineGlobalBindings";
    private static final TypeLiteral<Map<String, Object>> STRING_MAP = new TypeLiteral<Map<String, Object>>(){};
    private Context context;
    private Map<String, Object> global;
    private Value deleteProperty;
    private Value clear;
    private Context.Builder contextBuilder;
    private ScriptContext engineScriptContext;
    private static final Logger log = LoggerFactory.getLogger(GraalJSBindings.class);

    GraalJSBindings(Context.Builder contextBuilder, ScriptContext scriptContext) {
        log.trace("ctor(C.B, S) invoked");
        this.contextBuilder = contextBuilder;
        this.engineScriptContext = scriptContext;
    }

    GraalJSBindings(Context context, ScriptContext scriptContext) {
        log.trace("ctor(C, S) invoked");
        this.context = context;
        this.initGlobal();
        this.engineScriptContext = scriptContext;
    }

    private void requireContext() {
        if (this.context == null) {
            this.initContext();
        }
    }

    private void initContext() {
        log.trace("initContext");
        this.context = GraalJSScriptEngine.createDefaultContext(this.contextBuilder);
        log.trace("  initContext created context {}", (Object)this.context);
        this.initGlobal();
    }

    private void initGlobal() {
        log.trace("initGlobal with \"{}\"", (Object)this.context);
        Value temp = GraalJSScriptEngine.evalInternal(this.context, "locals()");
        log.trace("    temp: " + temp);
        this.global = (Map)temp.as(STRING_MAP);
        log.trace("    defines  " + this.global);
    }

    private Value deletePropertyFunction() {
        if (this.deleteProperty == null) {
            this.deleteProperty = GraalJSScriptEngine.evalInternal(this.context, "(function(obj, prop) {delete obj[prop]})");
        }
        return this.deleteProperty;
    }

    private Value clearFunction() {
        if (this.clear == null) {
            this.clear = GraalJSScriptEngine.evalInternal(this.context, "(function(obj) {for (var prop in obj) {delete obj[prop]}})");
        }
        return this.clear;
    }

    @Override
    public Object put(String name, Object v) {
        GraalJSBindings.checkKey(name);
        if (name.startsWith("polyglot.js.")) {
            if (this.context == null) {
                GraalJSScriptEngine.MagicBindingsOptionSetter optionSetter = (GraalJSScriptEngine.MagicBindingsOptionSetter)GraalJSScriptEngine.MAGIC_BINDINGS_OPTION_MAP.get((Object)name);
                if (optionSetter == null) {
                    throw new IllegalArgumentException("unkown graal-js option \"" + name + "\"");
                }
                this.contextBuilder = optionSetter.setOption(this.contextBuilder, v);
                return true;
            }
            throw GraalJSBindings.magicOptionContextInitializedError(name);
        }
        this.requireContext();
        return this.global.put(name, v);
    }

    @Override
    public void clear() {
        if (this.context != null) {
            this.clearFunction().execute(new Object[]{this.global});
        }
    }

    @Override
    public Object get(Object key) {
        GraalJSBindings.checkKey((String)key);
        this.requireContext();
        if (this.engineScriptContext != null) {
            this.importGlobalBindings(this.engineScriptContext);
        }
        return this.global.get(key);
    }

    private static void checkKey(String key) {
        Objects.requireNonNull(key, "key can not be null");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key can not be empty");
        }
    }

    @Override
    public Object remove(Object key) {
        this.requireContext();
        Object prev = this.get(key);
        this.deletePropertyFunction().execute(new Object[]{this.global, key});
        return prev;
    }

    public Context getContext() {
        this.requireContext();
        return this.context;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.requireContext();
        return this.global.entrySet();
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    private static IllegalStateException magicOptionContextInitializedError(String name) {
        return new IllegalStateException(String.format("failed to set graal-js option \"%s\": js context is already initialized", name));
    }

    void importGlobalBindings(ScriptContext scriptContext) {
    }

    void updateEngineScriptContext(ScriptContext scriptContext) {
        this.engineScriptContext = scriptContext;
    }
}

