/*
 * Decompiled with CFR 0.152.
 */
package jmri.script.jsr223graalpython;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import jmri.script.jsr223graalpython.GraalJSScriptEngine;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.polyglot.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraalJSEngineFactory
implements ScriptEngineFactory {
    private static final String ENGINE_NAME = "Graal.python";
    private static final String NAME = "python";
    private static final String LANGUAGE = "Python";
    private static final String LANGUAGE_VERSION = "3";
    private static final String[] NAMES;
    private static final String[] MIME_TYPES;
    private static final String[] EXTENSIONS;
    private static final String NASHORN_ENGINE_NAME = "Oracle Nashorn";
    private static final List<String> names;
    private static final List<String> mimeTypes;
    private static final List<String> extensions;
    public static final boolean RegisterAsNashornScriptEngineFactory;
    private WeakReference<Engine> defaultEngine;
    private final Engine userDefinedEngine;
    private static final Logger log;

    public GraalJSEngineFactory() {
        log.trace("ctor() invoked");
        this.defaultEngine = null;
        this.userDefinedEngine = null;
    }

    GraalJSEngineFactory(Engine engine) {
        log.trace("ctor(Engine) invoked");
        this.userDefinedEngine = engine;
    }

    private static Engine createDefaultEngine() {
        return Engine.newBuilder().allowExperimentalOptions(true).option("python.EmulateJython", "true").build();
    }

    public Engine getPolyglotEngine() {
        Engine engine;
        log.trace("getPolyglotEngine() invoked");
        if (this.userDefinedEngine != null) {
            return this.userDefinedEngine;
        }
        Engine engine2 = engine = this.defaultEngine == null ? null : (Engine)this.defaultEngine.get();
        if (engine == null) {
            engine = GraalJSEngineFactory.createDefaultEngine();
            this.defaultEngine = new WeakReference<Engine>(engine);
        }
        return engine;
    }

    @Override
    public String getEngineName() {
        log.trace("getEngineName() invoked, returns {}", (Object)ENGINE_NAME);
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        try {
            log.trace("getEngineVersion() invoked");
            return this.getPolyglotEngine().getVersion();
        }
        catch (NoClassDefFoundError e) {
            log.debug("returning null due to no class found");
            return null;
        }
    }

    @Override
    public List<String> getExtensions() {
        log.trace("getExtensions() invoked");
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        log.trace("getMimeTypes() invoked");
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        log.trace("getNames() invoked");
        return names;
    }

    @Override
    public String getLanguageName() {
        log.trace("getLanguageName() invoked");
        return LANGUAGE;
    }

    @Override
    public String getLanguageVersion() {
        log.trace("getLanguageVersion() invoked");
        return LANGUAGE_VERSION;
    }

    @Override
    public Object getParameter(String key) {
        log.trace("getParameter('{}') invoked", (Object)key);
        switch (key) {
            case "javax.script.name": {
                return NAME;
            }
            case "javax.script.engine": {
                return this.getEngineName();
            }
            case "javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "javax.script.language": {
                return this.getLanguageName();
            }
            case "javax.script.language_version": {
                return this.getLanguageVersion();
            }
        }
        return null;
    }

    @Override
    public GraalJSScriptEngine getScriptEngine() {
        log.trace("getEngineName() invoked");
        return new GraalJSScriptEngine(this);
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        log.trace("getEngineName() invoked");
        Objects.requireNonNull(obj);
        Objects.requireNonNull(method);
        StringBuilder sb = new StringBuilder().append(obj).append('.').append(method).append('(');
        int len = args.length;
        if (len > 0) {
            Objects.requireNonNull(args[0]);
            sb.append(args[0]);
        }
        for (int i = 1; i < len; ++i) {
            Objects.requireNonNull(args[i]);
            sb.append(',').append(args[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        log.trace("getEngineName() invoked");
        return "print(" + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        log.trace("getEngineName() invoked");
        StringBuilder sb = new StringBuilder();
        for (String statement : statements) {
            Objects.requireNonNull(statement);
            sb.append(statement).append(';');
        }
        return sb.toString();
    }

    private static ScriptEngineFactory getNashornEngineFactory() {
        for (ScriptEngineFactory factory : new ScriptEngineManager().getEngineFactories()) {
            if (!NASHORN_ENGINE_NAME.equals(factory.getEngineName())) continue;
            return factory;
        }
        return null;
    }

    private static void clearEngineFactory(ScriptEngineFactory factory) {
        assert (factory != null);
        try {
            Class<?> clazz = factory.getClass();
            for (String immutableListFieldName : new String[]{"names", "mimeTypes", "extensions"}) {
                Field immutableListField = clazz.getDeclaredField(immutableListFieldName);
                immutableListField.setAccessible(true);
                Object immutableList = immutableListField.get(null);
                Class<?> unmodifiableListClazz = Class.forName("java.util.Collections$UnmodifiableList");
                Field unmodifiableListField = unmodifiableListClazz.getDeclaredField("list");
                unmodifiableListField.setAccessible(true);
                Class<?> unmodifiableCollectionClazz = Class.forName("java.util.Collections$UnmodifiableCollection");
                Field unmodifiableCField = unmodifiableCollectionClazz.getDeclaredField("c");
                unmodifiableCField.setAccessible(true);
                List list = (List)unmodifiableListField.get(immutableList);
                ArrayList filteredList = new ArrayList();
                for (Object item : list) {
                    if (RegisterAsNashornScriptEngineFactory || !item.toString().toLowerCase().equals("nashorn")) continue;
                    filteredList.add(item);
                }
                unmodifiableListField.set(immutableList, filteredList);
                unmodifiableCField.set(immutableList, filteredList);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException e) {
            System.err.println("Failed to clear engine names [" + factory.getEngineName() + "]");
            e.printStackTrace();
        }
    }

    static {
        ScriptEngineFactory nashornFactory;
        boolean java8;
        NAMES = new String[]{"py3", LANGUAGE, NAME, "Python3", "python3", ENGINE_NAME, "graal.python", "Graal-python", "graal-python", "Graal.Python", "Graal-Python", "GraalPython", "GraalPythonPolyglot"};
        MIME_TYPES = new String[]{"application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript"};
        EXTENSIONS = new String[]{"py3"};
        RegisterAsNashornScriptEngineFactory = Boolean.getBoolean("graaljs.RegisterGraalJSAsNashorn");
        List<String> nameList = Arrays.asList(NAMES);
        List<String> mimeTypeList = Arrays.asList(MIME_TYPES);
        List<String> extensionList = Arrays.asList(EXTENSIONS);
        boolean bl = java8 = System.getProperty("java.specification.version").compareTo("1.9") < 0;
        if (java8 && !ImageInfo.inImageRuntimeCode() && (nashornFactory = GraalJSEngineFactory.getNashornEngineFactory()) != null) {
            if (RegisterAsNashornScriptEngineFactory) {
                nameList = new ArrayList<String>(nameList);
                nameList.removeAll(nashornFactory.getNames());
                nameList.addAll(nashornFactory.getNames());
                mimeTypeList = new ArrayList<String>(mimeTypeList);
                mimeTypeList.removeAll(nashornFactory.getMimeTypes());
                mimeTypeList.addAll(nashornFactory.getMimeTypes());
                extensionList = new ArrayList<String>(extensionList);
                extensionList.removeAll(nashornFactory.getExtensions());
                extensionList.addAll(nashornFactory.getExtensions());
            }
            GraalJSEngineFactory.clearEngineFactory(nashornFactory);
        }
        names = Collections.unmodifiableList(nameList);
        mimeTypes = Collections.unmodifiableList(mimeTypeList);
        extensions = Collections.unmodifiableList(extensionList);
        log = LoggerFactory.getLogger(GraalJSEngineFactory.class);
    }
}

