/*
 * Decompiled with CFR 0.152.
 */
package com.alexandriasoftware.swing;

import com.alexandriasoftware.swing.JInputValidatorPreferences;
import com.alexandriasoftware.swing.Validation;
import com.alexandriasoftware.swing.border.ValidatorBorder;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class JInputValidator
extends InputVerifier {
    private final Border originalBorder;
    private String originalToolTipText = null;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Validation validation;
    private Validation oldValidation;
    private final JInputValidatorPreferences preferences;
    private final JComponent component;
    private boolean inVerifyMethod;
    private boolean isVerifying;

    public JInputValidator(@Nonnull JComponent component) {
        this(component, true, true);
    }

    public JInputValidator(@Nonnull JComponent component, boolean onInput, boolean isVerifying) {
        this(component, onInput, isVerifying, JInputValidatorPreferences.getPreferences());
    }

    public JInputValidator(@Nonnull JComponent component, boolean onInput, boolean isVerifying, @Nonnull JInputValidatorPreferences preferences) {
        this.component = component;
        this.originalBorder = this.component.getBorder();
        this.originalToolTipText = this.component.getToolTipText();
        if (onInput && this.component instanceof JTextComponent) {
            this.addChangeListener((JTextComponent)this.component, e -> this.verify(this.component));
        }
        this.preferences = preferences;
        this.isVerifying = isVerifying;
        this.validation = this.getNoneValidation();
        this.oldValidation = this.getNoneValidation();
    }

    public void setVerifying(boolean isVerifying) {
        this.isVerifying = isVerifying;
    }

    public boolean isVerifying() {
        return this.isVerifying;
    }

    public void setToolTipText(String toolTipText) {
        this.originalToolTipText = toolTipText;
        if (this.validation == null || this.validation.getType() == Validation.Type.NONE) {
            this.component.setToolTipText(toolTipText);
        }
    }

    public String getToolTipText() {
        return this.originalToolTipText;
    }

    @Nonnull
    public final Validation getValidation() {
        return this.validation;
    }

    protected abstract Validation getValidation(JComponent var1, JInputValidatorPreferences var2);

    @Override
    public boolean verify(JComponent input) {
        this.oldValidation = this.validation;
        this.validation = this.getValidation(input, this.preferences);
        if (!this.validation.equals(this.oldValidation) && !this.inVerifyMethod) {
            this.inVerifyMethod = true;
            if (this.validation.getType() == Validation.Type.NONE) {
                input.setBorder(this.originalBorder);
                input.setToolTipText(this.originalToolTipText);
            } else {
                input.setBorder(new ValidatorBorder(this.validation, this.originalBorder));
                input.setToolTipText(this.validation.getMessage());
            }
            input.validate();
            this.pcs.firePropertyChange("validation", this.oldValidation, this.validation);
            this.inVerifyMethod = false;
        }
        return this.isVerifying ? this.validation.getType() != Validation.Type.WARNING && this.validation.getType() != Validation.Type.DANGER : true;
    }

    protected JComponent getComponent() {
        return this.component;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    protected final void setValidationPreferences(Validation validation) {
        validation.setPreferences(this.preferences);
    }

    @Nonnull
    protected final String trimHtmlTags(@Nullable String input) {
        String output;
        String string = output = input != null ? input.trim() : "";
        if (output.startsWith("<html>")) {
            output = output.substring(6);
        }
        if (output.endsWith("</html>")) {
            output = output.substring(0, output.length() - 7);
        }
        return output.trim();
    }

    public final Validation getNoneValidation() {
        return new Validation(Validation.Type.NONE, this.getToolTipText(), this.preferences);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    private void addChangeListener(final @Nonnull JTextComponent component, final @Nonnull ChangeListener changeListener) {
        DocumentListener listener = new DocumentListener(){
            private int lastChange = 0;
            private int lastNotifiedChange = 0;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ++this.lastChange;
                SwingUtilities.invokeLater(() -> {
                    if (this.lastNotifiedChange != this.lastChange) {
                        this.lastNotifiedChange = this.lastChange;
                        changeListener.stateChanged(new ChangeEvent(component));
                    }
                });
            }
        };
        component.addPropertyChangeListener("document", e -> {
            Document oldDocument = (Document)e.getOldValue();
            Document newDocument = (Document)e.getNewValue();
            if (oldDocument != null) {
                oldDocument.removeDocumentListener(listener);
            }
            if (newDocument != null) {
                newDocument.addDocumentListener(listener);
            }
            listener.changedUpdate(null);
        });
        Document document = component.getDocument();
        if (document != null) {
            document.addDocumentListener(listener);
        }
    }
}

