/*
 * Decompiled with CFR 0.152.
 */
package com.alexandriasoftware.swing;

import com.alexandriasoftware.swing.JInputValidator;
import com.alexandriasoftware.swing.JInputValidatorPreferences;
import com.alexandriasoftware.swing.Validation;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class PredicateValidator
extends JInputValidator {
    private final Predicate<String> predicate;
    private final Validation valid;
    private final Validation invalid;

    public PredicateValidator(@Nonnull JComponent component, @Nonnull Predicate<String> predicate, Validation invalid) {
        this(component, predicate, invalid, true, true);
    }

    public PredicateValidator(@Nonnull JComponent component, @Nonnull Predicate<String> predicate, Validation invalid, boolean onInput, boolean isVerifying) {
        this(component, predicate, invalid, null, onInput, isVerifying, JInputValidatorPreferences.getPreferences());
    }

    public PredicateValidator(@Nonnull JComponent component, @Nonnull Predicate<String> predicate, @Nonnull Validation invalid, Validation valid, boolean onInput, boolean isVerifying, @Nonnull JInputValidatorPreferences preferences) {
        super(component, onInput, isVerifying, preferences);
        this.predicate = predicate;
        this.invalid = invalid;
        this.setValidationPreferences(this.invalid);
        if (valid != null) {
            this.valid = valid;
            this.setValidationPreferences(this.valid);
        } else {
            this.valid = this.getNoneValidation();
        }
    }

    @Override
    protected Validation getValidation(JComponent input, JInputValidatorPreferences preferences) {
        if (input instanceof JTextComponent) {
            return this.predicate.test(((JTextComponent)input).getText()) ? this.valid : this.invalid;
        }
        return this.getNoneValidation();
    }
}

