/*
 * Decompiled with CFR 0.152.
 */
package com.alexandriasoftware.swing;

import com.alexandriasoftware.swing.JInputValidatorPreferences;
import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Validation {
    private final Type type;
    private final String message;
    private JInputValidatorPreferences preferences;

    public Validation(Type type, String message) {
        this(type, message, JInputValidatorPreferences.getPreferences());
    }

    public Validation(Type type, String message, @Nonnull JInputValidatorPreferences preferences) {
        this.type = type;
        this.message = message;
        this.preferences = preferences;
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getIcon() {
        return this.preferences.getIcon(this.type);
    }

    @Nonnull
    public Color getColor() {
        return this.preferences.getColor(this.type);
    }

    @Nonnull
    public Font getFont() {
        return this.preferences.getFont();
    }

    void setPreferences(@Nonnull JInputValidatorPreferences preferences) {
        this.preferences = preferences;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode((Object)this.type);
        hash = 79 * hash + Objects.hashCode(this.message);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public static enum Type {
        NONE,
        UNKNOWN,
        INFORMATION,
        SUCCESS,
        WARNING,
        DANGER;

    }
}

