/*
 * Decompiled with CFR 0.152.
 */
package com.alexandriasoftware.swing;

import com.alexandriasoftware.swing.JInputValidator;
import com.alexandriasoftware.swing.JInputValidatorPreferences;
import com.alexandriasoftware.swing.Validation;
import javax.annotation.Nonnull;
import javax.swing.InputVerifier;
import javax.swing.JComponent;

public class VerifyingValidator
extends JInputValidator {
    private final InputVerifier verifier;
    private final Validation valid;
    private final Validation invalid;

    public VerifyingValidator(@Nonnull JComponent component, @Nonnull InputVerifier verifier, Validation invalid) {
        this(component, verifier, invalid, true, true);
    }

    public VerifyingValidator(@Nonnull JComponent component, @Nonnull InputVerifier verifier, Validation invalid, boolean onInput, boolean isVerifying) {
        this(component, verifier, invalid, null, onInput, isVerifying, JInputValidatorPreferences.getPreferences());
    }

    public VerifyingValidator(@Nonnull JComponent component, @Nonnull InputVerifier verifier, @Nonnull Validation invalid, Validation valid, boolean onInput, boolean isVerifying, @Nonnull JInputValidatorPreferences preferences) {
        super(component, onInput, isVerifying, preferences);
        this.verifier = verifier;
        this.invalid = invalid;
        this.setValidationPreferences(this.invalid);
        if (valid != null) {
            this.valid = valid;
            this.setValidationPreferences(this.valid);
        } else {
            this.valid = this.getNoneValidation();
        }
    }

    @Override
    protected Validation getValidation(JComponent input, JInputValidatorPreferences preferences) {
        return this.verifier.verify(input) ? this.valid : this.invalid;
    }
}

