/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.message.BidibRequestFactoryMessageMapInitializer;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.SimulatorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimulationMessageReceiver
implements SimulationBidibMessageProcessor,
MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationMessageReceiver.class);
    protected static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"RAW");
    private SimulatorRegistry simulatorRegistry;
    private org.bidib.jbidibc.core.message.BidibRequestFactory requestFactory;
    boolean escapeHot = false;
    private final Object accessLock = new Object();
    protected AtomicBoolean running = new AtomicBoolean();

    public SimulationMessageReceiver() {
        this.running.set(true);
    }

    public void cleanup() {
    }

    public void setSimulatorRegistry(SimulatorRegistry simulatorRegistry) {
        this.simulatorRegistry = simulatorRegistry;
    }

    private synchronized org.bidib.jbidibc.core.message.BidibRequestFactory getRequestFactory() {
        if (this.requestFactory == null) {
            this.requestFactory = new org.bidib.jbidibc.core.message.BidibRequestFactory();
            BidibRequestFactoryMessageMapInitializer.loadMessageTypeMap((BidibRequestFactory)this.requestFactory);
        }
        return this.requestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable() {
        LOGGER.info("enable is called.");
        Object object = this.accessLock;
        synchronized (object) {
            this.escapeHot = false;
        }
        MSG_RAW_LOGGER.info("++++ Enable the message receiver.");
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        LOGGER.info("Disable is called.");
        this.running.set(false);
        MSG_RAW_LOGGER.info("++++ Disable the message receiver.");
        Object object = this.accessLock;
        synchronized (object) {
            this.escapeHot = false;
        }
    }

    @Override
    public void purgeReceivedDataInBuffer() {
    }

    public void receive(ByteArrayOutputStream output) {
        if (!this.running.get()) {
            LOGGER.warn("Receiver is not running. Discard messages.");
            return;
        }
        LOGGER.info("Receive data: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        try {
            ArrayList commands = new ArrayList();
            this.getRequestFactory().createFromRaw(output.toByteArray(), commands);
            if (CollectionUtils.isNotEmpty(commands)) {
                for (BidibMessageInterface bidibCommand : commands) {
                    LOGGER.info("Process the current bidibCommand: {}", (Object)bidibCommand);
                    String nodeAddress = NodeUtils.formatAddress((byte[])bidibCommand.getAddr());
                    SimulatorNode simulatorNode = this.simulatorRegistry.getSimulator(nodeAddress);
                    if (simulatorNode != null) {
                        simulatorNode.processRequest(bidibCommand);
                        continue;
                    }
                    LOGGER.error("No simulator available for address: {}", (Object)nodeAddress);
                }
            } else {
                LOGGER.warn("No commands in packet received.");
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create BiDiB message failed.", (Throwable)ex);
        }
    }

    @Override
    public abstract void publishResponse(ByteArrayOutputStream var1) throws ProtocolException;

    public void processMessages(ByteArrayOutputStream output) throws ProtocolException {
        LOGGER.warn("processMessages() is not implemented in SimulationMessageReceiver.");
    }

    public String getErrorInformation() {
        return null;
    }

    public void addMessageListener(MessageListener messageListener) {
    }

    public void removeMessageListener(MessageListener messageListener) {
    }

    public void addNodeListener(NodeListener nodeListener) {
    }
}

