/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.DmxNode;
import org.bidib.jbidibc.simulation.InterfaceNode;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.SwitchingFunctionsNode;
import org.bidib.jbidibc.simulation.annotation.BidibVidPid;
import org.bidib.jbidibc.simulation.nodes.DefaultNodeSimulator;
import org.bidib.jbidibc.simulation.nodes.MasterType;
import org.bidib.jbidibc.simulation.nodes.NodeType;
import org.bidib.jbidibc.simulation.nodes.Simulation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SimulatorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulatorRegistry.class);
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.simulation.nodes";
    public static final String XSD_LOCATION_BASE = "/xsd/bidib2Base.xsd";
    private static final String XSD_LOCATION = "/xsd/simulation.xsd";
    public static final String JAXB_SCHEMA_LOCATION = "http://www.bidib.org/jbidibc/simulation/nodes xsd/simulation.xsd";
    private static volatile JAXBContext jaxbContext;
    private static volatile XMLInputFactory xmlInputFactory;
    private Map<String, SimulatorNode> simulators;
    private AtomicInteger nodeTabVersion = new AtomicInteger(0);
    private final Map<BidibVidPid, String> simulatorClassMapping;

    private SimulatorRegistry(Map<BidibVidPid, String> simulatorClassMapping) {
        this.simulators = new HashMap<String, SimulatorNode>();
        this.simulatorClassMapping = simulatorClassMapping;
    }

    public static SimulatorRegistry createInstance(Map<BidibVidPid, String> simulatorClassMapping) {
        LOGGER.info("Create new instance of SimulationRegistry.");
        SimulatorRegistry instance = new SimulatorRegistry(simulatorClassMapping);
        instance.initialize();
        return instance;
    }

    protected synchronized void initialize() {
        LOGGER.info("Initialize SimulatorRegistry.");
        if (xmlInputFactory == null) {
            LOGGER.info("Initialize the XMLInputFactory for the SimulatorRegistry.");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            factory.setXMLResolver(new XMLResolver(){

                @Override
                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    throw new XMLStreamException("Reading external entities is disabled");
                }
            });
            xmlInputFactory = factory;
        }
        if (jaxbContext == null) {
            LOGGER.info("Initialize the JaxbContext for the SimulatorRegistry.");
            try {
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            catch (JAXBException e) {
                LOGGER.error("Failed to load the jaxbContext for SimulatorRegistry.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        LOGGER.info("removeAll() will stop the simulators and clear the registry.");
        Map<String, SimulatorNode> map = this.simulators;
        synchronized (map) {
            for (SimulatorNode simulator : this.simulators.values()) {
                LOGGER.info("Stop the simulator: {}", (Object)simulator);
                simulator.stop();
            }
            this.simulators.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SimulatorNode> getSimulators() {
        Map<String, SimulatorNode> map = this.simulators;
        synchronized (map) {
            return Collections.unmodifiableMap(this.simulators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulator(String nodeAddress, SimulatorNode simulator) {
        LOGGER.info("Add new simulator: {}, nodeAddress: {}", (Object)simulator, (Object)nodeAddress);
        Map<String, SimulatorNode> map = this.simulators;
        synchronized (map) {
            this.simulators.put(nodeAddress, simulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimulatorNode getSimulator(String nodeAddress) {
        LOGGER.info("Get simulator with nodeAddress: {}", (Object)nodeAddress);
        SimulatorNode simulator = null;
        Map<String, SimulatorNode> map = this.simulators;
        synchronized (map) {
            simulator = this.simulators.get(nodeAddress);
        }
        if (simulator == null) {
            LOGGER.warn("No simulator found for nodeAddress: {}", (Object)nodeAddress);
        }
        return simulator;
    }

    public void loadSimulationConfiguration(InputStream simulationConfiguration, SimulationBidibMessageProcessor messageReceiver, Context context, BidibRequestFactory bidibRequestFactory) {
        LOGGER.info("Load simulation configuration from: {}, bidibRequestFactory: {}", (Object)simulationConfiguration, (Object)bidibRequestFactory);
        if (simulationConfiguration == null) {
            throw new IllegalArgumentException("The simulationConfiguration instance must be provided.");
        }
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(SimulatorRegistry.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(SimulatorRegistry.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            unmarshaller.setSchema(schema);
            Simulation simulation = (Simulation)unmarshaller.unmarshal(xmlInputFactory.createXMLStreamReader(simulationConfiguration), Simulation.class).getValue();
            MasterType master = simulation.getMaster();
            LOGGER.info("Fetched master from simulation configuration: {}", (Object)master);
            SimulatorNode simMaster = this.createSimulator(null, master, messageReceiver, context, bidibRequestFactory);
            if (master.getSubNodes() != null && master.getSubNodes().getNode() != null) {
                this.createSubNodes(null, master.getSubNodes().getNode(), simMaster, messageReceiver, context, bidibRequestFactory);
            }
            simMaster.start();
        }
        catch (JAXBException | XMLStreamException | SAXException ex) {
            LOGGER.warn("Load simulation configuration failed.", ex);
            throw new InvalidConfigurationException("Load simulation configuration failed. Reason: " + ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.warn("Load simulation configuration failed.", (Throwable)ex);
            throw new InvalidConfigurationException("Load simulation configuration failed. Reason: " + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()));
        }
    }

    public void loadSimulationConfigurationJson(InputStream simulationConfiguration, SimulationBidibMessageProcessor messageReceiver, Context context, BidibRequestFactory bidibRequestFactory) {
        LOGGER.info("Load json simulation configuration from: {}, bidibRequestFactory: {}", (Object)simulationConfiguration, (Object)bidibRequestFactory);
        if (simulationConfiguration == null) {
            throw new IllegalArgumentException("The simulationConfiguration instance must be provided.");
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            Simulation simulation = (Simulation)mapper.readValue(simulationConfiguration, Simulation.class);
            MasterType master = simulation.getMaster();
            LOGGER.info("Fetched master from simulation configuration: {}", (Object)master);
            SimulatorNode simMaster = this.createSimulator(null, master, messageReceiver, context, bidibRequestFactory);
            if (master.getSubNodes() != null && master.getSubNodes().getNode() != null) {
                this.createSubNodes(null, master.getSubNodes().getNode(), simMaster, messageReceiver, context, bidibRequestFactory);
            }
            simMaster.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Load json simulation configuration failed.", (Throwable)ex);
            throw new InvalidConfigurationException("Load json simulation configuration failed. Reason: " + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()));
        }
    }

    private void createSubNodes(String parentAddress, List<NodeType> subNodes, SimulatorNode simParent, SimulationBidibMessageProcessor messageReceiver, Context context, BidibRequestFactory bidibRequestFactory) {
        for (NodeType subNode : subNodes) {
            LOGGER.info("Create simulator for subNode: {}", (Object)subNode);
            try {
                SimulatorNode simNode = this.createSimulator(parentAddress, subNode, messageReceiver, context, bidibRequestFactory);
                if (simParent != null && simParent instanceof InterfaceNode) {
                    LOGGER.info("Adding simulator to simParent: {}, simulator: {}", (Object)simParent, (Object)simNode);
                    ((InterfaceNode)((Object)simParent)).addSubNode(simNode);
                }
                simNode.start();
                if (!NodeUtils.hasSubNodesFunctions((long)ByteUtils.convertUniqueIdToLong((byte[])subNode.getUniqueId())) || subNode.getSubNodes() == null || !CollectionUtils.hasElements(subNode.getSubNodes().getNode())) continue;
                StringBuilder subNodeAddress = new StringBuilder();
                if (StringUtils.isNotBlank((CharSequence)parentAddress) && !"0".equals(parentAddress)) {
                    LOGGER.info("The parent has address: {}", (Object)parentAddress);
                    subNodeAddress.append(parentAddress).append(".");
                }
                subNodeAddress.append(subNode.getAddress());
                this.createSubNodes(subNodeAddress.toString(), subNode.getSubNodes().getNode(), simNode, messageReceiver, context, bidibRequestFactory);
            }
            catch (Exception ex) {
                LOGGER.warn("Create simulator failed.", (Throwable)ex);
            }
        }
    }

    private SimulatorNode createSimulator(String parentAddress, NodeType node, SimulationBidibMessageProcessor messageReceiver, Context context, BidibRequestFactory bidibRequestFactory) {
        LOGGER.info("Create new simulator for node: {}, parentAddress: {}", (Object)node, (Object)parentAddress);
        long uniqueId = ByteUtils.convertUniqueIdToLong((byte[])node.getUniqueId());
        String className = node.getClassName();
        if (StringUtils.isBlank((CharSequence)className)) {
            BidibVidPid vidPid = BidibVidPid.of(NodeUtils.getVendorId((long)uniqueId), NodeUtils.getPid((long)uniqueId));
            className = this.simulatorClassMapping.getOrDefault(vidPid, DefaultNodeSimulator.class.getName());
            LOGGER.info("The simulator className is provided. The lookup mechanism provided the simulator class: {}", (Object)className);
        }
        String nodeAddress = node.getAddress().trim();
        byte address = Byte.parseByte(nodeAddress);
        byte[] nodeAddressArray = new byte[]{address};
        boolean autoAddFeature = node.isAutoAddFeature() != null ? node.isAutoAddFeature() : false;
        try {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)parentAddress) && !"0".equals(parentAddress)) {
                LOGGER.info("The parent has address: {}", (Object)parentAddress);
                sb.append(parentAddress).append(".");
                String[] splitedParentAddress = parentAddress.split("\\.");
                nodeAddressArray = new byte[splitedParentAddress.length + 1];
                int index = 0;
                for (String part : splitedParentAddress) {
                    nodeAddressArray[index] = Byte.parseByte(part);
                    ++index;
                }
                nodeAddressArray[index] = address;
                LOGGER.info("Prepared new nodeAddress for simulator: {}", new Object[]{nodeAddressArray});
            }
            sb.append(nodeAddress);
            LOGGER.info("Adding simulator with address: {}", (Object)sb.toString());
            String newNodeAddress = sb.toString();
            Constructor<?> constructor = Class.forName(className).getDeclaredConstructor(byte[].class, Long.TYPE, Boolean.TYPE, SimulationBidibMessageProcessor.class, BidibRequestFactory.class);
            SimulatorNode simulator = (SimulatorNode)constructor.newInstance(nodeAddressArray, uniqueId, autoAddFeature, messageReceiver, bidibRequestFactory);
            if (simulator != null) {
                LOGGER.info("Created new simulator: {}", (Object)simulator);
                simulator.setProtocolVersion(node.getProtocolVersion());
                simulator.setSoftwareVersion(node.getSoftwareVersion());
                if (simulator instanceof InterfaceNode) {
                    ((InterfaceNode)((Object)simulator)).setSimulatorRegistry(this);
                }
                simulator.init(context);
                if (node.getFeatures() != null && CollectionUtils.hasElements(node.getFeatures().getFeature())) {
                    simulator.setFeatures(node.getFeatures());
                }
                if (node.getCVs() != null && CollectionUtils.hasElements(node.getCVs().getCv())) {
                    simulator.setCVs(node.getCVs());
                }
                if (simulator instanceof DmxNode) {
                    DmxNode dmxNode = (DmxNode)((Object)simulator);
                    dmxNode.setDmxConfig(node.getDmxChannels());
                }
                if (simulator instanceof SwitchingFunctionsNode) {
                    SwitchingFunctionsNode switchingFunctionsNode = (SwitchingFunctionsNode)((Object)simulator);
                    switchingFunctionsNode.setPortsConfig(node.getINPUT());
                    switchingFunctionsNode.setPortsConfig(node.getSERVO());
                    switchingFunctionsNode.setPortsConfig(node.getSOUND());
                    switchingFunctionsNode.setPortsConfig(node.getSPORT());
                    switchingFunctionsNode.setPortsConfig(node.getLPORT());
                    switchingFunctionsNode.setPortsConfig(node.getBACKLIGHT());
                    switchingFunctionsNode.setPortsConfig(node.getMOTOR());
                    switchingFunctionsNode.setPortsConfig(node.getFLAT());
                }
                simulator.setNodeName(node.getUserName());
                simulator.setProductName(node.getProductName());
                simulator.postConstruct();
                this.addSimulator(newNodeAddress, simulator);
            } else {
                LOGGER.warn("No simulator available for configured node: {}", (Object)node);
            }
            return simulator;
        }
        catch (Exception ex) {
            LOGGER.warn("Create simulator failed.", (Throwable)ex);
            throw new RuntimeException("Create simulator failed.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextNodeTabVersion() {
        AtomicInteger atomicInteger = this.nodeTabVersion;
        synchronized (atomicInteger) {
            int nextNodeTabVersion = this.nodeTabVersion.incrementAndGet();
            if (nextNodeTabVersion > 100) {
                this.nodeTabVersion.set(0);
                nextNodeTabVersion = this.nodeTabVersion.incrementAndGet();
            }
            return nextNodeTabVersion;
        }
    }

    public void setNodeTabVersion(int nodeTabVersion) {
        this.nodeTabVersion.set(nodeTabVersion);
    }

    public static void saveSimulationConfiguration(Simulation simulation, String fileName) {
        SimulatorRegistry.saveSimulationConfiguration(simulation, new File(fileName));
    }

    public static void saveSimulationConfiguration(Simulation simulation, File file) {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            if (jaxbContext == null) {
                LOGGER.info("Initialize the JaxbContext for the SimulatorRegistry.");
                try {
                    jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
                }
                catch (JAXBException e) {
                    LOGGER.error("Failed to load the jaxbContext for SimulatorRegistry.");
                }
            }
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)JAXB_SCHEMA_LOCATION);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSource = new StreamSource(SimulatorRegistry.class.getResourceAsStream(XSD_LOCATION));
            StreamSource streamSourceBase = new StreamSource(SimulatorRegistry.class.getResourceAsStream(XSD_LOCATION_BASE));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceBase, streamSource});
            marshaller.setSchema(schema);
            marshaller.marshal((Object)simulation, (Writer)new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8")));
            ((OutputStream)os).flush();
            LOGGER.info("Save simulation content to file passed: {}", (Object)file.getPath());
        }
        catch (Exception ex) {
            LOGGER.warn("Save simulation failed.", (Throwable)ex);
            throw new RuntimeException("Save simulation failed.", ex);
        }
    }
}

