/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.annotation;

import java.util.Objects;
import org.bidib.jbidibc.messages.utils.ProductUtils;

public class BidibVidPid {
    private final int vid;
    private final int pid;

    public BidibVidPid(int vid, int pid) {
        this.vid = vid;
        this.pid = pid;
    }

    public int getVid() {
        return this.vid;
    }

    public int getPid() {
        return this.pid;
    }

    public int hashCode() {
        return Objects.hash(this.pid, this.vid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BidibVidPid other = (BidibVidPid)obj;
        return this.pid == other.pid && this.vid == other.vid;
    }

    public static BidibVidPid of(String vid, String pid) {
        return new BidibVidPid(Integer.parseInt(vid), Integer.parseInt(pid));
    }

    public static BidibVidPid of(int vid, int pid) {
        return new BidibVidPid(vid, pid);
    }

    public static BidibVidPid of(long uniqueId) {
        int vid = ProductUtils.getVendorId((long)uniqueId);
        int pid = ProductUtils.getPid((long)uniqueId);
        return BidibVidPid.of(vid, pid);
    }

    public String toString() {
        return "[" + this.vid + ":" + this.pid + "]";
    }
}

