/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.comm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.BidibInterface;
import org.bidib.jbidibc.core.BidibMessageProcessor;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.node.AccessoryNode;
import org.bidib.jbidibc.core.node.BidibNode;
import org.bidib.jbidibc.core.node.BoosterNode;
import org.bidib.jbidibc.core.node.CommandStationNode;
import org.bidib.jbidibc.core.node.InterfaceNode;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulationBidibInterface;
import org.bidib.jbidibc.simulation.SimulationInterface;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.SimulatorRegistry;
import org.bidib.jbidibc.simulation.plaintcp.SimulationNetPlainTcpBidib;
import org.bidib.jbidibc.simulation.serial.SimulationSerialBidib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationBidib
implements SimulationBidibInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationBidib.class);
    private int firmwarePacketTimeout = 400;
    private String connectedPortName;
    private boolean isOpened;
    private boolean ignoreWaitTimeout;
    private int responseTimeout;
    private SimulationInterface delegateBidib;
    private SimulatorRegistry simulatorRegistry;
    private static final String SIMULATION_FILENAME = "simulation.xml";
    private static final String SIMULATION_FOLDER_PATH = "data/simulation";
    private static final String SIMULATION_FOLDER_PATH_MACOSX = "Contents/Resources/data/simulation";

    private SimulationBidib() {
    }

    public static BidibInterface createInstance(Context context) {
        LOGGER.info("Create new instance of SimulationBidib.");
        SimulationBidib instance = new SimulationBidib();
        instance.initialize(context);
        return instance;
    }

    protected void initialize(Context context) {
        LOGGER.info("Initialize SimulationBidib. Create the simulator registry instance.");
        Map simulatorClassMapping = (Map)context.get("simulatorClassMapping", Map.class, Collections.emptyMap());
        this.simulatorRegistry = SimulatorRegistry.createInstance(simulatorClassMapping);
    }

    @Override
    public SimulatorRegistry getSimulatorRegistry() {
        return this.simulatorRegistry;
    }

    public RootNode getRootNode() {
        RootNode rootNode = null;
        try {
            rootNode = this.delegateBidib.getRootNode();
        }
        catch (Exception ex) {
            LOGGER.warn("Get the root node failed.", (Throwable)ex);
        }
        if (rootNode != null) {
            String nodeAddress = NodeUtils.formatAddress((byte[])rootNode.getAddr());
            SimulatorNode simulator = this.simulatorRegistry.getSimulator(nodeAddress);
            if (simulator == null) {
                LOGGER.warn("No simulator configured for the root node.");
            }
        } else {
            LOGGER.error("The root node is not available.");
        }
        return rootNode;
    }

    public void releaseRootNode() {
        if (this.delegateBidib != null) {
            this.delegateBidib.releaseRootNode();
        }
    }

    public void releaseSubNodesOfRootNode() {
        if (this.delegateBidib != null) {
            this.delegateBidib.releaseSubNodesOfRootNode();
        }
    }

    public void attach(Long uniqueId) {
        LOGGER.info("Attach the node, uniqueId: {}", (Object)uniqueId);
        try {
            RootNode rootNode = this.getRootNode();
            if (rootNode != null) {
                LOGGER.info("Get the magic from the rootNode.");
                rootNode.getMagic(null);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get the magic from the rootNode failed.", (Throwable)ex);
        }
    }

    public void detach(Long uniqueId) {
        LOGGER.info("Detach the node, uniqueId: {}", (Object)uniqueId);
        try {
            RootNode rootNode = this.getRootNode();
            if (rootNode != null) {
                LOGGER.info("Logoff from root node, uniqueId: {}", (Object)uniqueId);
                this.getRootNode().localLogonRejected(uniqueId.longValue());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Logoff from the rootNode failed.", (Throwable)ex);
        }
    }

    public void send(byte[] bytes) {
        LOGGER.info("Send is called with bytes: {}", (Object)ByteUtils.bytesToHex((byte[])bytes));
        try {
            this.delegateBidib.send(bytes);
        }
        catch (Exception ex) {
            LOGGER.warn("Send bytes to delegate failed.", (Throwable)ex);
        }
    }

    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open port: {}", portName);
        Object simulationFilename = SIMULATION_FILENAME;
        if ("plaintcp".equals(portName)) {
            portName = (String)portName + ":localhost:62875";
            this.delegateBidib = new SimulationNetPlainTcpBidib((String)portName);
        } else {
            this.delegateBidib = new SimulationSerialBidib();
            if (StringUtils.endsWithIgnoreCase((CharSequence)portName, (CharSequence)".xml") || StringUtils.endsWithIgnoreCase((CharSequence)portName, (CharSequence)".json")) {
                LOGGER.info("Use the provided portName as simulationFilename: {}", portName);
                simulationFilename = portName;
            }
        }
        context.register("simulationFilename", simulationFilename);
        try {
            Method method = AbstractBidib.class.getDeclaredMethod("initialize", Context.class);
            method.setAccessible(true);
            method.invoke((Object)this.delegateBidib, context);
        }
        catch (Exception ex) {
            LOGGER.warn("Call initialize on delegateBidib failed.", (Throwable)ex);
            throw new PortNotFoundException("Call initialize on delegateBidib failed.");
        }
        this.delegateBidib.setSimulatorRegistry(this.simulatorRegistry);
        this.delegateBidib.setIgnoreWaitTimeout(this.ignoreWaitTimeout);
        this.delegateBidib.setResponseTimeout(this.responseTimeout);
        this.delegateBidib.setFirmwarePacketTimeout(this.firmwarePacketTimeout);
        this.delegateBidib.setConnectionListener(connectionListener);
        this.delegateBidib.registerListeners(nodeListeners, messageListeners, transferListeners);
        LOGGER.info("Search simulationFilename: {}", simulationFilename);
        Optional<Object> simulationConfig = Optional.empty();
        try {
            simulationConfig = Optional.of(new FileInputStream(new File((String)simulationFilename)));
        }
        catch (Exception ex) {
            LOGGER.warn("Check if full path to simulation file is provided failed. Will check the search path. Current error: {}", (Object)ex.getMessage());
        }
        if (!simulationConfig.isPresent()) {
            LOGGER.info("Search the simulation file.");
            File file = new File("");
            file = new File(file.getAbsoluteFile(), SystemUtils.IS_OS_MAC_OSX ? SIMULATION_FOLDER_PATH_MACOSX : SIMULATION_FOLDER_PATH);
            String userHome = System.getProperty("user.home");
            File searchPathUserHome = new File(userHome, ".bidib/data/simulation");
            String additionalSearchRootPath = (String)context.get("simulationConfigSearchRoot", String.class, null);
            File searchPathLabelPath = null;
            if (StringUtils.isNotBlank((CharSequence)additionalSearchRootPath)) {
                searchPathLabelPath = new File(additionalSearchRootPath, SIMULATION_FOLDER_PATH);
            } else {
                LOGGER.warn("No label path provided to search the user configured simulation file.");
            }
            simulationConfig = this.searchSimulationConfiguration(context, (String)simulationFilename, new String[]{searchPathUserHome.getAbsolutePath(), searchPathLabelPath != null ? searchPathLabelPath.getAbsolutePath() : null, file.getAbsolutePath(), "classpath:/simulation"});
        } else {
            LOGGER.info("Use provided simulation file: {}", simulationConfig.get());
        }
        this.delegateBidib.start((InputStream)simulationConfig.orElseThrow(() -> {
            LOGGER.warn("No simulation configuration available.");
            return new PortNotFoundException("No simulation configuration available.");
        }), context);
        this.delegateBidib.open((String)portName, connectionListener, nodeListeners, messageListeners, transferListeners, context);
        this.connectedPortName = portName;
        this.isOpened = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<InputStream> searchSimulationConfiguration(Context context, String filename, String[] searchPaths) {
        LOGGER.info("Search simulation configuration in searchPaths: {}", new Object[]{searchPaths});
        InputStream selectedFile = null;
        for (String searchPath : searchPaths) {
            StringBuilder filenameSearch;
            if (StringUtils.isBlank((CharSequence)searchPath)) {
                LOGGER.info("Skip invalid searchPath: {}", (Object)searchPath);
                continue;
            }
            LOGGER.info("Prepared filename to load simulation: {}", (Object)filename.toString());
            if (searchPath.startsWith("classpath:")) {
                int beginIndex = "classpath:".length();
                String lookup = searchPath.substring(beginIndex) + "/" + filename.toString();
                LOGGER.info("Lookup simulation file internally: {}", (Object)lookup);
                filenameSearch = new StringBuilder("*" + filename);
                final LinkedList files = new LinkedList();
                URL pathString = this.getClass().getResource(lookup);
                LOGGER.info("Prepared pathString: {}", (Object)pathString);
                if (pathString == null) {
                    LOGGER.info("No resource for lookup '{}' found.", (Object)lookup);
                    continue;
                }
                FileSystem fs = null;
                try {
                    URI lookupURI = pathString.toURI();
                    LOGGER.info("Prepared lookupURI: {}", (Object)lookupURI);
                    final String[] array = lookupURI.toString().split("!");
                    Path path = null;
                    if (array.length > 1) {
                        HashMap env = new HashMap();
                        LOGGER.info("Create new filesystem for: {}", (Object)array[0]);
                        fs = FileSystems.newFileSystem(URI.create(array[0]), env);
                        path = fs.getPath(array[1], new String[0]);
                        LOGGER.info("Prepared path: {}", (Object)path);
                    } else {
                        path = Paths.get(lookupURI);
                    }
                    final FileSystem fsInner = fs;
                    Files.walkFileTree(path.getParent(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            LOGGER.info("Current file: {}", (Object)path);
                            if (FilenameUtils.wildcardMatch((String)path.toString(), (String)filenameSearch.toString(), (IOCase)IOCase.INSENSITIVE)) {
                                LOGGER.info("Found matching path: {}, absolutePath: {}", (Object)path, (Object)path.toAbsolutePath());
                                File file = null;
                                if (fsInner != null) {
                                    String filePath = array[0] + "!" + path.toAbsolutePath();
                                    file = new File(filePath);
                                } else {
                                    file = path.toFile();
                                }
                                LOGGER.info("Add matching file: {}", (Object)file);
                                files.add(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                            if (e == null) {
                                LOGGER.info("Current directory: {}", (Object)dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw e;
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.warn("Convert uri to path failed.", (Throwable)e);
                }
                finally {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Close filesystem failed.", (Throwable)ex);
                        }
                    }
                }
                LOGGER.info("Found matching files: {}", files);
                if (!CollectionUtils.isNotEmpty(files)) continue;
                LOGGER.info("Create input stream from lookup: {}", (Object)lookup);
                try {
                    selectedFile = SimulationBidib.class.getResourceAsStream(lookup);
                    context.register("simulationFilename", (Object)lookup);
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the file input stream from simulation configuration failed.", (Throwable)ex);
                    throw new InvalidConfigurationException("No simulation configuration available.");
                }
                LOGGER.info("Use selected file input stream: {}", (Object)selectedFile);
                continue;
            }
            LOGGER.info("Search for files in searchPath: {}", (Object)searchPath);
            File vendorCvFile = new File(searchPath, filename.toString());
            File searchDirectory = vendorCvFile.getParentFile();
            if (searchDirectory.exists()) {
                Iterator iterator;
                filenameSearch = new StringBuilder("*" + filename);
                WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{filenameSearch.toString()}).setIoCase(IOCase.INSENSITIVE).get();
                Collection files = FileUtils.listFiles((File)searchDirectory, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
                LOGGER.info("Found matching files: {}", (Object)files);
                if (CollectionUtils.isNotEmpty((Collection)files) && (iterator = files.iterator()).hasNext()) {
                    File file = (File)iterator.next();
                    LOGGER.info("Create input stream from file: {}", (Object)file);
                    try {
                        selectedFile = new FileInputStream(file);
                        context.register("simulationFilename", (Object)file.getName());
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.warn("Get the file input stream from simulation configuration failed.", (Throwable)ex);
                        throw new InvalidConfigurationException("No simulation configuration available.");
                    }
                    LOGGER.info("Use selected file input stream: {}", (Object)selectedFile);
                }
            } else {
                LOGGER.info("The directory to search does not exist: {}", (Object)searchDirectory.toString());
            }
            if (selectedFile == null) continue;
            LOGGER.info("Found simulation configuration file: {}", selectedFile);
            break;
        }
        LOGGER.info("Return selectedFileName: {}", selectedFile);
        return Optional.ofNullable(selectedFile);
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void close() {
        LOGGER.info("Close port, connectedPortName: {}", (Object)this.connectedPortName);
        try {
            this.delegateBidib.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Close delegateBidib failed.", (Throwable)ex);
        }
        this.isOpened = false;
        this.connectedPortName = null;
        LOGGER.info("Stop the simulation.");
        try {
            this.delegateBidib.stop();
        }
        catch (Exception ex) {
            LOGGER.warn("Stop delegateBidib failed.", (Throwable)ex);
        }
    }

    public List<String> getPortIdentifiers() {
        return this.delegateBidib.getPortIdentifiers();
    }

    public BidibNode getNode(Node node) {
        return this.delegateBidib.getNode(node);
    }

    public BidibNode findNode(byte[] nodeAddress) {
        return this.delegateBidib.findNode(nodeAddress);
    }

    public AccessoryNode getAccessoryNode(Node node) {
        return this.delegateBidib.getAccessoryNode(node);
    }

    public BoosterNode getBoosterNode(Node node) {
        return this.delegateBidib.getBoosterNode(node);
    }

    public CommandStationNode getCommandStationNode(Node node) {
        return this.delegateBidib.getCommandStationNode(node);
    }

    public InterfaceNode getInterfaceNode(Node node) {
        return this.delegateBidib.getInterfaceNode(node);
    }

    public MessageReceiver getMessageReceiver() {
        LOGGER.info("getMessageReceiver returns the message receiver of the delegate!");
        return this.delegateBidib.getMessageReceiver();
    }

    public void setIgnoreWaitTimeout(boolean ignoreWaitTimeout) {
        this.ignoreWaitTimeout = ignoreWaitTimeout;
        if (this.delegateBidib != null) {
            this.delegateBidib.setIgnoreWaitTimeout(ignoreWaitTimeout);
        }
    }

    public void setResponseTimeout(int timeout) {
        LOGGER.info("Set the response timeout for simulation to: {}", (Object)timeout);
        this.responseTimeout = timeout;
        if (this.delegateBidib != null) {
            this.delegateBidib.setResponseTimeout(this.responseTimeout);
        }
    }

    public int getResponseTimeout() {
        return this.delegateBidib.getResponseTimeout();
    }

    public int getFirmwarePacketTimeout() {
        return this.delegateBidib.getFirmwarePacketTimeout();
    }

    public void setFirmwarePacketTimeout(int firmwarePacketTimeout) {
        LOGGER.info("Set the firmwarePacketTimeout: {}", (Object)firmwarePacketTimeout);
        this.firmwarePacketTimeout = firmwarePacketTimeout;
        if (this.delegateBidib != null) {
            this.delegateBidib.setFirmwarePacketTimeout(firmwarePacketTimeout);
        }
    }

    public boolean isValidCoreNode(Node node) {
        if (this.delegateBidib != null) {
            return this.delegateBidib.isValidCoreNode(node);
        }
        return false;
    }

    public BidibMessageProcessor getBidibMessageProcessor() {
        LOGGER.info("getBidibMessageProcessor returns the bidib message processor of the delegate!");
        return this.delegateBidib.getBidibMessageProcessor();
    }

    public void addRawMessageListener(RawMessageListener rawMessageListener) {
        if (this.delegateBidib != null) {
            this.delegateBidib.addRawMessageListener(rawMessageListener);
        }
    }

    public void removeRawMessageListener(RawMessageListener rawMessageListener) {
        if (this.delegateBidib != null) {
            this.delegateBidib.removeRawMessageListener(rawMessageListener);
        }
    }

    public void signalUserAction(String actionKey, Context context) {
    }
}

