/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import org.bidib.jbidibc.simulation.nodes.DmxChannelParamsType;
import org.bidib.jbidibc.simulation.nodes.DmxChannelsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxChannelsDeserializer
extends StdDeserializer<DmxChannelsType> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxChannelsDeserializer.class);

    public DmxChannelsDeserializer() {
        super(DmxChannelsType.class);
    }

    public DmxChannelsType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        LOGGER.trace("Current token: {}", (Object)t);
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        } else if (t != JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Unexpected token: " + t);
        }
        DmxChannelsType dmxChannelsType = new DmxChannelsType();
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = p.currentName();
            t = p.nextToken();
            LOGGER.trace("Current fieldName: {}, next token: {}", (Object)fieldName, (Object)t);
            if (fieldName.equals("count")) {
                dmxChannelsType.withCount(p.getValueAsInt());
            } else if (fieldName.equals("channels")) {
                CollectionType javaType = ctxt.getTypeFactory().constructCollectionType(List.class, DmxChannelParamsType.class);
                List channels = (List)ctxt.readValue(p, (JavaType)javaType);
                dmxChannelsType.withChannel(channels);
            }
            t = p.nextToken();
        }
        return dmxChannelsType;
    }
}

