/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import org.bidib.jbidibc.simulation.nodes.LightPortParamsType;
import org.bidib.jbidibc.simulation.nodes.LightPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightPortDeserializer
extends StdDeserializer<LightPortType> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPortDeserializer.class);

    public LightPortDeserializer() {
        super(LightPortType.class);
    }

    public LightPortType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        LOGGER.trace("Current token: {}", (Object)t);
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        } else if (t != JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Unexpected token: " + t);
        }
        LightPortType portType = new LightPortType();
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = p.currentName();
            t = p.nextToken();
            LOGGER.trace("Current fieldName: {}, next token: {}", (Object)fieldName, (Object)t);
            if (fieldName.equals("count")) {
                portType.withCount(p.getValueAsInt());
            } else if (fieldName.equals("offset")) {
                portType.withOffset(p.getValueAsInt());
            } else if (fieldName.equals("ports")) {
                CollectionType javaType = ctxt.getTypeFactory().constructCollectionType(List.class, LightPortParamsType.class);
                List ports = (List)ctxt.readValue(p, (JavaType)javaType);
                portType.withPort(ports);
            }
            t = p.nextToken();
        }
        return portType;
    }
}

