/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.bidib.jbidibc.simulation.nodes.MotorPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorPortDeserializer
extends StdDeserializer<MotorPortType> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPortDeserializer.class);

    public MotorPortDeserializer() {
        super(MotorPortType.class);
    }

    public MotorPortType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        LOGGER.trace("Current token: {}", (Object)t);
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        } else if (t != JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Unexpected token: " + t);
        }
        MotorPortType portType = new MotorPortType();
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = p.currentName();
            t = p.nextToken();
            LOGGER.trace("Current fieldName: {}, next token: {}", (Object)fieldName, (Object)t);
            if (fieldName.equals("count")) {
                portType.withCount(p.getValueAsInt());
            } else if (fieldName.equals("offset")) {
                portType.withOffset(p.getValueAsInt());
            } else if (fieldName.equals("ports")) {
                // empty if block
            }
            t = p.nextToken();
        }
        return portType;
    }
}

