/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import org.bidib.jbidibc.simulation.nodes.SwitchPortParamsType;
import org.bidib.jbidibc.simulation.nodes.SwitchPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortDeserializer
extends StdDeserializer<SwitchPortType> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortDeserializer.class);

    public SwitchPortDeserializer() {
        super(SwitchPortType.class);
    }

    public SwitchPortType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        LOGGER.trace("Current token: {}", (Object)t);
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        } else if (t != JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Unexpected token: " + t);
        }
        SwitchPortType portType = new SwitchPortType();
        while (t == JsonToken.FIELD_NAME) {
            String fieldName = p.currentName();
            t = p.nextToken();
            LOGGER.trace("Current fieldName: {}, next token: {}", (Object)fieldName, (Object)t);
            if (fieldName.equals("count")) {
                portType.withCount(p.getValueAsInt());
            } else if (fieldName.equals("offset")) {
                portType.withOffset(p.getValueAsInt());
            } else if (fieldName.equals("ports")) {
                CollectionType javaType = ctxt.getTypeFactory().constructCollectionType(List.class, SwitchPortParamsType.class);
                List ports = (List)ctxt.readValue(p, (JavaType)javaType);
                portType.withPort(ports);
            }
            t = p.nextToken();
        }
        return portType;
    }
}

