/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.nodes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.VendorData;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateOperation;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.message.AccessoryNotifyResponse;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.FeatureCountResponse;
import org.bidib.jbidibc.messages.message.FeatureGetMessage;
import org.bidib.jbidibc.messages.message.FeatureNotAvailableResponse;
import org.bidib.jbidibc.messages.message.FeatureResponse;
import org.bidib.jbidibc.messages.message.FeatureSetMessage;
import org.bidib.jbidibc.messages.message.FwUpdateOpMessage;
import org.bidib.jbidibc.messages.message.FwUpdateStatResponse;
import org.bidib.jbidibc.messages.message.LocalEmitterMessage;
import org.bidib.jbidibc.messages.message.LocalPongResponse;
import org.bidib.jbidibc.messages.message.NodeLostResponse;
import org.bidib.jbidibc.messages.message.NodeNewResponse;
import org.bidib.jbidibc.messages.message.NodeTabCountResponse;
import org.bidib.jbidibc.messages.message.NodeTabResponse;
import org.bidib.jbidibc.messages.message.StallResponse;
import org.bidib.jbidibc.messages.message.StringGetMessage;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.StringSetMessage;
import org.bidib.jbidibc.messages.message.SysErrorResponse;
import org.bidib.jbidibc.messages.message.SysIdentifyStateResponse;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.SysPVersionResponse;
import org.bidib.jbidibc.messages.message.SysPingMessage;
import org.bidib.jbidibc.messages.message.SysPongResponse;
import org.bidib.jbidibc.messages.message.SysSwVersionResponse;
import org.bidib.jbidibc.messages.message.SysUniqueIdResponse;
import org.bidib.jbidibc.messages.message.VendorAckResponse;
import org.bidib.jbidibc.messages.message.VendorEnableMessage;
import org.bidib.jbidibc.messages.message.VendorGetMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.message.VendorSetMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.jbidibc.simulation.InterfaceNode;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.SimulatorRegistry;
import org.bidib.jbidibc.simulation.events.AccessoryStateErrorEvent;
import org.bidib.jbidibc.simulation.events.IdentifyEvent;
import org.bidib.jbidibc.simulation.events.NodeAvailableEvent;
import org.bidib.jbidibc.simulation.events.NodeLostEvent;
import org.bidib.jbidibc.simulation.events.SimulatorStatusEvent;
import org.bidib.jbidibc.simulation.events.StallEvent;
import org.bidib.jbidibc.simulation.events.SysErrorEvent;
import org.bidib.jbidibc.simulation.nodes.CvType;
import org.bidib.jbidibc.simulation.nodes.CvsType;
import org.bidib.jbidibc.simulation.nodes.FeatureType;
import org.bidib.jbidibc.simulation.nodes.FeaturesType;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.LoggerFactory;

public class DefaultNodeSimulator
implements InterfaceNode,
SimulatorNode {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(DefaultNodeSimulator.class);
    protected byte[] nodeAddress;
    private byte localAddrIndex;
    protected long uniqueId;
    private int nodeMagic = 45054;
    boolean autoAddFeature;
    private boolean identifyActive;
    protected SortedMap<String, SimulatorNode> subNodes = new TreeMap<String, SimulatorNode>();
    private int sendNum;
    private String[] stringValue = new String[]{"", ""};
    private int currentFeature;
    protected SortedSet<Feature> features = new TreeSet<Feature>();
    protected Map<String, String> configurationVariables = new LinkedHashMap<String, String>();
    private BlockingQueue<BidibMessageInterface> sendQueue = new LinkedBlockingQueue<BidibMessageInterface>();
    private final ScheduledExecutorService requestWorker;
    private final ScheduledExecutorService responseWorker;
    private final ScheduledExecutorService availableAfterResetWorker = Executors.newScheduledThreadPool(1);
    private final SimulationBidibMessageProcessor messageReceiver;
    private ProtocolVersion protocolVersion;
    private SoftwareVersion softwareVersion = new SoftwareVersion(1, 0, 0);
    private PortModelEnum portModelEnum;
    private SimulatorRegistry simulatorRegistry;
    private final BidibRequestFactory bidibRequestFactory;
    protected final Logger messageLogger;
    private AtomicBoolean requestWorkerRunning = new AtomicBoolean();

    public DefaultNodeSimulator(byte[] nodeAddress, long uniqueId, boolean autoAddFeature, SimulationBidibMessageProcessor messageReceiver, BidibRequestFactory bidibRequestFactory) {
        this.nodeAddress = nodeAddress;
        this.messageReceiver = messageReceiver;
        this.uniqueId = uniqueId;
        this.autoAddFeature = autoAddFeature;
        this.bidibRequestFactory = bidibRequestFactory;
        this.messageLogger = new Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER.error(format, arguments);
            }
        };
        LOGGER.info("Create default node simulator with address: {}, uniqueId: {}, autoAddFeature: {}", new Object[]{nodeAddress, uniqueId, autoAddFeature});
        this.responseWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("simResponseWorkers-thread-%d").setPriority(6).build());
        this.requestWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("simRequestWorkers-thread-%d").setPriority(6).build());
    }

    protected byte[] getNodeAddress() {
        return this.nodeAddress;
    }

    protected BidibRequestFactory getBidibRequestFactory() {
        return this.bidibRequestFactory;
    }

    @Override
    public void setSimulatorRegistry(SimulatorRegistry simulatorRegistry) {
        this.simulatorRegistry = simulatorRegistry;
    }

    public Map<String, SimulatorNode> getSubNodes() {
        return this.subNodes;
    }

    @Override
    public void addSubNode(SimulatorNode simulator) {
        String nodeAddress = simulator.getLocalAddress().trim();
        LOGGER.info("Add new subnode, address: {}, simulator: {}", (Object)nodeAddress, (Object)simulator);
        this.subNodes.put(nodeAddress, simulator);
    }

    protected void setNodeMagic(int nodeMagic) {
        this.nodeMagic = nodeMagic;
    }

    protected int getNodeMagic() {
        return this.nodeMagic;
    }

    @Override
    public void setNodeName(String nodeName) {
        if (StringUtils.isNotBlank((CharSequence)nodeName)) {
            this.stringValue[1] = nodeName;
        }
    }

    @Override
    public void setProductName(String productName) {
        if (StringUtils.isNotBlank((CharSequence)productName)) {
            this.stringValue[0] = productName;
        }
    }

    @Override
    public void setProtocolVersion(String protocolVersion) {
        LOGGER.info("Set the protocol version: {}", (Object)protocolVersion);
        String[] splited = protocolVersion.split("\\.");
        if (splited.length == 2) {
            this.protocolVersion = new ProtocolVersion(Integer.parseInt(splited[0]), (int)ByteUtils.getLowByte((int)Integer.parseInt(splited[1])));
        } else {
            LOGGER.error("Invalid protocol version provided: {}", (Object)protocolVersion);
        }
    }

    protected ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setSoftwareVersion(String version) {
        LOGGER.info("Set the software version: {}", (Object)version);
        try {
            this.softwareVersion = SoftwareVersion.parse((String)version);
        }
        catch (Exception ex) {
            LOGGER.warn("Parse software version failed, fall back to default.", (Throwable)ex);
            this.softwareVersion = new SoftwareVersion(1, 0, 0);
        }
    }

    @Override
    public void setFeatures(FeaturesType featuresType) {
        if (featuresType == null || CollectionUtils.isEmpty(featuresType.getFeature())) {
            return;
        }
        LOGGER.info("Set the provided features: {}", (Object)featuresType);
        for (FeatureType featureType : featuresType.getFeature()) {
            if (featureType.getValue() != null) {
                Feature feature = Feature.valueOf((String)featureType.getType(), (int)featureType.getValue());
                boolean removed = this.features.remove(feature);
                LOGGER.info("Removed existing feature: {}, feature id: {}", (Object)removed, (Object)feature.getType());
                this.features.add(feature);
                continue;
            }
            LOGGER.info("Remove feature: {}", (Object)featureType.getType());
            final Integer requestedFeatureId = Feature.getFeatureNumberByName((String)featureType.getType());
            if (requestedFeatureId != null) {
                Feature feature = (Feature)IterableUtils.find(this.features, (Predicate)new Predicate<Feature>(){

                    public boolean evaluate(Feature feature) {
                        return feature.isRequestedFeature(requestedFeatureId.intValue());
                    }
                });
                if (feature != null) {
                    this.features.remove(feature);
                    this.prepared();
                    continue;
                }
                LOGGER.warn("No feature found to remove for id: {}", (Object)requestedFeatureId);
                continue;
            }
            LOGGER.warn("No feature found with id: {}", (Object)featureType.getType());
        }
    }

    protected void prepareFeatures() {
        this.features.add(new Feature(252, 24));
        this.features.add(new Feature(253, 16));
    }

    @Override
    public void setCVs(CvsType cvsType) {
        if (cvsType == null || CollectionUtils.isEmpty(cvsType.getCv())) {
            return;
        }
        for (CvType cvType : cvsType.getCv()) {
            LOGGER.info("Set the CV: {}", (Object)cvType);
            this.configurationVariables.put(cvType.getNumber(), cvType.getValue());
        }
    }

    protected void prepareCVs() {
    }

    protected int getFlatPortModelPortCount() {
        Feature feature = this.getFeature(70);
        if (feature != null) {
            int numPorts = feature.getValue();
            return numPorts;
        }
        return 0;
    }

    protected boolean isPortFlatModelAvailable() {
        Feature feature = this.getFeature(70);
        return feature != null && feature.getValue() > 0;
    }

    public PortModelEnum getPortModel() {
        if (this.portModelEnum == null) {
            this.portModelEnum = this.getFlatPortModelPortCount() > 0 ? PortModelEnum.flat : PortModelEnum.type;
        }
        return this.portModelEnum;
    }

    @Override
    public Feature getFeature(int featureNum) {
        for (Feature feature : this.features) {
            if (feature.getType() != featureNum) continue;
            return feature;
        }
        return null;
    }

    protected boolean isFeedbackChangesEnabled() {
        Feature feature = this.getFeature(1);
        return feature != null && feature.getValue() > 0;
    }

    protected void prepared() {
    }

    @Override
    public String getSimulationPanelClass() {
        return null;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getAddress() {
        return ByteUtils.bytesToHex((byte[])this.nodeAddress);
    }

    @Override
    public String getLocalAddress() {
        int len = this.nodeAddress.length;
        return ByteUtils.byteToHex((byte)this.nodeAddress[len - 1]);
    }

    protected byte getLocalAddr() {
        int len = this.nodeAddress.length;
        return this.nodeAddress[len - 1];
    }

    @Override
    public void init(Context context) {
        this.prepareFeatures();
        this.prepareCVs();
        this.prepared();
    }

    @Override
    public void postConstruct() {
        if (!ProductUtils.isGBMBoostMaster((long)this.uniqueId) && Feature.findFeature(this.features, (int)254) == null) {
            LOGGER.info("Add the firmware update feature.");
            this.features.add(new Feature(254, 1));
        }
    }

    @Override
    public void start() {
        if (this.requestWorkerRunning.get()) {
            LOGGER.error("The simulator with address {} is already started!", (Object)this.getAddress());
            throw new IllegalStateException("The simulator is already started!");
        }
        String ownNodeAddress = "00";
        LOGGER.info("Add myself as subnode, address: {}, simulator: {}", (Object)ownNodeAddress, (Object)this);
        this.subNodes.put(ownNodeAddress.trim(), this);
        this.requestWorkerRunning.set(true);
        this.requestWorker.schedule(() -> {
            LOGGER.info("Started request worker.");
            while (this.requestWorkerRunning.get()) {
                try {
                    BidibMessageInterface bidibMessage = this.sendQueue.take();
                    if (bidibMessage != null) {
                        LOGGER.info("Process message: {}", (Object)bidibMessage);
                        byte[] response = this.prepareResponse(bidibMessage);
                        this.publishResponse(response);
                        LOGGER.info("Process message has finished: {}", (Object)bidibMessage);
                        continue;
                    }
                    LOGGER.info("No message available.");
                }
                catch (InterruptedException ex) {
                    if (this.requestWorkerRunning.get()) {
                        LOGGER.warn("Process request and send response failed.", (Throwable)ex);
                        continue;
                    }
                    LOGGER.info("Request worker was interrupted while waiting for messages.");
                }
                catch (Exception ex) {
                    LOGGER.warn("Process request and send response failed.", (Throwable)ex);
                }
            }
            LOGGER.info("Process message worker has finished.");
        }, 0L, TimeUnit.MILLISECONDS);
        SimulatorStatusEvent simulatorStatusEvent = new SimulatorStatusEvent(ByteUtils.bytesToHex((byte[])this.nodeAddress), SimulatorStatusEvent.Status.started);
        EventBus.publish((Object)simulatorStatusEvent);
    }

    @Override
    public void stop() {
        LOGGER.info("The simulator is stopped: {}", (Object)ByteUtils.bytesToHex((byte[])this.nodeAddress));
        SimulatorStatusEvent simulatorStatusEvent = new SimulatorStatusEvent(ByteUtils.bytesToHex((byte[])this.nodeAddress), SimulatorStatusEvent.Status.stopped);
        EventBus.publish((Object)simulatorStatusEvent);
        this.availableAfterResetWorker.shutdownNow();
        this.responseWorker.shutdownNow();
        this.requestWorkerRunning.set(false);
        this.requestWorker.shutdownNow();
    }

    protected byte[] prepareResponse(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        switch (ByteUtils.getInt((byte)bidibMessage.getType())) {
            case 1: {
                response = this.processSysGetMagicRequest(bidibMessage);
                break;
            }
            case 24: {
                this.processSysClockRequest(bidibMessage);
                break;
            }
            case 2: {
                response = this.processSysGetPVersionRequest(bidibMessage);
                break;
            }
            case 6: {
                response = this.processSysGetSwVersionRequest(bidibMessage);
                break;
            }
            case 3: {
                this.processSysEnableRequest(bidibMessage);
                break;
            }
            case 4: {
                this.processSysDisableRequest(bidibMessage);
                break;
            }
            case 5: {
                response = this.processSysGetUniqueIdRequest(bidibMessage);
                break;
            }
            case 8: {
                this.processSysIdentifyRequest(bidibMessage);
                break;
            }
            case 7: {
                response = this.processSysPingRequest(bidibMessage);
                break;
            }
            case 11: {
                response = this.processNodeTabGetAllRequest(bidibMessage);
                break;
            }
            case 12: {
                response = this.processNodeTabGetNextRequest(bidibMessage);
                break;
            }
            case 13: {
                this.processNodeChangedAckRequest(bidibMessage);
                break;
            }
            case 14: {
                response = this.processSysGetErrorRequest(bidibMessage);
                break;
            }
            case 18: {
                response = this.processFeatureGetRequest(bidibMessage);
                break;
            }
            case 19: {
                response = this.processFeatureSetRequest(bidibMessage);
                break;
            }
            case 16: {
                response = this.processFeatureGetAllRequest(bidibMessage);
                break;
            }
            case 17: {
                response = this.processFeatureGetNextRequest(bidibMessage);
                break;
            }
            case 20: {
                response = this.processVendorEnableRequest(bidibMessage);
                break;
            }
            case 21: {
                response = this.processVendorDisableRequest(bidibMessage);
                break;
            }
            case 22: {
                response = this.processVendorSetRequest(bidibMessage);
                break;
            }
            case 23: {
                response = this.processVendorGetRequest(bidibMessage);
                break;
            }
            case 26: {
                response = this.processStringSetRequest(bidibMessage);
                break;
            }
            case 25: {
                response = this.processStringGetRequest(bidibMessage);
                break;
            }
            case 9: {
                LOGGER.info("MSG_SYS_RESET, reset sendNum.");
                this.processResetRequest(bidibMessage);
                break;
            }
            case 15: {
                response = this.processFwUpdateOpRequest(bidibMessage);
                break;
            }
            case 127: {
                this.processLocalEmitterRequest(bidibMessage);
                break;
            }
            case 113: {
                response = this.processLocalPingRequest(bidibMessage);
                break;
            }
            default: {
                LOGGER.warn("Unknown message detected: {}", (Object)bidibMessage);
            }
        }
        return response;
    }

    @Override
    public void processRequest(BidibMessageInterface bidibCommand) {
        LOGGER.info("Add request to send queue: {}", (Object)bidibCommand);
        this.sendQueue.offer(bidibCommand);
        LOGGER.info("Scheduled request for processing: {}", (Object)bidibCommand);
    }

    protected synchronized void publishResponse(byte[] response) {
        LOGGER.debug("Publish response.");
        if (response != null) {
            try {
                int index = 1;
                while (response[index] != 0) {
                    ++index;
                }
                int sendMsgNum = 0;
                switch (ByteUtils.getInt((byte)response[index + 2])) {
                    case 241: 
                    case 252: {
                        break;
                    }
                    default: {
                        sendMsgNum = this.getNextResponseSendNum();
                    }
                }
                response[index + 1] = ByteUtils.getLowByte((int)sendMsgNum);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                output.write(response);
                output.flush();
                LOGGER.info("Send output with sendMsgNum: {} to receiver: {}, content: {}", new Object[]{sendMsgNum, this.messageReceiver, ByteUtils.bytesToHex((byte[])response)});
                this.messageReceiver.publishResponse(output);
            }
            catch (IOException | ProtocolException ex) {
                LOGGER.warn("Send message to publish in messageReceiver failed.", ex);
            }
            catch (Exception ex) {
                LOGGER.warn("Publish messages failed.", (Throwable)ex);
            }
        } else {
            LOGGER.info("No response available to send.");
        }
    }

    protected void sendSpontanousResponse(byte[] response) {
        LOGGER.info("Send spontanous response: {}", (Object)response);
        this.responseWorker.schedule(() -> {
            LOGGER.info("Send response: {}", (Object)response);
            this.publishResponse(response);
            LOGGER.info("Send response worker has finished.");
        }, 0L, TimeUnit.MILLISECONDS);
    }

    protected byte[] processSysGetMagicRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            LOGGER.info("Reset the sendNum because the SYS_MAGIC is tranferred with 0.");
            this.resetSendNum();
            SysMagicResponse magicResponse = new SysMagicResponse(bidibMessage.getAddr(), this.getNextSendNum(), new byte[]{ByteUtils.getLowByte((int)this.nodeMagic), ByteUtils.getHighByte((int)this.nodeMagic)});
            response = magicResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create magic response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processSysClockRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysClockMessage: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processLocalEmitterRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LocalEmitterMessage: {}, do nothing ...", (Object)bidibMessage);
        LocalEmitterMessage message = (LocalEmitterMessage)bidibMessage;
        LOGGER.info("The emitter of the message: {}", (Object)message.getEmitter());
    }

    protected byte[] processLocalPingRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the LocalPingMessage: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LocalPongResponse localPongResponse = this.bidibRequestFactory.createLocalPongResponse(bidibMessage.getAddr());
            response = localPongResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create localPong response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processSysGetPVersionRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysGetPVersion request: {}, do nothing ...", (Object)bidibMessage);
        byte[] response = null;
        try {
            LOGGER.info("Current protocolVersion: {}", (Object)this.protocolVersion);
            SysPVersionResponse sysPVersionResponse = new SysPVersionResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.protocolVersion.getMajorVersion(), this.protocolVersion.getMinorVersion());
            response = sysPVersionResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysPVersion response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processSysGetSwVersionRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysGetSwVersion request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            LOGGER.info("Current softwareVersion: {}", (Object)this.softwareVersion);
            SysSwVersionResponse sysSwVersionResponse = new SysSwVersionResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.softwareVersion.asByteArray());
            response = sysSwVersionResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysSwVersion response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processSysGetErrorRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysGetError request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            SysErrorResponse sysErrorResponse = new SysErrorResponse(bidibMessage.getAddr(), this.getNextSendNum(), SysErrorEnum.BIDIB_ERR_NONE, new byte[0]);
            response = sysErrorResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysError response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processSysEnableRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysEnable request: {}, do nothing ...", (Object)bidibMessage);
    }

    protected void processSysDisableRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysDisable request: {}, do nothing ...", (Object)bidibMessage);
    }

    protected byte[] processSysGetUniqueIdRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysGetUniqueId request: {}, do nothing ...", (Object)bidibMessage);
        byte[] response = null;
        try {
            SysUniqueIdResponse sysUniqueIdResponse = new SysUniqueIdResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.getUniqueId());
            response = sysUniqueIdResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysUniqueId response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processSysIdentifyRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysIdentify request: {}", (Object)bidibMessage);
    }

    protected byte[] processSysPingRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the SysPing request: {}", (Object)bidibMessage);
        byte[] response = null;
        try {
            SysPingMessage sysPingMessage = (SysPingMessage)bidibMessage;
            SysPongResponse sysPongResponse = new SysPongResponse(bidibMessage.getAddr(), this.getNextSendNum(), sysPingMessage.getMarker());
            response = sysPongResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create sysPong response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processNodeTabGetAllRequest(BidibMessageInterface bidibMessage) {
        this.localAddrIndex = 0;
        int tabCount = this.subNodes.size();
        LOGGER.info("Return number of nodeTabs in current node: {}", (Object)tabCount);
        byte[] response = null;
        try {
            NodeTabCountResponse nodeTabCountResponse = new NodeTabCountResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)tabCount));
            response = nodeTabCountResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create nodeTabCount response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processNodeTabGetNextRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        byte nodeTabVersion = 1;
        byte localAddr = this.localAddrIndex;
        LOGGER.info("get the simulator with local address: {}", (Object)localAddr);
        String[] nodeAddresses = this.subNodes.keySet().toArray(new String[0]);
        byte addr = ByteUtils.getLowByte((int)Integer.parseInt(nodeAddresses[localAddr], 16));
        SimulatorNode simulator = (SimulatorNode)this.subNodes.get(nodeAddresses[localAddr]);
        long uniqueId = simulator.getUniqueId();
        LOGGER.info("localAddr: {}, nodeAddr: {}, uniqueId: {}", new Object[]{localAddr, addr, uniqueId});
        try {
            NodeTabResponse nodeTabResponse = new NodeTabResponse(bidibMessage.getAddr(), this.getNextSendNum(), nodeTabVersion, addr, uniqueId);
            response = nodeTabResponse.getContent();
            LOGGER.info("Prepared nodeTab response: {}", (Object)ByteUtils.bytesToHex((byte[])response));
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create nodeTab response failed.", (Throwable)ex);
        }
        this.localAddrIndex = (byte)(this.localAddrIndex + 1);
        return response;
    }

    protected void processNodeChangedAckRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Node changed ack was received: {}", (Object)bidibMessage);
    }

    protected byte[] processFeatureGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            FeatureNotAvailableResponse featureResponse;
            FeatureGetMessage featureGetMessage = (FeatureGetMessage)bidibMessage;
            int featureNum = featureGetMessage.getNumber();
            LOGGER.info("Get feature with number: {}", (Object)featureNum);
            Feature foundFeature = null;
            for (Feature feature : this.features) {
                if (feature.getType() != featureNum) continue;
                foundFeature = feature;
                LOGGER.info("Found feature: {}", (Object)foundFeature);
                break;
            }
            if (foundFeature != null) {
                featureResponse = new FeatureResponse(featureGetMessage.getAddr(), this.getNextSendNum(), featureNum, foundFeature.getValue());
                response = featureResponse.getContent();
                LOGGER.info("Prepared response: {}", (Object)ByteUtils.bytesToHex((byte[])response));
            } else {
                featureResponse = new FeatureNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), featureNum);
                response = featureResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feature response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processFeatureSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            FeatureNotAvailableResponse featureResponse;
            FeatureSetMessage featureSetMessage = (FeatureSetMessage)bidibMessage;
            int featureNum = featureSetMessage.getNumber();
            int featureValue = featureSetMessage.getValue();
            LOGGER.info("Set feature with number: {}, value: {}", (Object)featureNum, (Object)featureValue);
            Feature foundFeature = null;
            for (Feature feature : this.features) {
                if (feature.getType() != featureNum) continue;
                foundFeature = this.updateFeatureValue(feature, featureValue);
                LOGGER.info("Found feature: {}", (Object)foundFeature);
                break;
            }
            if (foundFeature == null && this.autoAddFeature) {
                LOGGER.info("AutoAddFeature is activated.");
                foundFeature = this.autoAddFeature(featureNum, featureValue);
            }
            if (foundFeature != null) {
                featureResponse = new FeatureResponse(featureSetMessage.getAddr(), this.getNextSendNum(), featureNum, foundFeature.getValue());
                response = featureResponse.getContent();
                LOGGER.info("Prepared response: {}", (Object)ByteUtils.bytesToHex((byte[])response));
            } else {
                featureResponse = new FeatureNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), featureNum);
                response = featureResponse.getContent();
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feature response failed.", (Throwable)ex);
        }
        return response;
    }

    protected Feature updateFeatureValue(Feature feature, int featureValue) {
        feature.setValue(featureValue);
        return feature;
    }

    protected Feature autoAddFeature(int featureNum, int featureValue) {
        Feature foundFeature = new Feature(featureNum, featureValue);
        this.features.add(foundFeature);
        return foundFeature;
    }

    protected byte[] processFeatureGetAllRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            FeatureCountResponse featureResponse = new FeatureCountResponse(bidibMessage.getAddr(), this.getNextSendNum(), this.features.size());
            response = featureResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create feature count response failed.", (Throwable)ex);
        }
        this.currentFeature = 0;
        return response;
    }

    protected byte[] processFeatureGetNextRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        if (this.currentFeature >= this.features.size()) {
            try {
                FeatureNotAvailableResponse featureResponse = new FeatureNotAvailableResponse(bidibMessage.getAddr(), this.getNextSendNum(), 255);
                response = featureResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create feature N/A response failed.", (Throwable)ex);
            }
        } else {
            try {
                Feature feature = (Feature)IterableUtils.get(this.features, (int)this.currentFeature);
                FeatureResponse featureResponse = new FeatureResponse(bidibMessage.getAddr(), this.getNextSendNum(), feature.getType(), feature.getValue());
                response = featureResponse.getContent();
            }
            catch (ProtocolException ex) {
                LOGGER.warn("Create feature response failed.", (Throwable)ex);
            }
            catch (Exception ex) {
                LOGGER.warn("Create feature response failed.", (Throwable)ex);
            }
        }
        ++this.currentFeature;
        return response;
    }

    protected byte[] processVendorEnableRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            VendorEnableMessage vendorEnableMessage = (VendorEnableMessage)bidibMessage;
            long uniqueId = vendorEnableMessage.getUniqueId();
            LOGGER.info("Enable the user config mode for uniqueId: {}", (Object)uniqueId);
            byte userConfigModeActive = 1;
            VendorAckResponse vendorAckResponse = new VendorAckResponse(bidibMessage.getAddr(), this.getNextSendNum(), userConfigModeActive);
            response = vendorAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor ack response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processVendorDisableRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            LOGGER.info("Disable the user config mode.");
            byte userConfigModeActive = 0;
            VendorAckResponse vendorAckResponse = new VendorAckResponse(bidibMessage.getAddr(), this.getNextSendNum(), userConfigModeActive);
            response = vendorAckResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor ack response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processVendorSetRequest(BidibMessageInterface bidibMessage) {
        return this.processVendorSetRequest(bidibMessage, vd -> this.configurationVariables.put(vd.getName(), vd.getValue()));
    }

    protected byte[] processVendorSetRequest(BidibMessageInterface bidibMessage, Consumer<VendorData> vendorDataConsumer) {
        byte[] response = null;
        try {
            VendorSetMessage vendorSetMessage = (VendorSetMessage)bidibMessage;
            VendorData vendorData = vendorSetMessage.getVendorData();
            LOGGER.info("Set the vendor data: {}", (Object)vendorData);
            vendorDataConsumer.accept(vendorData);
            VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorData.getName(), vendorData.getValue());
            response = vendorResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processVendorGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            VendorGetMessage vendorGetMessage = (VendorGetMessage)bidibMessage;
            String vendorDataName = vendorGetMessage.getVendorDataName();
            LOGGER.info("Get the vendor data with name: {}", (Object)vendorDataName);
            String vendorDataValue = this.configurationVariables.get(vendorDataName);
            if (StringUtils.isBlank((CharSequence)vendorDataValue)) {
                vendorDataValue = "";
            }
            VendorResponse vendorResponse = new VendorResponse(bidibMessage.getAddr(), this.getNextSendNum(), vendorDataName, vendorDataValue);
            response = vendorResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create vendor response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processStringSetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            StringSetMessage stringSetMessage = (StringSetMessage)bidibMessage;
            int stringId = stringSetMessage.getStringId();
            this.stringValue[stringId] = stringSetMessage.getString();
            StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringSetMessage.getNamespace()), ByteUtils.getLowByte((int)stringSetMessage.getStringId()), this.stringValue[stringId]);
            response = stringResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create string response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processStringGetRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            StringGetMessage stringGetMessage = (StringGetMessage)bidibMessage;
            int stringId = stringGetMessage.getStringId();
            LOGGER.info("Get STRING[{}]: {}", (Object)stringId, (Object)this.stringValue[stringId]);
            StringResponse stringResponse = new StringResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)stringGetMessage.getNamespace()), ByteUtils.getLowByte((int)stringGetMessage.getStringId()), this.stringValue[stringId]);
            response = stringResponse.getContent();
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create string response failed.", (Throwable)ex);
        }
        return response;
    }

    protected byte[] processFwUpdateOpRequest(BidibMessageInterface bidibMessage) {
        byte[] response = null;
        try {
            FwUpdateOpMessage fwUpdateOpMessage = (FwUpdateOpMessage)bidibMessage;
            FirmwareUpdateOperation operation = fwUpdateOpMessage.getOperation();
            LOGGER.info("processFwUpdateOpRequest, operation: {}", (Object)operation);
            int timeout = 0;
            int status = 255;
            switch (operation) {
                case ENTER: {
                    status = 0;
                    break;
                }
                case DATA: {
                    status = 2;
                    break;
                }
                case SETDEST: {
                    status = 2;
                    break;
                }
                case EXIT: {
                    status = 1;
                    timeout = 100;
                    break;
                }
                case DONE: {
                    status = 0;
                    break;
                }
            }
            FwUpdateStatResponse fwUpdateStatResponse = new FwUpdateStatResponse(bidibMessage.getAddr(), this.getNextSendNum(), ByteUtils.getLowByte((int)status), ByteUtils.getLowByte((int)timeout));
            response = fwUpdateStatResponse.getContent();
            this.sendSpontanousResponse(response);
            if (status == 1) {
                LOGGER.info("The node must restart after firmware update.");
                this.processResetRequest(null);
            }
            response = null;
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create fwUpdateStat response failed.", (Throwable)ex);
        }
        return response;
    }

    protected void processResetRequest(BidibMessageInterface bidibMessage) {
        LOGGER.info("Process the reset request, bidibMessage: {}", (Object)bidibMessage);
        this.resetSendNum();
        final byte[] oldNodeAddress = this.nodeAddress;
        LOGGER.info("Notify the parent that we have gone, address: {}, uniqueId: {}", (Object)this.getLocalAddress(), (Object)this.uniqueId);
        EventBus.publish((Object)new NodeLostEvent(this.nodeAddress, this.uniqueId));
        this.availableAfterResetWorker.schedule(new Runnable(){

            @Override
            public void run() {
                NodeAvailableEvent nodeAvailableEvent = new NodeAvailableEvent(oldNodeAddress, DefaultNodeSimulator.this.uniqueId);
                LOGGER.info("Send NodeAvailableEvent: {}", (Object)nodeAvailableEvent);
                EventBus.publish((Object)nodeAvailableEvent);
                LOGGER.info("Send availableAfterResetWorker has finished.");
            }
        }, 1L, TimeUnit.SECONDS);
    }

    protected void resetSendNum() {
        LOGGER.info("Reset the sendNum to 0.");
        this.sendNum = 0;
    }

    protected int getNextSendNum() {
        return 0;
    }

    protected int getCurrentSendNum() {
        return this.sendNum;
    }

    protected int getNextResponseSendNum() {
        int nextSendNum = this.sendNum++;
        if (this.sendNum > 255) {
            this.sendNum = 0;
        }
        return nextSendNum;
    }

    protected boolean isAddressEqual(String address) {
        if (!NodeUtils.formatAddress((byte[])this.nodeAddress).equals(address)) {
            LOGGER.trace("Another node is addressed.");
            return false;
        }
        return true;
    }

    @Override
    public void queryStatus(Class<?> portClass) {
    }

    @EventSubscriber(eventClass=AccessoryStateErrorEvent.class)
    public void accessoryStateError(AccessoryStateErrorEvent accessoryStateErrorEvent) {
        LOGGER.info("The change of the accessoryStateErrorEvent was requested: {}", (Object)accessoryStateErrorEvent);
        String nodeAddress = accessoryStateErrorEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        byte accessoryNum = 1;
        byte aspect = 2;
        byte[] value = new byte[]{3, -127, 32};
        try {
            AccessoryNotifyResponse accessoryNotifyResponse = new AccessoryNotifyResponse(this.getNodeAddress(), this.getNextSendNum(), accessoryNum, aspect, value);
            this.publishResponse(accessoryNotifyResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send accessoryNotifyResponse failed.", (Throwable)ex);
        }
    }

    @EventSubscriber(eventClass=SysErrorEvent.class)
    public void sysError(SysErrorEvent sysErrorEvent) {
        LOGGER.info("The change of the sysError was requested: {}", (Object)sysErrorEvent);
        String nodeAddress = sysErrorEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        try {
            byte[] reason = null;
            switch (sysErrorEvent.getSysError()) {
                case BIDIB_ERR_ADDRSTACK: {
                    byte[] nodeAddr = this.getNodeAddress();
                    if (nodeAddr.length < 4) {
                        byte[] fullAddr = new byte[]{0, 0, 0, 0};
                        for (int index = 0; index < nodeAddr.length; ++index) {
                            byte addr;
                            fullAddr[index] = addr = nodeAddr[index];
                        }
                        nodeAddr = fullAddr;
                    }
                    reason = nodeAddr;
                    break;
                }
                default: {
                    reason = sysErrorEvent.getReason();
                }
            }
            SysErrorResponse sysErrorResponse = new SysErrorResponse(this.getNodeAddress(), this.getNextSendNum(), sysErrorEvent.getSysError(), reason){

                public byte[] getAddr() {
                    return DefaultNodeSimulator.this.getNodeAddress();
                }
            };
            this.publishResponse(sysErrorResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send sysErrorResponse failed.", (Throwable)ex);
        }
    }

    @EventSubscriber(eventClass=StallEvent.class)
    public void stall(StallEvent stallEvent) {
        LOGGER.info("The change of the stall was requested: {}", (Object)stallEvent);
        String nodeAddress = stallEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        try {
            StallResponse stallResponse = new StallResponse(this.getNodeAddress(), this.getNextSendNum(), (byte)(stallEvent.getStall() ? 1 : 0)){

                public byte[] getAddr() {
                    return DefaultNodeSimulator.this.getNodeAddress();
                }
            };
            this.publishResponse(stallResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send stallResponse failed.", (Throwable)ex);
        }
    }

    @EventSubscriber(eventClass=IdentifyEvent.class)
    public void identify(IdentifyEvent identifyEvent) {
        LOGGER.info("The change of the identify was requested: {}", (Object)identifyEvent);
        String nodeAddress = identifyEvent.getNodeAddr();
        if (!this.isAddressEqual(nodeAddress)) {
            LOGGER.trace("Another node is addressed.");
            return;
        }
        try {
            this.identifyActive = identifyEvent.getIdentify() == null ? !this.identifyActive : identifyEvent.getIdentify();
            SysIdentifyStateResponse stallResponse = new SysIdentifyStateResponse(this.getNodeAddress(), this.getNextSendNum(), this.identifyActive ? IdentifyState.ON : IdentifyState.OFF){

                public byte[] getAddr() {
                    return DefaultNodeSimulator.this.getNodeAddress();
                }
            };
            this.publishResponse(stallResponse.getContent());
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Send identifyResponse failed.", (Throwable)ex);
        }
    }

    @EventSubscriber(eventClass=NodeLostEvent.class)
    public void nodeLostEvent(NodeLostEvent nodeLostEvent) {
        byte[] nodeAddr = nodeLostEvent.getNodeAddr();
        if (!NodeUtils.isSubNode((byte[])this.nodeAddress, (byte[])nodeAddr)) {
            return;
        }
        byte nodeLocalAddress = nodeAddr[nodeAddr.length - 1];
        long uniqueId = nodeLostEvent.getUniqueId();
        LOGGER.info("The node lost event was requested, nodeLocalAddress: {}, uniqueId: {}", (Object)nodeLocalAddress, (Object)uniqueId);
        byte[] response = null;
        byte nodeTabVersion = ByteUtils.getLowByte((int)this.simulatorRegistry.getNextNodeTabVersion());
        try {
            byte addr = nodeLocalAddress;
            NodeLostResponse nodeLostResponse = new NodeLostResponse(this.nodeAddress, this.getNextSendNum(), nodeTabVersion, addr, uniqueId);
            response = nodeLostResponse.getContent();
            LOGGER.info("Prepared nodeLost response: {}", (Object)ByteUtils.bytesToHex((byte[])response));
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create nodeLost response failed.", (Throwable)ex);
        }
        LOGGER.info("Publish the current response: {}", response);
        this.publishResponse(response);
    }

    @EventSubscriber(eventClass=NodeAvailableEvent.class)
    public void nodeAvailableEvent(NodeAvailableEvent nodeAvailableEvent) {
        byte[] nodeAddr = nodeAvailableEvent.getNodeAddr();
        if (!NodeUtils.isSubNode((byte[])this.nodeAddress, (byte[])nodeAddr)) {
            return;
        }
        byte nodeLocalAddress = nodeAddr[nodeAddr.length - 1];
        long uniqueId = nodeAvailableEvent.getUniqueId();
        LOGGER.info("The node available event was requested, nodeLocalAddress: {}, uniqueId: {}", (Object)nodeLocalAddress, (Object)uniqueId);
        byte[] response = null;
        byte nodeTabVersion = ByteUtils.getLowByte((int)this.simulatorRegistry.getNextNodeTabVersion());
        try {
            byte addr = nodeLocalAddress;
            NodeNewResponse nodeNewResponse = new NodeNewResponse(this.nodeAddress, this.getNextSendNum(), nodeTabVersion, addr, uniqueId);
            response = nodeNewResponse.getContent();
            LOGGER.info("Prepared nodeNew response: {}", (Object)ByteUtils.bytesToHex((byte[])response));
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Create nodeNew response failed.", (Throwable)ex);
        }
        LOGGER.info("Publish the current response: {}", response);
        this.publishResponse(response);
    }

    protected static int getPortTypeMap(byte[] value) {
        int portTypeMap = 0;
        for (int index = 0; index < value.length; ++index) {
            portTypeMap = portTypeMap << 8 | value[index] & 0xFF;
        }
        return portTypeMap;
    }
}

