/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.plaintcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.bidib.jbidibc.messages.CRC8;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.net.serialovertcp.BidibNetAddress;
import org.bidib.jbidibc.net.serialovertcp.DataPacket;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationNetMessageHandler
implements NetMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationNetMessageHandler.class);
    private MessageReceiver messageReceiverDelegate;
    private List<BidibNetAddress> knownBidibHosts = new LinkedList<BidibNetAddress>();

    public SimulationNetMessageHandler(MessageReceiver messageReceiverDelegate) {
        this.messageReceiverDelegate = messageReceiverDelegate;
    }

    public void receive(DataPacket packet) {
        LOGGER.warn("Received a packet from address: {}, port: {}, data: {}", new Object[]{packet.getAddress(), packet.getPort(), ByteUtils.bytesToHex((byte[])packet.getData())});
        BidibNetAddress current = new BidibNetAddress(packet.getAddress(), packet.getPort());
        if (!this.knownBidibHosts.contains(current)) {
            LOGGER.info("Adding new known Bidib host: {}", (Object)current);
            this.knownBidibHosts.add(current);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(packet.getData(), 0, packet.getData().length);
        LOGGER.info("Forward received message to messageReceiverDelegate: {}, output: {}", (Object)this.messageReceiverDelegate, (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
        try {
            this.messageReceiverDelegate.receive(output);
        }
        catch (Exception ex) {
            LOGGER.warn("Process messages failed.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void send(NetBidibPort port, byte[] message) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Send message to port: {}, message: {}", (Object)port, (Object)ByteUtils.bytesToHex((byte[])message));
        }
        if (port != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                for (BidibNetAddress host : this.knownBidibHosts) {
                    bos.reset();
                    this.addDelimiter(bos);
                    int length = message[0];
                    this.escape(bos, (byte)length);
                    int txCrc = CRC8.getCrcValue((int)length);
                    for (int i = 1; i <= length; ++i) {
                        this.escape(bos, message[i]);
                        txCrc = CRC8.getCrcValue((int)((message[i] ^ txCrc) & 0xFF));
                    }
                    this.escape(bos, (byte)txCrc);
                    this.addDelimiter(bos);
                    LOGGER.info("Send message to address: {}, port: {}", (Object)host.getAddress(), (Object)host.getPortNumber());
                    port.send(bos.toByteArray(), host.getAddress(), host.getPortNumber());
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Send message to port failed.", (Throwable)ex);
                throw new RuntimeException("Send message to datagram socket failed.", ex);
            }
        } else {
            LOGGER.warn("Send not possible, the port is closed.");
        }
    }

    private void addDelimiter(ByteArrayOutputStream output) {
        output.write(ByteUtils.MAGIC);
    }

    private void escape(ByteArrayOutputStream output, byte c) {
        if (c == ByteUtils.MAGIC || c == ByteUtils.ESCAPE) {
            output.write(ByteUtils.ESCAPE);
            c = (byte)(c ^ 0x20);
        }
        output.write(c);
    }

    public void acceptClient(String remoteHost) {
        LOGGER.info("Accept client with address: {}", (Object)remoteHost);
    }

    public void cleanup(String remoteHost) {
        LOGGER.info("Cleanup client with address: {}", (Object)remoteHost);
    }
}

