/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.plaintcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.net.serialovertcp.NetBidib;
import org.bidib.jbidibc.net.serialovertcp.NetBidibPort;
import org.bidib.jbidibc.net.serialovertcp.NetBidibServerPlainTcpPort;
import org.bidib.jbidibc.net.serialovertcp.NetMessageHandler;
import org.bidib.jbidibc.simulation.SimulationInterface;
import org.bidib.jbidibc.simulation.SimulationMessageReceiver;
import org.bidib.jbidibc.simulation.SimulatorRegistry;
import org.bidib.jbidibc.simulation.plaintcp.SimulationNetMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationNetPlainTcpBidib
extends NetBidib
implements SimulationInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationNetPlainTcpBidib.class);
    private Thread portWorker;
    private NetMessageHandler netSimulationMessageHandler;
    private NetBidibPort netBidibPortSimulator;
    private SimulatorRegistry simulatorRegistry;
    private AtomicBoolean isStarted = new AtomicBoolean();
    private final String protocol;

    public SimulationNetPlainTcpBidib(String protocol) {
        this.protocol = protocol;
    }

    protected SimulatorRegistry getSimulatorRegistry() {
        return this.simulatorRegistry;
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize is called.");
        super.initialize(context);
    }

    @Override
    public void setSimulatorRegistry(SimulatorRegistry simulatorRegistry) {
        LOGGER.info("Set the simulator registry: {}", (Object)simulatorRegistry);
        this.simulatorRegistry = simulatorRegistry;
    }

    @Override
    public void start(InputStream simulationConfigurationFile, Context context) {
        LOGGER.info("Start the simulator.");
        try {
            this.netSimulationMessageHandler = this.createSimulationMessageHandler(simulationConfigurationFile, context);
            LOGGER.info("Create simulator for protocol: {}", (Object)this.protocol);
            LOGGER.info("Create a NetBidibTcpPort with the portnumber: {}", (Object)62875);
            this.netBidibPortSimulator = new NetBidibServerPlainTcpPort(62875, null, this.netSimulationMessageHandler);
            LOGGER.info("Prepare and start the port worker for netBidibPortSimulator: {}", (Object)this.netBidibPortSimulator);
            this.portWorker = new Thread((Runnable)this.netBidibPortSimulator);
            this.portWorker.start();
            this.isStarted.set(true);
        }
        catch (Exception ex) {
            LOGGER.warn("Start the simulator failed.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetMessageHandler createSimulationMessageHandler(InputStream simulationConfigurationFile, Context context) {
        this.simulatorRegistry.removeAll();
        SimulationMessageReceiver simulationMessageReceiver = new SimulationMessageReceiver(){

            @Override
            public void publishResponse(ByteArrayOutputStream output) throws ProtocolException {
                LOGGER.info("Publish the response. Prepare message to send to host using netSimulationMessageHandler: {}", (Object)SimulationNetPlainTcpBidib.this.netSimulationMessageHandler);
                try {
                    SimulationNetPlainTcpBidib.this.netSimulationMessageHandler.send(SimulationNetPlainTcpBidib.this.netBidibPortSimulator, output.toByteArray());
                }
                catch (Exception ex) {
                    LOGGER.warn("Process messages failed.", (Throwable)ex);
                }
            }

            public void removeNodeListener(NodeListener nodeListener) {
            }
        };
        simulationMessageReceiver.setSimulatorRegistry(this.simulatorRegistry);
        LOGGER.info("Load simulationConfigurationFile from: {}", (Object)simulationConfigurationFile, (Object)context);
        InputStream simulationConfiguration = null;
        try {
            simulationConfiguration = simulationConfigurationFile;
            this.simulatorRegistry.loadSimulationConfiguration(simulationConfiguration, simulationMessageReceiver, context, this.getRequestFactory());
        }
        catch (Exception ex) {
            LOGGER.warn("Open simulationConfiguration stream failed", (Throwable)ex);
        }
        finally {
            if (simulationConfiguration != null) {
                try {
                    simulationConfiguration.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Close simulationConfiguration stream failed", (Throwable)ex);
                }
            }
        }
        LOGGER.info("Simulator registry is loaded.");
        SimulationNetMessageHandler netMessageHandler = new SimulationNetMessageHandler(simulationMessageReceiver);
        LOGGER.info("Created the simulation netMessageHandler: {}", (Object)netMessageHandler);
        return netMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LOGGER.info("Stop the simulator.");
        if (this.netBidibPortSimulator != null) {
            LOGGER.info("Stop the port.");
            this.netBidibPortSimulator.stop();
            if (this.portWorker != null) {
                Thread thread = this.portWorker;
                synchronized (thread) {
                    try {
                        this.portWorker.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for termination of port worker failed.", (Throwable)ex);
                    }
                    this.portWorker = null;
                }
            }
            this.isStarted.set(false);
            this.netBidibPortSimulator = null;
        }
        LOGGER.info("Stop the simulator finished.");
    }

    public List<String> getPortIdentifiers() {
        LinkedList<String> portIdentifiers = new LinkedList<String>();
        portIdentifiers.add("mock");
        return portIdentifiers;
    }
}

