/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.AbstractBidib;
import org.bidib.jbidibc.core.AbstractMessageReceiver;
import org.bidib.jbidibc.core.MessageListener;
import org.bidib.jbidibc.core.NodeListener;
import org.bidib.jbidibc.core.message.BidibRequestFactoryMessageMapInitializer;
import org.bidib.jbidibc.core.node.NodeRegistry;
import org.bidib.jbidibc.core.node.RootNode;
import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.AbstractBaseBidib;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.serial.SerialMessageEncoder;
import org.bidib.jbidibc.simulation.SimulationBidibMessageProcessor;
import org.bidib.jbidibc.simulation.SimulationInterface;
import org.bidib.jbidibc.simulation.SimulationMessageReceiver;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.SimulatorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationSerialBidib
extends AbstractBidib
implements SimulationInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationSerialBidib.class);
    private SimulationBidibMessageProcessor simulationMessageReceiver;
    private String requestedPortName;
    private org.bidib.jbidibc.core.message.BidibRequestFactory requestFactory;
    private SimulationSerialConnector connector;
    private SimulatorRegistry simulatorRegistry;
    private boolean isOpened;

    @Override
    public void setSimulatorRegistry(SimulatorRegistry simulatorRegistry) {
        LOGGER.info("Set the simulator registry: {}", (Object)simulatorRegistry);
        this.simulatorRegistry = simulatorRegistry;
    }

    protected MessageReceiver createMessageReceiver(NodeRegistry nodeFactory, RawMessageListener rawMessageListener, Context context) {
        BidibResponseFactory responseFactory = new BidibResponseFactory();
        responseFactory.initialize();
        AbstractMessageReceiver messageReceiver = new AbstractMessageReceiver(nodeFactory, (ResponseFactory)responseFactory, true){

            public void receive(ByteArrayOutputStream data) {
                LOGGER.warn("receive is not implemented!");
            }
        };
        messageReceiver.setRawMessageListener(rawMessageListener);
        messageReceiver.init(context);
        return messageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(InputStream simulationConfigurationFile, Context context) {
        block15: {
            String simulationFilename = (String)context.get("simulationFilename", String.class, null);
            LOGGER.info("Start the simulator, simulationFilename: {}, simulationConfigurationFile: {}", (Object)simulationFilename, (Object)simulationConfigurationFile);
            this.simulatorRegistry.removeAll();
            this.requestFactory = new org.bidib.jbidibc.core.message.BidibRequestFactory();
            this.requestFactory.initialize();
            BidibRequestFactoryMessageMapInitializer.loadMessageTypeMap((BidibRequestFactory)this.requestFactory);
            InputStream simulationConfiguration = null;
            try {
                simulationConfiguration = simulationConfigurationFile;
                if (StringUtils.endsWithIgnoreCase((CharSequence)simulationFilename, (CharSequence)".xml")) {
                    this.simulatorRegistry.loadSimulationConfiguration(simulationConfiguration, this.getSimulationMessageReceiver(), context, (BidibRequestFactory)this.requestFactory);
                    break block15;
                }
                if (StringUtils.endsWithIgnoreCase((CharSequence)simulationFilename, (CharSequence)".json")) {
                    this.simulatorRegistry.loadSimulationConfigurationJson(simulationConfiguration, this.getSimulationMessageReceiver(), context, (BidibRequestFactory)this.requestFactory);
                    break block15;
                }
                LOGGER.warn("Unsupported simulationFilename provided: {}", (Object)simulationFilename);
                throw new InvalidConfigurationException("Unsupported simulationFilename provided: " + simulationFilename);
            }
            catch (InvalidConfigurationException ex) {
                LOGGER.warn("Create simulationConfiguration failed.", (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                LOGGER.warn("Open simulationConfiguration stream failed.", (Throwable)ex);
            }
            finally {
                if (simulationConfiguration != null) {
                    try {
                        simulationConfiguration.close();
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Close simulationConfiguration stream failed", (Throwable)ex);
                    }
                }
            }
        }
        this.initialize(context);
    }

    public void initialize(Context context) {
        LOGGER.info("Initialize. Create the connector.");
        super.initialize(context);
        this.connector = new SimulationSerialConnector();
        MessageReceiver serialMessageReceiver = this.getMessageReceiver();
        this.connector.setMessageReceiver(serialMessageReceiver);
        this.initializeConnector(this.connector);
    }

    private SimulationBidibMessageProcessor getSimulationMessageReceiver() {
        if (this.simulationMessageReceiver == null) {
            this.simulationMessageReceiver = new SimulationMessageReceiver(){

                @Override
                public synchronized void publishResponse(ByteArrayOutputStream output) throws ProtocolException {
                    LOGGER.info("Publish the response from the SimulationMessageReceiver to the messageReceiver: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
                    SimulationSerialBidib.this.getBidibMessageProcessor().processMessages(output);
                }

                public void removeNodeListener(NodeListener nodeListener) {
                    SimulationSerialBidib.this.getBidibMessageProcessor().removeNodeListener(nodeListener);
                }
            };
        }
        return this.simulationMessageReceiver;
    }

    @Override
    public void stop() {
        LOGGER.info("Stop was called. Stop all simulators.");
        try {
            this.simulatorRegistry.removeAll();
        }
        catch (Exception ex) {
            LOGGER.warn("Remove all simulators from the registry failed.", (Throwable)ex);
        }
    }

    @Override
    public void open(String portName, ConnectionListener connectionListener, Set<NodeListener> nodeListeners, Set<MessageListener> messageListeners, Set<TransferListener> transferListeners, Context context) throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open the serial simulation: {}", (Object)portName);
        this.requestedPortName = portName;
        this.isOpened = true;
        this.setConnectionListener(connectionListener);
        this.registerListeners(nodeListeners, messageListeners, transferListeners);
        this.connector.startReceiverAndQueues(null, context);
        this.fireConnectionOpened(this.requestedPortName);
        LOGGER.info("The port was opened internally, get the magic.");
        try {
            int magic = this.sendResetAndMagic();
            LOGGER.info("The root node returned the magic: {}", (Object)ByteUtils.magicToHex((int)magic));
        }
        catch (ProtocolException ex) {
            LOGGER.error("Send reset and magic to root node failed.", (Throwable)ex);
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void close() {
        LOGGER.info("Close the serial simulation.");
        if (this.isOpened) {
            this.isOpened = false;
            String requestedPortNameToClose = this.requestedPortName;
            this.requestedPortName = null;
            this.fireConnectionClosed(requestedPortNameToClose);
            super.close();
            this.releaseRootNode();
            this.simulationMessageReceiver = null;
            MessageReceiver messageReceiver = this.connector.getMessageReceiver();
            this.cleanupAfterClose(messageReceiver);
            this.simulationMessageReceiver = null;
            this.simulatorRegistry.removeAll();
            this.connector.stopReceiverAndQueues(null);
        }
    }

    public List<String> getPortIdentifiers() {
        LinkedList<String> portIdentifiers = new LinkedList<String>();
        portIdentifiers.add("mock");
        return portIdentifiers;
    }

    private int sendResetAndMagic() throws ProtocolException {
        RootNode rootNode = this.getRootNode();
        LOGGER.info("Send reset to the rootNode.");
        rootNode.reset();
        LOGGER.info("Enable the message receiver before send magic.");
        this.getSimulationMessageReceiver().enable();
        try {
            LOGGER.info("Wait 500ms before send the magic request.");
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait before send the magic request failed.", (Throwable)ex);
        }
        LOGGER.info("Purge the receive buffer because we will send the MAGIC request!");
        this.getSimulationMessageReceiver().purgeReceivedDataInBuffer();
        int magic = rootNode.getMagic(Integer.valueOf(1500));
        LOGGER.debug("The node returned magic: {}", (Object)magic);
        return magic;
    }

    @Override
    public void send(byte[] data) {
        this.connector.send(data);
    }

    protected int contactInterface() {
        return 0;
    }

    private class SimulationSerialConnector
    extends AbstractBaseBidib {
        private ByteArrayOutputStream output = new ByteArrayOutputStream(100);

        private SimulationSerialConnector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendData(ByteArrayOutputStream data, RawMessageListener rawMessageListener) {
            try {
                byte[] bytes = data.toByteArray();
                LOGGER.info("Send is called with bytes: {}", (Object)ByteUtils.bytesToHex((byte[])bytes));
                SerialMessageEncoder.encodeMessage((ByteArrayOutputStream)data, (OutputStream)this.output);
                if (rawMessageListener != null) {
                    rawMessageListener.notifySend(this.output.toByteArray());
                }
                List bidibMessages = SimulationSerialBidib.this.requestFactory.create(this.output.toByteArray());
                for (BidibMessageInterface bidibMessage : bidibMessages) {
                    byte[] address = ((BidibMessage)bidibMessage).getAddr();
                    String nodeAddress = NodeUtils.formatAddress((byte[])address);
                    SimulatorNode simulator = SimulationSerialBidib.this.simulatorRegistry.getSimulator(nodeAddress);
                    if (simulator == null) {
                        LOGGER.warn("No simulator found for nodeAddress: {}", (Object)nodeAddress);
                    } else {
                        simulator.processRequest(bidibMessage);
                    }
                    LOGGER.debug("Forwarded message to simulator: {}", (Object)bidibMessage);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Process request failed.", (Throwable)ex);
            }
            finally {
                this.output.reset();
            }
        }

        protected void internalOpen(String portName, Context context) throws PortNotFoundException, PortNotOpenedException {
        }
    }
}

