/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.simulation.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.nodes.MasterType;
import org.bidib.jbidibc.simulation.nodes.NodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationFactory.class);
    private Map<VidPidKey, String> mapClassName = new HashMap<VidPidKey, String>();

    public void initialize() {
        this.mapClassName.put(VidPidKey.GBMBOOST_MASTER, "org.bidib.wizard.simulation.GBMboostMasterSimulator");
        this.mapClassName.put(VidPidKey.GBMBOOST_NODE, "org.bidib.wizard.simulation.GBMboostNodeSimulator");
        this.mapClassName.put(VidPidKey.ONE_DMX, "org.bidib.wizard.simulation.OneDMXSimulator");
        this.mapClassName.put(VidPidKey.NEOCONTROL_LIGHT, "org.bidib.wizard.simulation.NeoControlSimulator");
        this.mapClassName.put(VidPidKey.NEOCONTROL_SIGNAL, "org.bidib.wizard.simulation.NeoControlSimulator");
    }

    public NodeType toNodeType(Node node) {
        VidPidKey key = VidPidKey.fromVidAndPid(NodeUtils.getVendorId((long)node.getUniqueId()), NodeUtils.getPid((long)node.getUniqueId(), (int)node.getRelevantPidBits()));
        if (key == null) {
            LOGGER.info("No key registered for node: {}", (Object)node);
            return null;
        }
        String className = this.mapClassName.get((Object)key);
        if (StringUtils.isBlank((CharSequence)className)) {
            LOGGER.info("No simulator classname registered for node: {}", (Object)node);
            return null;
        }
        NodeType nodeType = null;
        if (NodeUtils.isAddressEqual((byte[])node.getAddr(), (byte[])NodeUtils.ROOT_ADDRESS)) {
            MasterType masterNode = new MasterType();
            masterNode.withAddress(NodeUtils.formatAddress((byte[])node.getAddr())).withUniqueId(NodeUtils.getUniqueId((long)node.getUniqueId())).withClassName(className).withProductName(node.getStoredString(0)).withUserName(node.getStoredString(1)).withProtocolVersion(node.getProtocolVersion().toString()).withSoftwareVersion(node.getSoftwareVersion().toString());
            nodeType = masterNode;
        } else {
            NodeType subNode;
            nodeType = subNode = new NodeType().withAddress(NodeUtils.formatAddress((byte[])node.getAddr())).withUniqueId(NodeUtils.getUniqueId((long)node.getUniqueId())).withClassName(className).withProductName(node.getStoredString(0)).withUserName(node.getStoredString(1)).withProtocolVersion(node.getProtocolVersion().toString()).withSoftwareVersion(node.getSoftwareVersion().toString());
        }
        return nodeType;
    }

    private static enum VidPidKey {
        GBMBOOST_MASTER(13, 104),
        GBMBOOST_NODE(13, 103),
        ONE_DMX(13, 115),
        NEOCONTROL_LIGHT(13, 205),
        NEOCONTROL_SIGNAL(13, 206);

        private String key;

        private VidPidKey(int vid, int pid) {
            this.key = String.format("%d_%d", vid, pid);
        }

        public String getKey() {
            return this.key;
        }

        public static VidPidKey fromVidAndPid(int vid, int pid) {
            String key = String.format("%d_%d", vid, pid);
            for (VidPidKey current : VidPidKey.values()) {
                if (!key.equals(current.getKey())) continue;
                return current;
            }
            LOGGER.warn("No matching VidPidKey found for combination, vid: {}, pid: {}", (Object)vid, (Object)pid);
            return null;
        }
    }
}

