/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.autoconfig;

import org.bidib.wizard.common.model.settings.AbstractSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SettingsBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsBeanPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.handleSettingsBean(bean, beanName);
        return bean;
    }

    private void handleSettingsBean(Object bean, String beanName) {
        if (bean instanceof AbstractSettings) {
            try {
                LOGGER.info("Migrate settings of bean: {}", (Object)beanName);
                ((AbstractSettings)bean).migrate();
            }
            catch (Exception ex) {
                LOGGER.warn("Migrate settings failed.", (Throwable)ex);
            }
        }
    }
}

