/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.highlight;

import org.bidib.wizard.common.highlight.Scanner;
import org.bidib.wizard.common.highlight.Symbol;
import org.bidib.wizard.common.highlight.TokenTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibScriptScanner
extends Scanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibScriptScanner.class);
    public static final String KEY_DEFINE = "define";
    public static final String KEY_SET = "set";
    public static final String KEY_SELECT = "select";
    public static final String KEY_DELETE = "delete";
    public static final String KEY_ADD = "add";
    public static final String KEY_ASSERT = "assert";
    public static final String KEY_RESET = "reset";
    public static final String KEY_RESTART = "restart";
    public static final String KEY_WAIT = "wait";
    public static final String KEY_RESELECT = "reselect";
    public static final String KEY2_ANALOG = "analog";
    public static final String KEY2_MACRO = "macro";
    public static final String KEY2_SWITCH = "switch";
    public static final String KEY2_SWITCHPAIR = "switchpair";
    public static final String KEY2_SERVO = "servo";
    public static final String KEY2_SOUND = "sound";
    public static final String KEY2_LIGHT = "light";
    public static final String KEY2_MOTOR = "motor";
    public static final String KEY2_BACKLIGHT = "backlight";
    public static final String KEY2_INPUT = "input";
    public static final String KEY2_FEEDBACK = "feedback";
    public static final String KEY2_FLAG = "flag";
    public static final String KEY2_CV = "cv";
    public static final String KEY2_STEP = "step";
    public static final String KEY2_ACCESSORY = "accessory";
    public static final String KEY2_ASPECT = "aspect";
    public static final String KEY2_ASPECTNAME = "aspectname";
    public static final String KEY2_DELAY = "delay";
    public static final String KEY2_PTYPE = "ptype";
    public static final String KEY2_PNUM = "pnum";
    public static final String KEY2_ACTION = "action";
    public static final String KEY2_TARGET = "target";
    public static final String KEY2_NAME = "name";
    public static final String KEY2_NUMBER = "number";
    public static final String KEY2_MACRONAME = "macroname";
    public static final String KEY2_MACRONUMBER = "macronumber";
    public static final String KEY_CONFIG = "config";
    public static final String KEY2_PORT = "port";
    public static final String KEY2_MACROTIME = "macrotime";
    public static final String KEY2_MOVESERVOQUERY = "moveservoquery";
    public static final String KEY2_LOWERLIMIT = "lowerlimit";
    public static final String KEY2_UPPERLIMIT = "upperlimit";
    public static final String KEY2_TURNTIME = "turntime";
    public static final String KEY2_REPEAT = "repeat";
    public static final String KEY2_SLOWDOWN = "slowdown";
    public static final String KEY2_VALUEOFF = "valueoff";
    public static final String KEY2_VALUEON = "valueon";
    public static final String KEY2_DIMMOFF = "dimmoff";
    public static final String KEY2_DIMMON = "dimmon";
    public static final String KEY2_DIMMOFF88 = "dimmoff88";
    public static final String KEY2_DIMMON88 = "dimmon88";
    public static final String KEY2_MAPPING = "mapping";
    public static final String KEY2_SWITCH_CONTROL = "switchControl";
    public static final String KEY2_TICKS = "ticks";
    public static final String KEY2_LOADTYPE = "loadtype";
    public static final String KEY2_DAY = "day";
    public static final String KEY2_HOUR = "hour";
    public static final String KEY2_MINUTE = "minute";
    public static final String KEY2_STARTUP = "startup";
    public static final String KEY2_RESTORE = "restore";
    public static final String KEY2_NONE = "none";
    public static final String KEY2_PENDINGONLY = "pendingonly";
    private final boolean debug = false;
    private Symbol tempSymbol;
    private int charlength = 1;
    private int pair = 0;
    private static final byte[] KIND = new byte[128];
    private static final byte[] UNIKIND = new byte[31];

    public BidibScriptScanner() {
        this.setCaseInsensitive(true);
        this.initKind();
        this.initUniKind();
    }

    @Override
    protected void initSymbolTable() {
        this.tempSymbol = new Symbol(0, null);
        this.lookup(11, KEY_DEFINE);
        this.lookup(11, KEY_SET);
        this.lookup(11, KEY_SELECT);
        this.lookup(11, KEY_DELETE);
        this.lookup(11, KEY_ADD);
        this.lookup(11, KEY_ASSERT);
        this.lookup(11, KEY_RESET);
        this.lookup(11, KEY_RESTART);
        this.lookup(11, KEY_WAIT);
        this.lookup(11, KEY_RESELECT);
        this.lookup(11, KEY_CONFIG);
        this.lookup(12, KEY2_FEEDBACK);
        this.lookup(12, KEY2_INPUT);
        this.lookup(12, KEY2_FLAG);
        this.lookup(12, KEY2_CV);
        this.lookup(12, KEY2_STEP);
        this.lookup(12, KEY2_DELAY);
        this.lookup(12, KEY2_PTYPE);
        this.lookup(12, KEY2_PNUM);
        this.lookup(12, KEY2_ACTION);
        this.lookup(12, KEY2_TARGET);
        this.lookup(12, KEY2_MACRO);
        this.lookup(12, KEY2_ACCESSORY);
        this.lookup(12, KEY2_ASPECT);
        this.lookup(12, KEY2_ASPECTNAME);
        this.lookup(12, KEY2_PORT);
        this.lookup(12, KEY2_MACROTIME);
        this.lookup(12, KEY2_MOVESERVOQUERY);
        this.lookup(12, KEY2_LOWERLIMIT);
        this.lookup(12, KEY2_UPPERLIMIT);
        this.lookup(12, KEY2_TURNTIME);
        this.lookup(12, KEY2_NUMBER);
        this.lookup(12, KEY2_NAME);
        this.lookup(12, KEY2_MACRONAME);
        this.lookup(12, KEY2_MACRONUMBER);
        this.lookup(12, KEY2_REPEAT);
        this.lookup(12, KEY2_SLOWDOWN);
        this.lookup(12, KEY2_VALUEOFF);
        this.lookup(12, KEY2_VALUEON);
        this.lookup(12, KEY2_DIMMOFF);
        this.lookup(12, KEY2_DIMMON);
        this.lookup(12, KEY2_DIMMOFF88);
        this.lookup(12, KEY2_DIMMON88);
        this.lookup(12, KEY2_MAPPING);
        this.lookup(12, KEY2_SWITCH_CONTROL);
        this.lookup(12, KEY2_TICKS);
        this.lookup(12, KEY2_LOADTYPE);
        this.lookup(12, KEY2_DAY);
        this.lookup(12, KEY2_HOUR);
        this.lookup(12, KEY2_MINUTE);
        this.lookup(12, KEY2_STARTUP);
        this.lookup(12, KEY2_RESTORE);
        this.lookup(12, KEY2_NONE);
        this.lookup(12, KEY2_ANALOG);
        this.lookup(12, KEY2_BACKLIGHT);
        this.lookup(12, KEY2_LIGHT);
        this.lookup(12, KEY2_MOTOR);
        this.lookup(12, KEY2_SERVO);
        this.lookup(12, KEY2_SOUND);
        this.lookup(12, KEY2_SWITCH);
        this.lookup(12, KEY2_SWITCHPAIR);
        this.lookup(12, KEY2_PENDINGONLY);
    }

    @Override
    protected int read() {
        int saveStart = 0;
        if (this.start >= this.end) {
            return 1;
        }
        switch (this.state) {
            case 7: 
            case 8: {
                int type = this.readComment(7);
                this.state = type == 8 ? 1 : 7;
                return type;
            }
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        int type = c < '\u0080' ? KIND[c] : UNIKIND[Character.getType(c)];
        block3 : switch (type) {
            case 1: {
                this.start += this.charlength;
                this.charlength = 1;
                while (this.start < this.end) {
                    byte k;
                    c = this.buffer[this.start];
                    if (c == '\\') {
                        c = this.next();
                    }
                    if ((k = c < '\u0080' ? KIND[c] : UNIKIND[Character.getType(c)]) != 1) break block3;
                    this.start += this.charlength;
                    this.charlength = 1;
                }
                break;
            }
            case 0: 
            case 18: 
            case 19: {
                this.start += this.charlength;
                this.charlength = 1;
                break;
            }
            case 17: {
                this.start += this.charlength;
                this.charlength = 1;
                type = this.readOperator(c);
                break;
            }
            case 16: {
                this.start += this.charlength;
                this.charlength = 1;
                type = this.readCharLiteral();
                break;
            }
            case 15: {
                this.start += this.charlength;
                this.charlength = 1;
                type = this.readStringLiteral();
                break;
            }
            case 13: {
                this.start += this.charlength;
                this.charlength = 1;
                while (this.start < this.end) {
                    byte k;
                    c = this.buffer[this.start];
                    if (c == '\\') {
                        c = this.next();
                    }
                    if ((k = c < '\u0080' ? KIND[c] : UNIKIND[Character.getType(c)]) != 13 && k != 3) break block3;
                    this.start += this.charlength;
                    this.charlength = 1;
                }
                break;
            }
            case 3: {
                this.start += this.charlength;
                this.charlength = 1;
                type = this.readNumber(c);
                break;
            }
            case 4: {
                this.start += this.charlength;
                this.charlength = 1;
                type = this.readDot();
                break;
            }
            case 5: {
                this.start += this.charlength;
                this.charlength = 1;
                type = this.readSlash();
                if (type != 6) break;
                this.state = 7;
                break;
            }
            case 21: {
                this.start += this.charlength;
                this.charlength = 1;
                type = this.readVariable();
                break;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            if (type > -1 && type < TokenTypes.TYPENAMES.length) {
                StringBuilder sb = new StringBuilder(TokenTypes.TYPENAMES[type]);
                sb.append(" ").append(saveStart).append(",").append(this.end).append("(").append(this.start - saveStart).append(")");
                LOGGER.debug(sb.toString());
            } else {
                LOGGER.debug("Invalid type: {}", (Object)type);
            }
        }
        return type;
    }

    private int readOperator(char c) {
        if (this.start >= this.end) {
            return 17;
        }
        switch (c) {
            case ':': 
            case '?': 
            case '~': {
                break;
            }
            case '&': 
            case '+': 
            case '-': 
            case '|': {
                char c2 = this.buffer[this.start];
                if (c2 == '\\') {
                    c2 = this.next();
                }
                if (c2 != c && c2 != '=') break;
                this.start += this.charlength;
                this.charlength = 1;
                break;
            }
            case '!': 
            case '%': 
            case '*': 
            case '/': 
            case '=': 
            case '^': {
                char c2 = this.buffer[this.start];
                if (c2 == '\\') {
                    c2 = this.next();
                }
                if (c2 != '=') break;
                this.start += this.charlength;
                this.charlength = 1;
                break;
            }
            case '<': 
            case '>': {
                char c2 = this.buffer[this.start];
                if (c2 == '\\') {
                    c2 = this.next();
                }
                if (c2 == '=') {
                    this.start += this.charlength;
                    this.charlength = 1;
                    break;
                }
                if (c2 != c) break;
                this.start += this.charlength;
                this.charlength = 1;
                if (this.start >= this.end) break;
                char c3 = this.buffer[this.start];
                if (c3 == '\\') {
                    c3 = this.next();
                }
                if (c3 == '=') {
                    this.start += this.charlength;
                    this.charlength = 1;
                    break;
                }
                if (c != '>' || c3 != '>') break;
                this.start += this.charlength;
                this.charlength = 1;
                if (this.start >= this.end) break;
                char c4 = this.buffer[this.start];
                if (c4 == '\\') {
                    c4 = this.next();
                }
                if (c4 != '=') break;
                this.start += this.charlength;
                this.charlength = 1;
                break;
            }
        }
        return 17;
    }

    private int readCharLiteral() {
        if (this.start >= this.end) {
            return this.bad(16);
        }
        char c2 = this.buffer[this.start];
        if (c2 == '\\') {
            c2 = this.next();
        }
        switch (c2) {
            case '\\': {
                this.start += this.charlength;
                this.charlength = 1;
                boolean ok = this.readEscapeSequence();
                if (ok) break;
                return this.bad(16);
            }
            case '\n': 
            case '\'': {
                return this.bad(16);
            }
            default: {
                this.start += this.charlength;
                this.charlength = 1;
            }
        }
        if (this.start >= this.end) {
            return this.bad(16);
        }
        char c3 = this.buffer[this.start];
        if (c3 == '\\') {
            c3 = this.next();
        }
        if (c3 != '\'') {
            return this.bad(16);
        }
        this.start += this.charlength;
        this.charlength = 1;
        return 16;
    }

    private int readStringLiteral() {
        if (this.start >= this.end) {
            return this.bad(15);
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        while (c != '\"' && c != '\'') {
            switch (c) {
                case '\\': {
                    this.start += this.charlength;
                    this.charlength = 1;
                    boolean ok = this.readEscapeSequence();
                    if (ok) break;
                    return this.bad(15);
                }
                case '\n': {
                    return this.bad(15);
                }
                default: {
                    this.start += this.charlength;
                    this.charlength = 1;
                    if (this.start < this.end) break;
                    return this.bad(15);
                }
            }
            if ((c = this.buffer[this.start]) != '\\') continue;
            c = this.next();
        }
        if (c != '\"' && c != '\'') {
            return this.bad(15);
        }
        this.start += this.charlength;
        this.charlength = 1;
        return 15;
    }

    private int readSlash() {
        if (this.start >= this.end) {
            return 17;
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        if (c == '/') {
            while (c != '\n') {
                this.start += this.charlength;
                this.charlength = 1;
                if (this.start >= this.end) {
                    return 5;
                }
                c = this.buffer[this.start];
                if (c != '\\') continue;
                c = this.next();
            }
            this.start += this.charlength;
            this.charlength = 1;
            return 5;
        }
        if (c == '*') {
            this.start += this.charlength;
            this.charlength = 1;
            return this.readComment(6);
        }
        return this.readOperator('/');
    }

    int readComment(int type) {
        if (this.start >= this.end) {
            return type;
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        while (true) {
            if (c != '*' && c != '\n') {
                this.start += this.charlength;
                this.charlength = 1;
                if (this.start >= this.end) {
                    return type;
                }
                c = this.buffer[this.start];
                if (c != '\\') continue;
                c = this.next();
                continue;
            }
            this.start += this.charlength;
            this.charlength = 1;
            if (c == '\n') {
                return type;
            }
            if (this.start >= this.end) {
                return type;
            }
            c = this.buffer[this.start];
            if (c == '\\') {
                c = this.next();
            }
            if (c == '/') break;
        }
        this.start += this.charlength;
        this.charlength = 1;
        if (type == 6) {
            return 5;
        }
        return 8;
    }

    private int readNumber(char c) {
        if (c == '0') {
            int saveStart = this.start;
            int saveLength = this.charlength;
            this.charlength = 1;
            if (this.start >= this.end) {
                return 3;
            }
            char c2 = this.buffer[this.start];
            if (c2 == '\\') {
                c2 = this.next();
            }
            switch (c2) {
                case 'X': 
                case 'x': {
                    this.start += this.charlength;
                    this.charlength = 1;
                    boolean ok = this.readDigits(16);
                    if (!ok) {
                        return this.bad(3);
                    }
                    this.readSuffix();
                    return 3;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': {
                    this.readDigits(8);
                    this.readSuffix();
                    return 3;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    this.start = saveStart;
                    this.charlength = saveLength;
                    break;
                }
                case 'D': 
                case 'F': 
                case 'd': 
                case 'f': {
                    this.start += this.charlength;
                    this.charlength = 1;
                    return 3;
                }
                case 'L': 
                case 'l': {
                    this.start += this.charlength;
                    this.charlength = 1;
                    return 3;
                }
            }
        }
        boolean hasDigits = false;
        if ('0' <= c && c <= '9') {
            hasDigits = true;
            this.readDigits(10);
            if (this.start >= this.end) {
                return 3;
            }
            c = this.buffer[this.start];
            if (c == '\\') {
                c = this.next();
            }
            if (c == 'l' || c == 'L') {
                this.start += this.charlength;
                this.charlength = 1;
                return 3;
            }
        }
        if (c == '.') {
            this.start += this.charlength;
            this.charlength = 1;
            if (this.start >= this.end) {
                return 3;
            }
            c = this.buffer[this.start];
            if (c == '\\') {
                c = this.next();
            }
            if ('0' <= c && c <= '9') {
                hasDigits = true;
                this.readDigits(10);
                if (this.start >= this.end) {
                    return 3;
                }
                c = this.buffer[this.start];
                if (c == '\\') {
                    c = this.next();
                }
            }
        }
        if (!hasDigits) {
            return this.bad(3);
        }
        switch (c) {
            case 'E': 
            case 'e': {
                this.start += this.charlength;
                this.charlength = 1;
                if (this.start >= this.end) {
                    return this.bad(3);
                }
                c = this.buffer[this.start];
                if (c == '\\') {
                    c = this.next();
                }
                if (c == '+' || c == '-') {
                    this.start += this.charlength;
                    this.charlength = 1;
                    if (this.start >= this.end) {
                        return this.bad(3);
                    }
                    c = this.buffer[this.start];
                    if (c == '\\') {
                        this.next();
                    }
                }
                this.readDigits(10);
                break;
            }
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                this.start += this.charlength;
                this.charlength = 1;
                return 3;
            }
        }
        return 3;
    }

    boolean readDigits(int radix) {
        if (this.start >= this.end) {
            return false;
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        if (Character.digit(c, radix) == -1) {
            return false;
        }
        while (Character.digit(c, radix) != -1) {
            this.start += this.charlength;
            this.charlength = 1;
            if (this.start >= this.end) {
                return true;
            }
            c = this.buffer[this.start];
            if (c != '\\') continue;
            c = this.next();
        }
        return true;
    }

    void readSuffix() {
        if (this.start >= this.end) {
            return;
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        switch (c) {
            case 'D': 
            case 'F': 
            case 'L': 
            case 'd': 
            case 'f': 
            case 'l': {
                this.start += this.charlength;
                this.charlength = 1;
            }
        }
    }

    private int readDot() {
        if (this.start >= this.end) {
            return 19;
        }
        char c2 = this.buffer[this.start];
        if (c2 == '\\') {
            c2 = this.next();
        }
        if (Character.isDigit(c2)) {
            return this.readNumber('.');
        }
        if (this.start + 1 >= this.end) {
            return 19;
        }
        if (c2 != '.' || this.buffer[this.start + 1] != '.') {
            return 19;
        }
        this.start += 2;
        return 19;
    }

    private boolean readEscapeSequence() {
        if (this.start >= this.end) {
            return false;
        }
        char c2 = this.buffer[this.start];
        if (c2 == '\\') {
            c2 = this.next();
        }
        switch (c2) {
            case '\"': 
            case '\'': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                this.start += this.charlength;
                this.charlength = 1;
                return true;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                return this.readOctal(3);
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return this.readOctal(2);
            }
        }
        return false;
    }

    boolean readOctal(int maxlength) {
        int i;
        if (this.start >= this.end) {
            return false;
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        int val = 0;
        for (i = 0; i < maxlength && Character.digit(c, 8) != -1; ++i) {
            val = 8 * val + Character.digit(c, 8);
            this.start += this.charlength;
            this.charlength = 1;
            if (this.start >= this.end) break;
            c = this.buffer[this.start];
            if (c != '\\') continue;
            c = this.next();
        }
        return i != 0 && val <= 255;
    }

    int readVariable() {
        if (this.start >= this.end) {
            return this.bad(21);
        }
        char c = this.buffer[this.start];
        if (c == '\\') {
            c = this.next();
        }
        while (c == '_' || c == '-' || c == '+' || Character.isLetterOrDigit(c)) {
            this.start += this.charlength;
            this.charlength = 1;
            if (this.start >= this.end) {
                return 21;
            }
            c = this.buffer[this.start];
            if (c == '\\') {
                c = this.next();
                continue;
            }
            if (c != '%') continue;
            ++this.start;
            return 21;
        }
        return 21;
    }

    private int bad(int type) {
        return -type;
    }

    private char next() {
        int pos;
        if (this.start >= this.end) {
            return '\u001a';
        }
        char c = this.buffer[this.start];
        if (c != '\\') {
            return c;
        }
        if (this.start == this.pair) {
            this.pair = 0;
            return '\\';
        }
        if (this.start + 1 >= this.end) {
            return '\\';
        }
        c = this.buffer[this.start + 1];
        if (c == '\\') {
            this.pair = this.start + 1;
        }
        if (c != 'u') {
            return '\\';
        }
        for (pos = this.start + 2; pos < this.end && this.buffer[pos] == 'u'; ++pos) {
        }
        if (pos + 4 > this.end) {
            this.charlength = this.end - this.start;
            return '\u0000';
        }
        c = '\u0000';
        for (int j = 0; j < 4; ++j) {
            int d = Character.digit(this.buffer[pos + j], 16);
            if (d < 0) {
                this.charlength = pos + j - this.start;
                return '\u0000';
            }
            c = (char)(c * 16 + d);
        }
        this.charlength = pos + 4 - this.start;
        return c;
    }

    @Override
    protected Symbol lookup(int type, String name) {
        if (type != 13) {
            return super.lookup(type, name);
        }
        this.tempSymbol.type = 11;
        this.tempSymbol.name = name;
        Symbol sym = (Symbol)this.symbolTable.get(this.tempSymbol);
        if (sym != null) {
            return sym;
        }
        this.tempSymbol.type = 12;
        this.tempSymbol.name = name;
        sym = (Symbol)this.symbolTable.get(this.tempSymbol);
        if (sym != null) {
            return sym;
        }
        this.tempSymbol.type = 14;
        sym = (Symbol)this.symbolTable.get(this.tempSymbol);
        if (sym != null) {
            return sym;
        }
        return super.lookup(type, name);
    }

    private void initKind() {
        int c;
        for (c = 0; c < 128; c = (int)((char)(c + 1))) {
            BidibScriptScanner.KIND[c] = -1;
        }
        block15: for (c = 0; c < 128; c = (int)((char)(c + 1))) {
            switch (c) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 35: 
                case 64: 
                case 92: 
                case 96: 
                case 127: {
                    BidibScriptScanner.KIND[c] = 0;
                    continue block15;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 26: 
                case 32: {
                    BidibScriptScanner.KIND[c] = 1;
                    continue block15;
                }
                case 33: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 94: 
                case 124: 
                case 126: {
                    BidibScriptScanner.KIND[c] = 17;
                    continue block15;
                }
                case 34: {
                    BidibScriptScanner.KIND[c] = 15;
                    continue block15;
                }
                case 39: {
                    BidibScriptScanner.KIND[c] = 15;
                    continue block15;
                }
                case 46: {
                    BidibScriptScanner.KIND[c] = 4;
                    continue block15;
                }
                case 47: {
                    BidibScriptScanner.KIND[c] = 5;
                    continue block15;
                }
                case 36: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    BidibScriptScanner.KIND[c] = 13;
                    continue block15;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    BidibScriptScanner.KIND[c] = 3;
                    continue block15;
                }
                case 40: 
                case 41: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    BidibScriptScanner.KIND[c] = 18;
                    continue block15;
                }
                case 44: 
                case 59: {
                    BidibScriptScanner.KIND[c] = 19;
                    continue block15;
                }
                case 37: {
                    BidibScriptScanner.KIND[c] = 21;
                    continue block15;
                }
            }
        }
        for (c = 0; c < 128; c = (int)((char)(c + 1))) {
            if (KIND[c] != -1) continue;
            LOGGER.debug("Char " + c + " hasn't been classified");
        }
    }

    private void initUniKind() {
        byte b;
        for (b = 0; b < 31; b = (byte)((byte)(b + 1))) {
            BidibScriptScanner.UNIKIND[b] = -1;
        }
        block6: for (b = 0; b < 31; b = (byte)((byte)(b + 1))) {
            switch (b) {
                case 0: 
                case 7: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    BidibScriptScanner.UNIKIND[b] = 0;
                    continue block6;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 23: 
                case 26: {
                    BidibScriptScanner.UNIKIND[b] = 13;
                    continue block6;
                }
                case 6: 
                case 8: 
                case 9: 
                case 16: {
                    BidibScriptScanner.UNIKIND[b] = 3;
                    continue block6;
                }
            }
        }
        for (b = 0; b < 31; b = (byte)(b + 1)) {
            if (UNIKIND[b] != -1) continue;
            LOGGER.debug("Unicode cat " + b + " hasn't been classified");
        }
    }
}

