/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.labels;

import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryLabelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryLabelUtils.class);

    public static AccessoryLabel getAccessoryLabel(NodeLabels labels, int accessoryId) {
        AccessoryLabel accessoryLabel = null;
        if (labels != null && labels.getAccessoryLabels() != null) {
            for (AccessoryLabel currentAccessoryLabel : labels.getAccessoryLabels().getAccessoryLabel()) {
                if (currentAccessoryLabel.getIndex() != accessoryId) continue;
                accessoryLabel = currentAccessoryLabel;
                break;
            }
        } else {
            LOGGER.warn("No labels provided for accessoryId: {}", (Object)accessoryId);
        }
        if (accessoryLabel == null) {
            accessoryLabel = new AccessoryLabel();
            accessoryLabel.setIndex(accessoryId);
            if (labels.getAccessoryLabels() == null) {
                labels.setAccessoryLabels(new AccessoryLabels().withAccessoryLabel(new AccessoryLabel[]{accessoryLabel}));
            } else {
                labels.getAccessoryLabels().getAccessoryLabel().add(accessoryLabel);
            }
        }
        return accessoryLabel;
    }

    public static AccessoryLabel getAccessoryLabel(AccessoryLabels labels, int accessoryId) {
        AccessoryLabel accessoryLabel = null;
        for (AccessoryLabel label : labels.getAccessoryLabel()) {
            if (label.getIndex() != accessoryId) continue;
            accessoryLabel = label;
            break;
        }
        if (accessoryLabel == null) {
            accessoryLabel = new AccessoryLabel();
            accessoryLabel.setIndex(accessoryId);
        }
        return accessoryLabel;
    }

    public static void replaceAccessoryLabel(NodeLabels nodeLabels, int accessoryId, String labelString) {
        List accessoryLabels;
        AccessoryLabel accessoryLabel;
        if (nodeLabels.getAccessoryLabels() == null) {
            nodeLabels.setAccessoryLabels(new AccessoryLabels());
        }
        if ((accessoryLabel = (AccessoryLabel)IterableUtils.find((Iterable)(accessoryLabels = nodeLabels.getAccessoryLabels().getAccessoryLabel()), label -> label.getIndex() == accessoryId)) == null) {
            accessoryLabels.add(new AccessoryLabel().withIndex(accessoryId).withLabel(labelString));
        } else {
            accessoryLabel.setLabel(labelString);
        }
    }

    public static void replaceAspectLabel(NodeLabels nodeLabels, int accessoryId, int aspectNumber, String labelString) {
        BaseLabel aspectLabel;
        List accessoryLabels;
        AccessoryLabel accessoryLabel;
        if (nodeLabels.getAccessoryLabels() == null) {
            nodeLabels.setAccessoryLabels(new AccessoryLabels());
        }
        if ((accessoryLabel = (AccessoryLabel)IterableUtils.find((Iterable)(accessoryLabels = nodeLabels.getAccessoryLabels().getAccessoryLabel()), label -> label.getIndex() == accessoryId)) == null) {
            accessoryLabel = new AccessoryLabel().withIndex(accessoryId);
            accessoryLabels.add(accessoryLabel);
        }
        if ((aspectLabel = (BaseLabel)IterableUtils.find((Iterable)accessoryLabel.getAspectLabel(), label -> label.getIndex() == aspectNumber)) == null) {
            accessoryLabel.getAspectLabel().add(new BaseLabel().withIndex(aspectNumber).withLabel(labelString));
        } else {
            aspectLabel.setLabel(labelString);
        }
    }

    public static AccessoryLabel getStepControlAccessoryLabel(NodeLabels nodeLabels, final int accessoryId) {
        AccessoryLabel predefinedAccessoryLabel;
        AccessoryLabel accessoryLabel = null;
        accessoryLabel = new AccessoryLabel();
        accessoryLabel.setIndex(accessoryId);
        AccessoryLabels accessoryLabels = null;
        if (nodeLabels != null) {
            LOGGER.info("Use node labels from extension in vendorCV.");
            accessoryLabels = nodeLabels.getAccessoryLabels();
        }
        String predefinedLabel = null;
        if (accessoryLabels != null && (predefinedAccessoryLabel = (AccessoryLabel)IterableUtils.find((Iterable)accessoryLabels.getAccessoryLabel(), (Predicate)new Predicate<AccessoryLabel>(){

            public boolean evaluate(AccessoryLabel currentLabel) {
                return currentLabel.getIndex() == accessoryId;
            }
        })) != null) {
            predefinedLabel = predefinedAccessoryLabel.getLabel();
        }
        if (StringUtils.isNotBlank(predefinedLabel)) {
            accessoryLabel.setLabel(predefinedLabel);
        } else {
            accessoryLabel.setLabel(Resources.getString(AccessoryLabelUtils.class, (String)("stepcontrol.accessory." + accessoryId)));
        }
        return accessoryLabel;
    }

    public static BaseLabel getAccessoryAspectLabel(AccessoryLabel accessoryLabel, int aspectIndex) {
        if (accessoryLabel == null) {
            LOGGER.info("No accessory labels available.");
            return null;
        }
        List aspectLabels = accessoryLabel.getAspectLabel();
        return BidibLabelUtils.getLabel(aspectLabels, aspectIndex);
    }
}

