/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.labels;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPortLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPositionLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FlagLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.MacroLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabels;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.model.ports.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibLabelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibLabelUtils.class);

    public static BaseLabel getFeedbackPortLabel(NodeLabels nodeLabels, int labelId) {
        if (nodeLabels.getFeedbackPortLabels() == null) {
            return null;
        }
        BaseLabel portLabel = (BaseLabel)IterableUtils.find((Iterable)nodeLabels.getFeedbackPortLabels().getPortLabel(), label -> label.getIndex() == labelId);
        return portLabel;
    }

    public static BaseLabel getFeedbackPositionLabel(NodeLabels nodeLabels, int labelId) {
        if (nodeLabels.getFeedbackPositionLabels() == null) {
            return null;
        }
        BaseLabel portLabel = (BaseLabel)IterableUtils.find((Iterable)nodeLabels.getFeedbackPositionLabels().getPortLabel(), label -> label.getIndex() == labelId);
        return portLabel;
    }

    public static BaseLabel getLabel(PortLabels portLabels, WizardLabelFactory.LabelTypes labelType, int index) {
        if (portLabels == null) {
            return null;
        }
        for (PortLabel label : portLabels.getPortLabel()) {
            if (label.getType() != labelType.getPortType() || label.getIndex() != index) continue;
            return label;
        }
        return new BaseLabel();
    }

    public static Integer getPortNumberByLabel(PortLabels portLabels, WizardLabelFactory.LabelTypes labelType, String labelString) {
        if (portLabels == null) {
            return null;
        }
        for (PortLabel label : portLabels.getPortLabel()) {
            if (label.getType() != labelType.getPortType() || !label.getLabel().equalsIgnoreCase(labelString)) continue;
            return label.getIndex();
        }
        return null;
    }

    public static Integer getFeedbackPortNumberByLabel(FeedbackPortLabels portLabels, String labelString) {
        if (portLabels == null) {
            return null;
        }
        for (BaseLabel label : portLabels.getPortLabel()) {
            if (!label.getLabel().equalsIgnoreCase(labelString)) continue;
            return label.getIndex();
        }
        return null;
    }

    public static BaseLabel getMacroLabel(NodeLabels nodeLabels, int macroId) {
        if (nodeLabels.getMacroLabels() == null) {
            return null;
        }
        BaseLabel portLabel = (BaseLabel)IterableUtils.find((Iterable)nodeLabels.getMacroLabels().getMacroLabel(), label -> label.getIndex() == macroId);
        return portLabel;
    }

    public static String getNodeLabel(NodeLabels nodeLabels) {
        if (nodeLabels == null || nodeLabels.getNodeLabel() == null) {
            return null;
        }
        return nodeLabels.getNodeLabel().getUserName();
    }

    public static PortLabel getPortLabel(List<PortLabel> portLabels, WizardLabelFactory.LabelTypes labelType, int index) {
        for (PortLabel label : portLabels) {
            if (label.getType() != labelType.getPortType() || label.getIndex() != index) continue;
            return label;
        }
        PortLabel portLabel = new PortLabel().withIndex(index).withType(labelType.getPortType());
        portLabels.add(portLabel);
        return portLabel;
    }

    public static BaseLabel getLabel(List<BaseLabel> baseLabels, int index) {
        for (BaseLabel label : baseLabels) {
            if (label.getIndex() != index) continue;
            return label;
        }
        return new BaseLabel();
    }

    public static void replaceFeedbackPortLabel(NodeLabels nodeLabels, int labelId, String labelString) {
        if (nodeLabels.getFeedbackPortLabels() == null) {
            nodeLabels.setFeedbackPortLabels(new FeedbackPortLabels());
        }
        BidibLabelUtils.replaceLabel(nodeLabels.getFeedbackPortLabels().getPortLabel(), labelId, labelString);
    }

    public static void replaceFeedbackPositionLabel(NodeLabels nodeLabels, int labelId, String labelString) {
        if (nodeLabels.getFeedbackPositionLabels() == null) {
            nodeLabels.setFeedbackPositionLabels(new FeedbackPositionLabels());
        }
        BidibLabelUtils.replaceLabel(nodeLabels.getFeedbackPositionLabels().getPortLabel(), labelId, labelString);
    }

    public static void replaceFlagLabel(NodeLabels nodeLabels, int labelId, String labelString) {
        if (nodeLabels.getFlagLabels() == null) {
            nodeLabels.setFlagLabels(new FlagLabels());
        }
        BidibLabelUtils.replaceLabel(nodeLabels.getFlagLabels().getFlagLabel(), labelId, labelString);
    }

    public static void replaceMacroLabel(NodeLabels nodeLabels, int labelId, String labelString) {
        if (nodeLabels.getMacroLabels() == null) {
            nodeLabels.setMacroLabels(new MacroLabels());
        }
        BidibLabelUtils.replaceLabel(nodeLabels.getMacroLabels().getMacroLabel(), labelId, labelString);
    }

    public static void replaceNodeLabel(NodeLabels nodeLabels, String labelString) {
        if (nodeLabels.getNodeLabel() == null) {
            nodeLabels.setNodeLabel(new NodeLabel());
        }
        nodeLabels.getNodeLabel().setUserName(labelString);
    }

    public static void replaceLabel(List<BaseLabel> portLabels, int labelId, String labelString) {
        BaseLabel portLabel = (BaseLabel)IterableUtils.find(portLabels, label -> label.getIndex() == labelId);
        if (portLabel == null) {
            portLabel = new BaseLabel().withIndex(labelId).withLabel(labelString);
            portLabels.add(portLabel);
        } else {
            portLabel.setLabel(labelString);
        }
    }

    public static void replaceLabel(NodeLabels nodeLabels, WizardLabelFactory.LabelTypes labelType, int labelId, String labelString) {
        PortLabel portLabel;
        PortLabels portLabels;
        if (nodeLabels.getPortLabels() == null) {
            nodeLabels.setPortLabels(new PortLabels());
        }
        if ((portLabels = nodeLabels.getPortLabels()) == null) {
            portLabels = new PortLabels();
            nodeLabels.setPortLabels(portLabels);
        }
        if ((portLabel = BidibLabelUtils.getPortLabel(portLabels.getPortLabel(), labelType, labelId)) != null) {
            portLabel.setLabel(labelString);
        } else {
            LOGGER.warn("No port label available to replace, labelType: {}, labelId: {}, labelString: {}", new Object[]{labelType, labelId, labelString});
        }
    }

    public static <T extends Port<?>> void applyFeedbackPortLabels(NodeLabels nodeLabels, List<T> ports) {
        if (nodeLabels.getFeedbackPortLabels() == null) {
            nodeLabels.setFeedbackPortLabels(new FeedbackPortLabels());
        }
        BidibLabelUtils.applyPortLabels(nodeLabels.getFeedbackPortLabels().getPortLabel(), ports);
    }

    public static <T extends Port<?>> void applyPortLabels(NodeLabels nodeLabels, WizardLabelFactory.LabelTypes labelType, List<T> ports) {
        if (nodeLabels.getPortLabels() == null) {
            nodeLabels.setPortLabels(new PortLabels());
        }
        BidibLabelUtils.applyPortLabels(nodeLabels.getPortLabels().getPortLabel(), labelType, ports);
    }

    private static <T extends Port<?>> void applyPortLabels(List<PortLabel> portLabels, WizardLabelFactory.LabelTypes labelType, List<T> ports) {
        if (CollectionUtils.isEmpty(portLabels)) {
            LOGGER.warn("No port labels available.");
        } else {
            for (Port port : ports) {
                String labelString = BidibLabelUtils.getPortLabel(portLabels, labelType, port.getId()).getLabel();
                port.setLabel(labelString);
            }
        }
    }

    public static <T extends Port<?>> void applyPortLabels(List<BaseLabel> portLabels, List<T> ports) {
        if (CollectionUtils.isEmpty(portLabels)) {
            LOGGER.warn("No labels available.");
        } else {
            for (Port port : ports) {
                String labelString = BidibLabelUtils.getLabel(portLabels, port.getId()).getLabel();
                port.setLabel(labelString);
            }
        }
    }

    public static Map<Integer, String> getCopyOfAccessoryLabelsMap(NodeLabels inMap) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        if (inMap != null && inMap.getAccessoryLabels() != null) {
            for (AccessoryLabel labelNode : inMap.getAccessoryLabels().getAccessoryLabel()) {
                if (!StringUtils.isNotBlank((CharSequence)labelNode.getLabel())) continue;
                labelMap.put(labelNode.getIndex(), labelNode.getLabel());
            }
        }
        return labelMap;
    }

    public static Map<Integer, String> getCopyOfMacroLabelsMap(NodeLabels inMap) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        if (inMap != null && inMap.getMacroLabels() != null) {
            for (BaseLabel labelNode : inMap.getMacroLabels().getMacroLabel()) {
                if (!StringUtils.isNotBlank((CharSequence)labelNode.getLabel())) continue;
                labelMap.put(labelNode.getIndex(), labelNode.getLabel());
            }
        }
        return labelMap;
    }

    public static Map<Integer, String> getCopyOfFlagLabelsMap(NodeLabels inMap) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        if (inMap != null && inMap.getFlagLabels() != null) {
            for (BaseLabel labelNode : inMap.getFlagLabels().getFlagLabel()) {
                if (!StringUtils.isNotBlank((CharSequence)labelNode.getLabel())) continue;
                labelMap.put(labelNode.getIndex(), labelNode.getLabel());
            }
        }
        return labelMap;
    }

    public static Map<Integer, String> getCopyOfPortLabelsMap(NodeLabels inMap, WizardLabelFactory.LabelTypes labelType) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        if (inMap != null && inMap.getPortLabels() != null) {
            for (PortLabel labelNode : inMap.getPortLabels().getPortLabel()) {
                if (labelNode.getType() != labelType.getPortType() || !StringUtils.isNotBlank((CharSequence)labelNode.getLabel())) continue;
                labelMap.put(labelNode.getIndex(), labelNode.getLabel());
            }
        }
        return labelMap;
    }

    public static Map<Integer, String> getCopyOfFeedbackPortLabelsMap(NodeLabels inMap) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        if (inMap != null && inMap.getFeedbackPortLabels() != null) {
            for (BaseLabel labelNode : inMap.getFeedbackPortLabels().getPortLabel()) {
                if (!StringUtils.isNotBlank((CharSequence)labelNode.getLabel())) continue;
                labelMap.put(labelNode.getIndex(), labelNode.getLabel());
            }
        }
        return labelMap;
    }

    public static Map<Integer, String> getCopyOfFeedbackPositionLabelsMap(NodeLabels inMap) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        if (inMap != null && inMap.getFeedbackPositionLabels() != null) {
            for (BaseLabel labelNode : inMap.getFeedbackPositionLabels().getPortLabel()) {
                if (!StringUtils.isNotBlank((CharSequence)labelNode.getLabel())) continue;
                labelMap.put(labelNode.getIndex(), labelNode.getLabel());
            }
        }
        return labelMap;
    }
}

