/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.labels;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.core.schema.bidibbase.DefaultLabelsActionType;
import org.bidib.jbidibc.core.schema.bidibbase.PortType;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPortLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FeedbackPositionLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.FlagLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.MacroLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.PortLabels;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.SearchPathUtils;
import org.bidib.wizard.migration.migrator.WizardMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultWizardLabelFactory
implements WizardLabelFactory,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWizardLabelFactory.class);
    private static final String BIDIB_DEFAULT_LABEL_SUBDIR = "labels";
    protected static final String BIDIB_DEFAULT_DEFAULTLABELS_SUBDIR = "data/defaultLabels";
    private final SettingsService settingsService;
    private final Object labelMapLock = new Object();
    private final Map<Long, NodeLabels> nodeLabelsMap = new HashMap<Long, NodeLabels>();
    private final LabelFactory labelFactory;
    private boolean skipMigration;
    private String defaultLabelsSubDir = "data/defaultLabels";
    private static final String FALLBACK_LANG = "de";
    private static final Pattern PATTERN_FILENAME = Pattern.compile("bidib-default-names-(\\d+)-(\\d+)-((\\d+)\\.(\\d+)\\.(\\d+))-(\\w+).xml");

    public DefaultWizardLabelFactory(SettingsService settingsService) {
        LOGGER.info("Create the WizardLabelFactory instance.");
        this.settingsService = settingsService;
        this.labelFactory = new LabelFactory();
    }

    public boolean isSkipMigration() {
        return this.skipMigration;
    }

    public void setSkipMigration(boolean skipMigration) {
        this.skipMigration = skipMigration;
        LOGGER.warn("The migration is skipped by configuration!");
    }

    public void setDefaultLabelsSubDir(String defaultLabelsSubDir) {
        this.defaultLabelsSubDir = defaultLabelsSubDir;
    }

    public void afterPropertiesSet() throws Exception {
        String bidibConfigDir = this.getBaseDir();
        LOGGER.info("Set the path to the application labels: {}", (Object)bidibConfigDir);
        Resources.setUserLocation((String)bidibConfigDir);
        LOGGER.info("Call check and perform migration.");
        try {
            this.checkAndPerformMigration();
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Check and perform migration failed.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Check and perform migration failed.", (Throwable)ex);
        }
    }

    private String getBaseDir() {
        return this.settingsService.getMiscSettings().getBidibConfigDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultLabelsApplied getDefaultLabelsApplied(Long uniqueId, String ... searchRoot) {
        Object object = this.labelMapLock;
        synchronized (object) {
            uniqueId = NodeUtils.getUniqueIdIgnoreClassbits((Long)uniqueId);
            NodeLabels nodeLabels = this.nodeLabelsMap.get(uniqueId);
            if (nodeLabels == null) {
                try {
                    nodeLabels = this.loadLabelsFromSource(uniqueId, searchRoot);
                }
                catch (Exception ex) {
                    LOGGER.warn("Load labels to check if default lables are applied failed.", (Throwable)ex);
                }
            }
            if (nodeLabels != null) {
                return new DefaultLabelsApplied(nodeLabels.getDefaultLabelsApplied(), StringUtils.isNotBlank((CharSequence)nodeLabels.getDefaultLabelsVersion()) ? SoftwareVersion.parse((String)nodeLabels.getDefaultLabelsVersion()) : null);
            }
        }
        return new DefaultLabelsApplied(DefaultLabelsActionType.UNKNOWN, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultLabelsApplied(long uniqueId, SoftwareVersion softwareVersion, String lang, int relevantPidBits, PortModelEnum portModel, DefaultLabelsActionType defaultLabelsAction, String ... searchRoot) {
        Object object = this.labelMapLock;
        synchronized (object) {
            uniqueId = NodeUtils.getUniqueIdIgnoreClassbits((long)uniqueId);
            NodeLabels nodeLabels = this.nodeLabelsMap.get(uniqueId);
            if (nodeLabels == null) {
                try {
                    nodeLabels = this.loadLabelsFromSource(uniqueId, searchRoot);
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the labels from file failed.", (Throwable)ex);
                }
            }
            if (nodeLabels != null) {
                VersionedDefaultNodeLabelsWrapper versionedDefaultNodeLabels = null;
                if (defaultLabelsAction == DefaultLabelsActionType.APPLIED) {
                    versionedDefaultNodeLabels = this.getDefaultLabels(uniqueId, softwareVersion, relevantPidBits, lang);
                }
                if (versionedDefaultNodeLabels != null && defaultLabelsAction == DefaultLabelsActionType.APPLIED) {
                    int portId;
                    BaseLabel existingLabel;
                    String userName;
                    NodeLabels defaultNodeLabels = versionedDefaultNodeLabels.getNodeLabels();
                    if (defaultNodeLabels.getNodeLabel() != null && StringUtils.isNotBlank((CharSequence)(userName = defaultNodeLabels.getNodeLabel().getUserName()))) {
                        LOGGER.info("Set the default node label: {}", (Object)userName);
                        nodeLabels.getNodeLabel().setUserName(userName);
                    }
                    if (defaultNodeLabels.getMacroLabels() != null && CollectionUtils.isNotEmpty((Collection)defaultNodeLabels.getMacroLabels().getMacroLabel())) {
                        if (nodeLabels.getMacroLabels() == null) {
                            nodeLabels.setMacroLabels(new MacroLabels());
                        }
                        for (BaseLabel macroLabel : defaultNodeLabels.getMacroLabels().getMacroLabel()) {
                            int macroId = macroLabel.getIndex();
                            existingLabel = nodeLabels.getMacroLabels().getMacroLabel().stream().filter(macro -> macro.getIndex() == macroId).findFirst().orElse(null);
                            if (existingLabel != null) {
                                nodeLabels.getMacroLabels().getMacroLabel().remove(existingLabel);
                            }
                            LOGGER.info("Set the default macro label: {}", (Object)macroLabel);
                            nodeLabels.getMacroLabels().getMacroLabel().add(macroLabel);
                        }
                    }
                    if (defaultNodeLabels.getAccessoryLabels() != null && CollectionUtils.isNotEmpty((Collection)defaultNodeLabels.getAccessoryLabels().getAccessoryLabel())) {
                        if (nodeLabels.getAccessoryLabels() == null) {
                            nodeLabels.setAccessoryLabels(new AccessoryLabels());
                        }
                        for (AccessoryLabel accessoryLabel : defaultNodeLabels.getAccessoryLabels().getAccessoryLabel()) {
                            int accessoryId = accessoryLabel.getIndex();
                            existingLabel = nodeLabels.getAccessoryLabels().getAccessoryLabel().stream().filter(accessory -> accessory.getIndex() == accessoryId).findFirst().orElse(null);
                            if (existingLabel != null) {
                                nodeLabels.getAccessoryLabels().getAccessoryLabel().remove(existingLabel);
                            }
                            LOGGER.info("Set the default accessory label: {}", (Object)accessoryLabel);
                            nodeLabels.getAccessoryLabels().getAccessoryLabel().add(accessoryLabel);
                        }
                    }
                    if (defaultNodeLabels.getPortLabels() != null && CollectionUtils.isNotEmpty((Collection)defaultNodeLabels.getPortLabels().getPortLabel())) {
                        if (nodeLabels.getPortLabels() == null) {
                            nodeLabels.setPortLabels(new PortLabels());
                        }
                        for (PortLabel portLabel : defaultNodeLabels.getPortLabels().getPortLabel()) {
                            portId = portLabel.getIndex();
                            existingLabel = null;
                            if (portModel == PortModelEnum.type) {
                                PortType portType = portLabel.getType();
                                existingLabel = nodeLabels.getPortLabels().getPortLabel().stream().filter(port -> port.getType() == portType).filter(port -> port.getIndex() == portId).findFirst().orElse(null);
                            } else {
                                existingLabel = nodeLabels.getPortLabels().getPortLabel().stream().filter(port -> port.getIndex() == portId).findFirst().orElse(null);
                            }
                            if (existingLabel != null) {
                                nodeLabels.getPortLabels().getPortLabel().remove(existingLabel);
                            }
                            LOGGER.info("Set the default port label: {}", (Object)portLabel);
                            nodeLabels.getPortLabels().getPortLabel().add(portLabel);
                        }
                    }
                    if (defaultNodeLabels.getFlagLabels() != null && CollectionUtils.isNotEmpty((Collection)defaultNodeLabels.getFlagLabels().getFlagLabel())) {
                        if (nodeLabels.getFlagLabels() == null) {
                            nodeLabels.setFlagLabels(new FlagLabels());
                        }
                        for (BaseLabel flagLabel : defaultNodeLabels.getFlagLabels().getFlagLabel()) {
                            int flagId = flagLabel.getIndex();
                            existingLabel = nodeLabels.getFlagLabels().getFlagLabel().stream().filter(flag -> flag.getIndex() == flagId).findFirst().orElse(null);
                            if (existingLabel != null) {
                                nodeLabels.getFlagLabels().getFlagLabel().remove(existingLabel);
                            }
                            LOGGER.info("Set the default flag label: {}", (Object)flagLabel);
                            nodeLabels.getFlagLabels().getFlagLabel().add(flagLabel);
                        }
                    }
                    if (defaultNodeLabels.getFeedbackPortLabels() != null && CollectionUtils.isNotEmpty((Collection)defaultNodeLabels.getFeedbackPortLabels().getPortLabel())) {
                        if (nodeLabels.getFeedbackPortLabels() == null) {
                            nodeLabels.setFeedbackPortLabels(new FeedbackPortLabels());
                        }
                        for (PortLabel portLabel : defaultNodeLabels.getFeedbackPortLabels().getPortLabel()) {
                            portId = portLabel.getIndex();
                            existingLabel = nodeLabels.getFeedbackPortLabels().getPortLabel().stream().filter(port -> port.getIndex() == portId).findFirst().orElse(null);
                            if (existingLabel != null) {
                                nodeLabels.getFeedbackPortLabels().getPortLabel().remove(existingLabel);
                            }
                            LOGGER.info("Set the default feedbackPort label: {}", (Object)portLabel);
                            nodeLabels.getFeedbackPortLabels().getPortLabel().add(portLabel);
                        }
                    }
                    if (defaultNodeLabels.getFeedbackPositionLabels() != null && CollectionUtils.isNotEmpty((Collection)defaultNodeLabels.getFeedbackPositionLabels().getPortLabel())) {
                        if (nodeLabels.getFeedbackPositionLabels() == null) {
                            nodeLabels.setFeedbackPositionLabels(new FeedbackPositionLabels());
                        }
                        for (PortLabel portLabel : defaultNodeLabels.getFeedbackPositionLabels().getPortLabel()) {
                            portId = portLabel.getIndex();
                            existingLabel = nodeLabels.getFeedbackPositionLabels().getPortLabel().stream().filter(port -> port.getIndex() == portId).findFirst().orElse(null);
                            if (existingLabel != null) {
                                nodeLabels.getFeedbackPositionLabels().getPortLabel().remove(existingLabel);
                            }
                            LOGGER.info("Set the default feedbackPosition label: {}", (Object)portLabel);
                            nodeLabels.getFeedbackPositionLabels().getPortLabel().add(portLabel);
                        }
                    }
                }
                nodeLabels.setDefaultLabelsApplied(defaultLabelsAction);
                nodeLabels.setDefaultLabelsVersion(softwareVersion.toString());
                LOGGER.info("Save the labels after the default labels were applied.");
                this.saveLabels(uniqueId, searchRoot);
            } else {
                VersionedDefaultNodeLabelsWrapper versionedDefaultNodeLabels = null;
                if (defaultLabelsAction == DefaultLabelsActionType.APPLIED) {
                    versionedDefaultNodeLabels = this.getDefaultLabels(uniqueId, softwareVersion, relevantPidBits, lang);
                }
                LOGGER.warn("No nodeLabels found to set the defaultLabelsApplied: {}", (Object)defaultLabelsAction);
                if (versionedDefaultNodeLabels != null && defaultLabelsAction == DefaultLabelsActionType.APPLIED) {
                    LOGGER.info("Set the new default node labels as labels for the node.");
                    NodeLabels defaultNodeLabels = versionedDefaultNodeLabels.getNodeLabels();
                    defaultNodeLabels.setDefaultLabelsApplied(defaultLabelsAction);
                    defaultNodeLabels.setDefaultLabelsVersion(softwareVersion.toString());
                    if (defaultNodeLabels.getNodeLabel() == null) {
                        defaultNodeLabels.setNodeLabel(new NodeLabel());
                    }
                    defaultNodeLabels.getNodeLabel().setUniqueId(uniqueId);
                    this.nodeLabelsMap.put(uniqueId, defaultNodeLabels);
                    LOGGER.info("Save the labels after the default labels were applied.");
                    this.saveLabels(uniqueId, searchRoot);
                } else if (versionedDefaultNodeLabels == null && defaultLabelsAction == DefaultLabelsActionType.IGNORED) {
                    LOGGER.info("Create entry for ignored default labels.");
                    NodeLabels defaultNodeLabels = new NodeLabels();
                    defaultNodeLabels.setDefaultLabelsApplied(DefaultLabelsActionType.IGNORED);
                    defaultNodeLabels.setDefaultLabelsVersion(softwareVersion.toString());
                    defaultNodeLabels.setNodeLabel(new NodeLabel());
                    defaultNodeLabels.getNodeLabel().setUniqueId(uniqueId);
                    this.nodeLabelsMap.put(uniqueId, defaultNodeLabels);
                    LOGGER.info("Save the labels after the default labels were applied.");
                    this.saveLabels(uniqueId, searchRoot);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeLabels loadLabels(Long uniqueId, String ... searchRoot) {
        LOGGER.debug("Load labels for uniqueId: {}, searchRoot: {}", (Object)uniqueId, (Object)searchRoot);
        if (uniqueId == null) {
            return null;
        }
        uniqueId = NodeUtils.getUniqueIdIgnoreClassbits((Long)uniqueId);
        Object object = this.labelMapLock;
        synchronized (object) {
            NodeLabels nodeLabels = this.nodeLabelsMap.get(uniqueId);
            if (nodeLabels == null) {
                nodeLabels = this.loadLabelsFromSource(uniqueId, searchRoot);
            }
            return nodeLabels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeLabels loadLabelsFromSource(File labelsFile) {
        FileInputStream fis = null;
        NodeLabels nodeLabels = null;
        try {
            LOGGER.debug("Load labels from file: {}", (Object)labelsFile);
            fis = new FileInputStream(labelsFile);
            nodeLabels = this.labelFactory.loadLabels((InputStream)fis);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("Prepare file to load labels failed because file is not available: {}", (Object)ex.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Close file input stream failed.", (Throwable)ex);
                }
            }
        }
        return nodeLabels;
    }

    private NodeLabels loadLabelsFromSource(Long uniqueId, String ... searchRoot) {
        NodeLabels nodeLabels = null;
        try {
            String nodeFileName = LabelFactory.prepareLookupNodeFilename((long)uniqueId);
            LOGGER.debug("Search for labels of nodeFileName: {}, searchRoot: {}", (Object)nodeFileName, (Object)searchRoot);
            String path = ArrayUtils.isNotEmpty((Object[])searchRoot) && StringUtils.isNotBlank((CharSequence)searchRoot[0]) ? searchRoot[0] : this.getDefaultSearchRoot()[0];
            LOGGER.debug("Prepared search path: {}", (Object)path);
            List<File> labelFiles = SearchPathUtils.findFiles(nodeFileName, false, path);
            File labelsFile = null;
            if (CollectionUtils.isNotEmpty(labelFiles)) {
                final String exactFilename = LabelFactory.prepareNodeFilename((long)uniqueId);
                labelsFile = (File)IterableUtils.find(labelFiles, (Predicate)new Predicate<File>(){

                    public boolean evaluate(File other) {
                        return exactFilename.equals(other.getName());
                    }
                });
                if (labelsFile == null) {
                    labelsFile = labelFiles.get(0);
                    LOGGER.info("Use first matching labelsFile: {}", (Object)labelsFile.getPath());
                } else {
                    LOGGER.info("Found exact matching labelsFile: {}", (Object)labelsFile.getPath());
                }
            } else {
                nodeFileName = LabelFactory.prepareNodeFilename((long)uniqueId);
                labelsFile = new File(path, nodeFileName);
                LOGGER.info("Prepared matching labelsFile: {}", (Object)labelsFile.getPath());
            }
            nodeLabels = this.loadLabelsFromSource(labelsFile);
            if (nodeLabels == null) {
                LOGGER.info("No stored node labels found for node: {}. Create new nodeLabels.", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
                nodeLabels = new NodeLabels().withDefaultLabelsApplied(DefaultLabelsActionType.UNKNOWN).withNodeLabel(new NodeLabel().withUniqueId(uniqueId.longValue()));
            }
            if (nodeLabels != null) {
                LOGGER.info("Store nodeLabels in map, uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
                this.nodeLabelsMap.put(uniqueId, nodeLabels);
            } else {
                LOGGER.debug("No nodeLabels available for uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
            }
        }
        catch (InvalidSchemaException ex) {
            LOGGER.error("Prepare file to load labels failed.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Prepare file to load labels failed.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
        return nodeLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLabels(Long uniqueId, String ... searchRoot) {
        Object object = this.labelMapLock;
        synchronized (object) {
            uniqueId = NodeUtils.getUniqueIdIgnoreClassbits((Long)uniqueId);
            NodeLabels nodeLabels = this.nodeLabelsMap.get(uniqueId);
            if (nodeLabels != null) {
                LOGGER.info("Found nodeLabels to save for uniqueId: {}", (Object)uniqueId);
                if (nodeLabels.getNodeLabel() != null && nodeLabels.getNodeLabel().getUniqueId() != uniqueId.longValue()) {
                    LOGGER.info("Adjust the uniqueId: {}", (Object)uniqueId);
                    nodeLabels.getNodeLabel().setUniqueId(uniqueId.longValue());
                }
                String path = ArrayUtils.isNotEmpty((Object[])searchRoot) && StringUtils.isNotBlank((CharSequence)searchRoot[0]) ? searchRoot[0] : this.getDefaultSearchRoot()[0];
                File file = new File(path, LabelFactory.prepareNodeFilename((long)uniqueId));
                LOGGER.info("Save nodeLabels to file: {}", (Object)file);
                this.labelFactory.saveNodeLabel(nodeLabels, file, false);
            } else {
                LOGGER.warn("Save node labels failed for node with uniqueId: {}", (Object)uniqueId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLabels(Long uniqueId) {
        Object object = this.labelMapLock;
        synchronized (object) {
            uniqueId = NodeUtils.getUniqueIdIgnoreClassbits((Long)uniqueId);
            NodeLabels nodeLabels = this.nodeLabelsMap.remove(uniqueId);
            if (nodeLabels != null) {
                LOGGER.info("Found nodeLabels to delete for uniqueId: {}", (Object)uniqueId);
                nodeLabels = new NodeLabels().withNodeLabel(new NodeLabel().withUniqueId(uniqueId.longValue()));
                nodeLabels.setDefaultLabelsApplied(DefaultLabelsActionType.UNKNOWN);
                nodeLabels.setDefaultLabelsVersion(null);
                this.nodeLabelsMap.put(uniqueId, nodeLabels);
                this.saveLabels(uniqueId, new String[0]);
            }
        }
    }

    @Override
    public void saveDefaultLabels(NodeLabels nodeLabels, File file) {
        this.labelFactory.saveNodeLabel(nodeLabels, file, false);
    }

    protected String[] getDefaultSearchRoot() {
        String bidibConfigDir = this.getBaseDir();
        LOGGER.info("Current bidibConfigDir: {}", (Object)bidibConfigDir);
        File labelsDir = new File(bidibConfigDir, BIDIB_DEFAULT_LABEL_SUBDIR);
        if (!labelsDir.exists()) {
            try {
                LOGGER.info("Create the labels directory: {}", (Object)labelsDir);
                FileUtils.forceMkdir((File)labelsDir);
            }
            catch (Exception ex) {
                LOGGER.warn("Create the basePath of the proposed directory failed.", (Throwable)ex);
            }
        }
        return new String[]{labelsDir.getPath()};
    }

    private void checkAndPerformMigration() {
        if (this.skipMigration) {
            LOGGER.warn("The check for migration is skipped by configuration!!!");
            return;
        }
        String[] searchRoots = this.getDefaultSearchRoot();
        if (!new File(searchRoots[0]).exists()) {
            LOGGER.warn("The target path for migration does not exist. Skip migration!");
            return;
        }
        WizardMigrator migrator = new WizardMigrator();
        File migrationLogFile = migrator.getMigrationLogfile(searchRoots[0]);
        File forcedBackupLogFile = migrator.getForcedBackupLogfile(searchRoots[0]);
        LOGGER.info("Check if the migration log exists under: {}, forcedBackupLogFile: {}", (Object)migrationLogFile, (Object)forcedBackupLogFile);
        if (migrationLogFile.exists() && forcedBackupLogFile.exists()) {
            LOGGER.info("The migration and forced backup was performed already, the migration log exists under: {}, the forcedBackupLogFile exists under: {}", (Object)migrationLogFile, (Object)forcedBackupLogFile);
            return;
        }
        String targetPath = searchRoots[0];
        LOGGER.info("Prepared targetPath: {}, all searchRoots: {}", (Object)targetPath, (Object)searchRoots);
        if (!migrationLogFile.exists()) {
            LOGGER.info("Perform the migration.");
            String migrationTargetPath = null;
            try {
                migrationTargetPath = migrator.checkAndPerformMigration(targetPath, migrationLogFile, searchRoots);
            }
            catch (Exception ex) {
                LOGGER.warn("Check and perform lable migration failed.", (Throwable)ex);
            }
            if (StringUtils.isNotBlank((CharSequence)migrationTargetPath) && StringUtils.isBlank((CharSequence)this.getBaseDir())) {
                LOGGER.info("Migration returned migrationTargetPath: {}", (Object)migrationTargetPath);
                File file = new File(migrationTargetPath);
                migrationTargetPath = file.getParent();
                LOGGER.info("Update the LabelV2Path in preferences with labelPath: {}", (Object)migrationTargetPath);
                this.settingsService.getMiscSettings().setBidibConfigDir(migrationTargetPath);
                this.settingsService.storeSettings();
            }
        }
        if (!forcedBackupLogFile.exists()) {
            LOGGER.info("Perform the forced backup.");
            try {
                migrator.checkAndPerformForcedBackup(targetPath, forcedBackupLogFile);
                LOGGER.info("Check and perform forced label backup passed.");
            }
            catch (Exception ex) {
                LOGGER.warn("Check and perform forced label backup failed.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeLabels prepareDefaultLabels(Long uniqueId) {
        NodeLabels nodeLabels = null;
        Object object = this.labelMapLock;
        synchronized (object) {
            uniqueId = NodeUtils.getUniqueIdIgnoreClassbits((Long)uniqueId);
            nodeLabels = this.nodeLabelsMap.get(uniqueId);
        }
        return nodeLabels;
    }

    @Override
    public VersionedDefaultNodeLabelsWrapper isDefaultLabelsAvailable(String lang, Long uniqueId, SoftwareVersion softwareVersion, int relevantPidBits) {
        LOGGER.info("Look for default labels for uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
        uniqueId = NodeUtils.getUniqueIdIgnoreClassbits((Long)uniqueId);
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        File searchPathLabelPath = new File(labelPath, this.defaultLabelsSubDir);
        File installationPath = this.getInstallationLookupPath();
        LinkedList<File> searchPaths = new LinkedList<File>();
        if (searchPathLabelPath.exists()) {
            searchPaths.add(searchPathLabelPath);
        }
        if (installationPath.exists()) {
            searchPaths.add(installationPath);
        }
        if (CollectionUtils.isNotEmpty(searchPaths)) {
            VersionedDefaultNodeLabelsWrapper defaultNodeLabels = this.getDefaultLabels(uniqueId, softwareVersion, relevantPidBits, lang);
            return defaultNodeLabels;
        }
        LOGGER.debug("The directory to search does not exist: {}", (Object)searchPathLabelPath.toString());
        return null;
    }

    private File getInstallationLookupPath() {
        String installationPath = this.settingsService.getInstallationPath();
        LOGGER.info("Current installation path: {}", (Object)installationPath);
        File installationLookupPath = new File(installationPath);
        installationLookupPath = SystemUtils.IS_OS_MAC_OSX ? new File(installationLookupPath.getAbsoluteFile(), "Contents/Resources/" + this.defaultLabelsSubDir) : new File(installationLookupPath.getAbsoluteFile(), this.defaultLabelsSubDir);
        return installationLookupPath;
    }

    private VersionedDefaultNodeLabelsWrapper getDefaultLabels(Long uniqueId, SoftwareVersion softwareVersion, int relevantPidBits, String lang) {
        LOGGER.debug("Look for default labels for uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        File searchPathLabelPath = new File(labelPath, this.defaultLabelsSubDir);
        File installationPath = this.getInstallationLookupPath();
        LinkedList<File> searchPaths = new LinkedList<File>();
        if (searchPathLabelPath.exists()) {
            searchPaths.add(searchPathLabelPath);
        }
        if (installationPath.exists()) {
            searchPaths.add(installationPath);
        }
        if (CollectionUtils.isNotEmpty(searchPaths)) {
            int pid = NodeUtils.getPid((long)uniqueId, (int)relevantPidBits);
            int vid = NodeUtils.getVendorId((long)uniqueId);
            String shortLang = StringUtils.substringBefore((String)lang, (String)"-");
            if (softwareVersion != null) {
                String searchVersion = softwareVersion.toString();
                StringBuilder filenameSearchVersion = new StringBuilder("bidib-default-names-");
                filenameSearchVersion.append(vid).append("-").append(pid).append("-").append(searchVersion).append("-*").append(".xml");
                WildcardFileFilter fileFilterVersion = WildcardFileFilter.builder().setWildcards(new String[]{filenameSearchVersion.toString()}).setIoCase(IOCase.INSENSITIVE).get();
                LOGGER.info("Try to find bidib-default-names with versioned filter: {}", (Object)filenameSearchVersion);
                VersionedDefaultNodeLabelsWrapper searchLabels = this.searchNodeLabels((IOFileFilter)fileFilterVersion, shortLang, searchPaths.toArray(new File[0]));
                if (searchLabels != null) {
                    return searchLabels;
                }
            }
            StringBuilder filenameSearch = new StringBuilder("bidib-default-names-");
            filenameSearch.append(vid).append("-").append(pid).append("-*").append(".xml");
            WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{filenameSearch.toString()}).setIoCase(IOCase.INSENSITIVE).get();
            LOGGER.info("Try to find bidib-default-names with unversioned filter: {}", (Object)filenameSearch);
            return this.searchNodeLabels((IOFileFilter)fileFilter, shortLang, searchPaths.toArray(new File[0]));
        }
        LOGGER.debug("The directory to search does not exist: {}", (Object)searchPathLabelPath.toString());
        return null;
    }

    protected static String extractVersion(String version) {
        Matcher matcher = PATTERN_FILENAME.matcher(version);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return null;
    }

    private VersionedDefaultNodeLabelsWrapper searchNodeLabels(IOFileFilter fileFilter, String shortLang, File ... searchPaths) {
        for (File searchPath : searchPaths) {
            Collection files = FileUtils.listFiles((File)searchPath, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            LOGGER.debug("Found matching files: {}", (Object)files);
            if (!CollectionUtils.isNotEmpty((Collection)files)) continue;
            File labelsFile = files.stream().sorted((f1, f2) -> f2.getName().compareTo(f1.getName())).filter(file -> file.getName().endsWith(shortLang + ".xml")).findFirst().orElse(null);
            if (labelsFile != null) {
                LOGGER.info("Found defaultLabels file: {}", (Object)labelsFile.getPath());
                String version = DefaultWizardLabelFactory.extractVersion(labelsFile.getName());
                NodeLabels defaultNodeLabels = this.loadLabelsFromSource(labelsFile);
                return new VersionedDefaultNodeLabelsWrapper(StringUtils.isNotBlank((CharSequence)version) ? SoftwareVersion.parse((String)version) : SoftwareVersion.build((int)0, (int)0, (int)0), defaultNodeLabels);
            }
            LOGGER.warn("No default labels found for lang: {}. Try fallback to lang: {}", (Object)shortLang, (Object)FALLBACK_LANG);
            labelsFile = files.stream().sorted((f1, f2) -> f2.getName().compareTo(f1.getName())).filter(file -> file.getName().endsWith("de.xml")).findFirst().orElse(null);
            if (labelsFile == null) continue;
            LOGGER.info("Found defaultLabels file with fallback lang: {}", (Object)labelsFile.getPath());
            String version = DefaultWizardLabelFactory.extractVersion(labelsFile.getName());
            NodeLabels defaultNodeLabels = this.loadLabelsFromSource(labelsFile);
            return new VersionedDefaultNodeLabelsWrapper(StringUtils.isNotBlank((CharSequence)version) ? SoftwareVersion.parse((String)version) : SoftwareVersion.build((int)0, (int)0, (int)0), defaultNodeLabels);
        }
        return null;
    }

    public static final class VersionedDefaultNodeLabelsWrapper {
        private final SoftwareVersion defaultLabelsVersion;
        private final NodeLabels nodeLabels;

        public VersionedDefaultNodeLabelsWrapper(SoftwareVersion defaultLabelsVersion, NodeLabels nodeLabels) {
            this.defaultLabelsVersion = defaultLabelsVersion;
            this.nodeLabels = nodeLabels;
        }

        public SoftwareVersion getDefaultLabelsVersion() {
            return this.defaultLabelsVersion;
        }

        public NodeLabels getNodeLabels() {
            return this.nodeLabels;
        }

        public String toString() {
            return "VersionedDefaultNodeLabelsWrapper[defaultLabelsVersion=" + this.defaultLabelsVersion + "]";
        }
    }

    public static final class DefaultLabelsApplied {
        private final DefaultLabelsActionType defaultLabelsActionType;
        private final SoftwareVersion defaultLabelsVersion;

        public DefaultLabelsApplied(DefaultLabelsActionType defaultLabelsActionType, SoftwareVersion defaultLabelsVersion) {
            this.defaultLabelsActionType = defaultLabelsActionType;
            this.defaultLabelsVersion = defaultLabelsVersion;
        }

        public DefaultLabelsActionType getDefaultLabelsActionType() {
            return this.defaultLabelsActionType;
        }

        public SoftwareVersion getDefaultLabelsVersion() {
            return this.defaultLabelsVersion;
        }

        public String toString() {
            return "DefaultLabelsApplied, defaultLabelsActionType: " + this.defaultLabelsActionType + ", defaultLabelsVersion: " + this.defaultLabelsVersion;
        }
    }
}

