/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.labels;

import java.io.File;
import org.bidib.jbidibc.core.schema.bidibbase.DefaultLabelsActionType;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.common.labels.DefaultWizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWizardLabelWrapper
implements WizardLabelWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWizardLabelWrapper.class);
    private final WizardLabelFactory wizardLabelFactory;

    public DefaultWizardLabelWrapper(WizardLabelFactory wizardLabelFactory) {
        LOGGER.info("Create instance of DefaultWizardLabelWrapper.");
        this.wizardLabelFactory = wizardLabelFactory;
    }

    @Override
    public WizardLabelFactory getWizardLabelFactory() {
        return this.wizardLabelFactory;
    }

    @Override
    public NodeLabels loadLabels(Long uniqueId) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Load all labels for uniqueId: {}", (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
        }
        return this.wizardLabelFactory.loadLabels(uniqueId, new String[0]);
    }

    @Override
    public void saveNodeLabels(Long uniqueId) {
        this.wizardLabelFactory.saveLabels(uniqueId, new String[0]);
    }

    @Override
    public void deleteNodeLabels(Long uniqueId) {
        this.wizardLabelFactory.deleteLabels(uniqueId);
    }

    @Override
    public DefaultWizardLabelFactory.DefaultLabelsApplied getDefaultLabelsApplied(Long uniqueId) {
        DefaultWizardLabelFactory.DefaultLabelsApplied defaultLabelsApplied = this.wizardLabelFactory.getDefaultLabelsApplied(uniqueId, new String[0]);
        return defaultLabelsApplied;
    }

    @Override
    public void setDefaultLabelsApplied(String lang, Long uniqueId, SoftwareVersion softwareVersion, int relevantPidBits, PortModelEnum portModel, DefaultLabelsActionType defaultLabelsAction) {
        this.wizardLabelFactory.setDefaultLabelsApplied(uniqueId, softwareVersion, lang, relevantPidBits, portModel, defaultLabelsAction, new String[0]);
    }

    @Override
    public DefaultWizardLabelFactory.VersionedDefaultNodeLabelsWrapper isDefaultLabelsAvailable(String lang, Long uniqueId, SoftwareVersion softwareVersion, int relevantPidBits) {
        return this.wizardLabelFactory.isDefaultLabelsAvailable(lang, uniqueId, softwareVersion, relevantPidBits);
    }

    @Override
    public NodeLabels prepareDefaultLabels(Long uniqueId) {
        return this.wizardLabelFactory.prepareDefaultLabels(uniqueId);
    }

    @Override
    public void saveDefaultLabels(NodeLabels nodeLabels, File file) {
        this.wizardLabelFactory.saveDefaultLabels(nodeLabels, file);
    }
}

