/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.model.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.jgoodies.binding.beans.Model;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(value={"propertyChangeListeners", "vetoableChangeListeners", "providerKey"})
public class DebugConnectionConfiguration
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugConnectionConfiguration.class);
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_CONNECTION_URI = "connectionUri";
    public static final String PROPERTY_CONNECTION_PROVIDER = "connectionProvider";
    public static final String PROPERTY_BAUDRATE = "baudRate";
    @NotNull
    private String id;
    private String name;
    private String connectionUri;
    private String connectionProvider;
    @JsonIgnore
    private String providerKey;
    private Integer baudRate;

    public Integer getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(Integer baudRate) {
        this.baudRate = baudRate;
    }

    public DebugConnectionConfiguration withBaudRate(Integer baudRate) {
        this.setBaudRate(baudRate);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getConnectionUri() {
        return this.connectionUri;
    }

    public void setConnectionUri(String connectionUri) {
        LOGGER.info("Set the connectionUri: {}", (Object)connectionUri);
        String oldValue = this.connectionUri;
        this.connectionUri = connectionUri;
        this.firePropertyChange(PROPERTY_CONNECTION_URI, oldValue, connectionUri);
    }

    public String getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(String connectionProvider) {
        String oldValue = this.connectionProvider;
        this.connectionProvider = connectionProvider;
        this.firePropertyChange(PROPERTY_CONNECTION_PROVIDER, oldValue, connectionProvider);
    }

    public String getProviderKey() {
        return this.providerKey;
    }

    public void setProviderKey(String providerKey) {
        this.providerKey = providerKey;
    }

    public DebugConnectionConfiguration withId(String id) {
        this.setId(id);
        return this;
    }

    public DebugConnectionConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public DebugConnectionConfiguration withConnectionUri(String connectionUri) {
        this.setConnectionUri(connectionUri);
        return this;
    }

    public DebugConnectionConfiguration withConnectionProvider(String connectionProvider) {
        this.setConnectionProvider(connectionProvider);
        return this;
    }

    public static PreferencesPortType toPreferencesPortType(List<DebugConnectionConfiguration> connectionConfigurations, final String connectionId) {
        DebugConnectionConfiguration connectionConfiguration = (DebugConnectionConfiguration)((Object)IterableUtils.find(connectionConfigurations, (Predicate)new Predicate<DebugConnectionConfiguration>(){

            public boolean evaluate(DebugConnectionConfiguration config) {
                return connectionId.equals(config.getId());
            }
        }));
        if (connectionConfiguration != null) {
            String portTypeValue = connectionConfiguration.getConnectionProvider() + ":" + connectionConfiguration.getConnectionUri();
            LOGGER.info("Use the provided portTypeValue: {}", (Object)portTypeValue);
            PreferencesPortType portType = PreferencesPortType.getValue((String)portTypeValue);
            return portType;
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

