/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.common.model.settings.configuration;

import org.bidib.wizard.common.model.settings.AbstractSettings;
import org.bidib.wizard.common.model.settings.annotation.SettingsIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class SettingsIdentifierBeanFactoryPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsIdentifierBeanFactoryPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Object proxy = this.getTargetObject(bean);
        if (proxy instanceof AbstractSettings) {
            LOGGER.debug("The AbstractSettings are processed.");
            SettingsIdentifier annotation = (SettingsIdentifier)AnnotationUtils.getAnnotation(proxy.getClass(), SettingsIdentifier.class);
            if (annotation != null) {
                String storageIdentifier = annotation.storageIdentifier();
                LOGGER.debug("Current annotation name: {}", (Object)storageIdentifier);
                ((AbstractSettings)proxy).setStorageIdentifier(storageIdentifier);
            }
        }
        return bean;
    }

    private Object getTargetObject(Object proxy) throws BeansException {
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            try {
                return ((Advised)proxy).getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new FatalBeanException("Error getting target of JDK proxy", (Throwable)e);
            }
        }
        return proxy;
    }

    public int getOrder() {
        return 2147483547;
    }
}

